/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.fabric8.kubernetes.api.model.EndpointObjectReference;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "apiVersion", "creationTimestamp", "deletionTimestamp", "endpoints", "generateName", "id", "kind", "namespace", "protocol", "resourceVersion", "selfLink", "subsets", "targetRefs", "uid"})
public class Endpoints {
    @JsonProperty(value="annotations")
    @Valid
    private Map<String, String> annotations;
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1beta2");
    @JsonProperty(value="creationTimestamp")
    private String creationTimestamp;
    @JsonProperty(value="deletionTimestamp")
    private String deletionTimestamp;
    @JsonProperty(value="endpoints")
    @Valid
    private List<String> endpoints = new ArrayList<String>();
    @JsonProperty(value="generateName")
    private String generateName;
    @JsonProperty(value="id")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$")
    @Size(max=253)
    private String id;
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "Endpoints";
    @JsonProperty(value="namespace")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$")
    @Size(max=253)
    private String namespace;
    @JsonProperty(value="protocol")
    private String protocol;
    @JsonProperty(value="resourceVersion")
    private Integer resourceVersion;
    @JsonProperty(value="selfLink")
    private String selfLink;
    @JsonProperty(value="subsets")
    @Valid
    private List<EndpointSubset> subsets = new ArrayList<EndpointSubset>();
    @JsonProperty(value="targetRefs")
    @Valid
    private List<EndpointObjectReference> targetRefs = new ArrayList<EndpointObjectReference>();
    @JsonProperty(value="uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Endpoints() {
    }

    public Endpoints(Map<String, String> annotations, ApiVersion apiVersion, String creationTimestamp, String deletionTimestamp, List<String> endpoints, String generateName, String id, String kind, String namespace, String protocol, Integer resourceVersion, String selfLink, List<EndpointSubset> subsets, List<EndpointObjectReference> targetRefs, String uid) {
        this.annotations = annotations;
        this.apiVersion = apiVersion;
        this.creationTimestamp = creationTimestamp;
        this.deletionTimestamp = deletionTimestamp;
        this.endpoints = endpoints;
        this.generateName = generateName;
        this.id = id;
        this.kind = kind;
        this.namespace = namespace;
        this.protocol = protocol;
        this.resourceVersion = resourceVersion;
        this.selfLink = selfLink;
        this.subsets = subsets;
        this.targetRefs = targetRefs;
        this.uid = uid;
    }

    @JsonProperty(value="annotations")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @JsonProperty(value="annotations")
    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="creationTimestamp")
    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @JsonProperty(value="creationTimestamp")
    public void setCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    @JsonProperty(value="deletionTimestamp")
    public String getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @JsonProperty(value="deletionTimestamp")
    public void setDeletionTimestamp(String deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
    }

    @JsonProperty(value="endpoints")
    public List<String> getEndpoints() {
        return this.endpoints;
    }

    @JsonProperty(value="endpoints")
    public void setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    @JsonProperty(value="generateName")
    public String getGenerateName() {
        return this.generateName;
    }

    @JsonProperty(value="generateName")
    public void setGenerateName(String generateName) {
        this.generateName = generateName;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="protocol")
    public String getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="protocol")
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @JsonProperty(value="resourceVersion")
    public Integer getResourceVersion() {
        return this.resourceVersion;
    }

    @JsonProperty(value="resourceVersion")
    public void setResourceVersion(Integer resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    @JsonProperty(value="selfLink")
    public String getSelfLink() {
        return this.selfLink;
    }

    @JsonProperty(value="selfLink")
    public void setSelfLink(String selfLink) {
        this.selfLink = selfLink;
    }

    @JsonProperty(value="subsets")
    public List<EndpointSubset> getSubsets() {
        return this.subsets;
    }

    @JsonProperty(value="subsets")
    public void setSubsets(List<EndpointSubset> subsets) {
        this.subsets = subsets;
    }

    @JsonProperty(value="targetRefs")
    public List<EndpointObjectReference> getTargetRefs() {
        return this.targetRefs;
    }

    @JsonProperty(value="targetRefs")
    public void setTargetRefs(List<EndpointObjectReference> targetRefs) {
        this.targetRefs = targetRefs;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.annotations).append((Object)this.apiVersion).append((Object)this.creationTimestamp).append((Object)this.deletionTimestamp).append(this.endpoints).append((Object)this.generateName).append((Object)this.id).append((Object)this.kind).append((Object)this.namespace).append((Object)this.protocol).append((Object)this.resourceVersion).append((Object)this.selfLink).append(this.subsets).append(this.targetRefs).append((Object)this.uid).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Endpoints)) {
            return false;
        }
        Endpoints rhs = (Endpoints)other;
        return new EqualsBuilder().append(this.annotations, rhs.annotations).append((Object)this.apiVersion, (Object)rhs.apiVersion).append((Object)this.creationTimestamp, (Object)rhs.creationTimestamp).append((Object)this.deletionTimestamp, (Object)rhs.deletionTimestamp).append(this.endpoints, rhs.endpoints).append((Object)this.generateName, (Object)rhs.generateName).append((Object)this.id, (Object)rhs.id).append((Object)this.kind, (Object)rhs.kind).append((Object)this.namespace, (Object)rhs.namespace).append((Object)this.protocol, (Object)rhs.protocol).append((Object)this.resourceVersion, (Object)rhs.resourceVersion).append((Object)this.selfLink, (Object)rhs.selfLink).append(this.subsets, rhs.subsets).append(this.targetRefs, rhs.targetRefs).append((Object)this.uid, (Object)rhs.uid).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum ApiVersion {
        V_1_BETA_1("v1beta1"),
        V_1_BETA_2("v1beta2"),
        V_1_BETA_3("v1beta3");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

