/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.RestartPolicy;
import io.fabric8.kubernetes.api.model.RestartPolicyBuilder;
import io.fabric8.kubernetes.api.model.RestartPolicyFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerManifestFluent<T extends ContainerManifestFluent<T>>
implements Fluent<T> {
    private List<Container> containers = new ArrayList<Container>();
    private String dnsPolicy;
    private Boolean hostNetwork;
    private String id;
    private RestartPolicy restartPolicy;
    private String uuid;
    private String version;
    private List<Volume> volumes = new ArrayList<Volume>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public List<Container> getContainers() {
        return this.containers;
    }

    public T withContainers(List<Container> containers) {
        this.containers.clear();
        if (containers != null) {
            this.containers.addAll(containers);
        }
        return (T)this;
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public T withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (T)this;
    }

    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    public T withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (T)this;
    }

    public String getId() {
        return this.id;
    }

    public T withId(String id) {
        this.id = id;
        return (T)this;
    }

    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public T withRestartPolicy(RestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (T)this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public T withUuid(String uuid) {
        this.uuid = uuid;
        return (T)this;
    }

    public String getVersion() {
        return this.version;
    }

    public T withVersion(String version) {
        this.version = version;
        return (T)this;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public T withVolumes(List<Volume> volumes) {
        this.volumes.clear();
        if (volumes != null) {
            this.volumes.addAll(volumes);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public T addToContainers(Container item) {
        if (item != null) {
            this.containers.add(item);
        }
        return (T)this;
    }

    public ContainersNested<T> addNewContainer() {
        return new ContainersNested();
    }

    public RestartPolicyNested<T> withNewRestartPolicy() {
        return new RestartPolicyNested();
    }

    public T addToVolumes(Volume item) {
        if (item != null) {
            this.volumes.add(item);
        }
        return (T)this;
    }

    public VolumesNested<T> addNewVolume() {
        return new VolumesNested();
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public class VolumesNested<N>
    extends VolumeFluent<VolumesNested<N>>
    implements Nested<N> {
        private final VolumeBuilder builder = new VolumeBuilder(this);

        public N endVolume() {
            return this.and();
        }

        public N and() {
            return (N)ContainerManifestFluent.this.addToVolumes(this.builder.build());
        }
    }

    public class RestartPolicyNested<N>
    extends RestartPolicyFluent<RestartPolicyNested<N>>
    implements Nested<N> {
        private final RestartPolicyBuilder builder = new RestartPolicyBuilder(this);

        public N endRestartPolicy() {
            return this.and();
        }

        public N and() {
            return (N)ContainerManifestFluent.this.withRestartPolicy(this.builder.build());
        }
    }

    public class ContainersNested<N>
    extends ContainerFluent<ContainersNested<N>>
    implements Nested<N> {
        private final ContainerBuilder builder = new ContainerBuilder(this);

        public N endContainer() {
            return this.and();
        }

        public N and() {
            return (N)ContainerManifestFluent.this.addToContainers(this.builder.build());
        }
    }
}

