/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.ContainerManifest;
import io.fabric8.kubernetes.api.model.ContainerManifestFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerManifestBuilder
extends ContainerManifestFluent<ContainerManifestBuilder>
implements Builder<ContainerManifest> {
    private final ContainerManifestFluent<?> fluent;

    public ContainerManifestBuilder() {
        this(new ContainerManifest());
    }

    public ContainerManifestBuilder(ContainerManifestFluent<?> fluent) {
        this(fluent, new ContainerManifest());
    }

    public ContainerManifestBuilder(ContainerManifestFluent<?> fluent, ContainerManifest instance) {
        this.fluent = fluent;
        fluent.withContainers(instance.getContainers());
        fluent.withDnsPolicy(instance.getDnsPolicy());
        fluent.withHostNetwork(instance.getHostNetwork());
        fluent.withId(instance.getId());
        fluent.withRestartPolicy(instance.getRestartPolicy());
        fluent.withUuid(instance.getUuid());
        fluent.withVersion(instance.getVersion());
        fluent.withVolumes(instance.getVolumes());
    }

    public ContainerManifestBuilder(ContainerManifest instance) {
        this.fluent = this;
        this.withContainers(instance.getContainers());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withHostNetwork(instance.getHostNetwork());
        this.withId(instance.getId());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withUuid(instance.getUuid());
        this.withVersion(instance.getVersion());
        this.withVolumes(instance.getVolumes());
    }

    public ContainerManifest build() {
        ContainerManifest buildable = new ContainerManifest(this.fluent.getContainers(), this.fluent.getDnsPolicy(), this.fluent.isHostNetwork(), this.fluent.getId(), this.fluent.getRestartPolicy(), this.fluent.getUuid(), this.fluent.getVersion(), this.fluent.getVolumes());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

