/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeCondition;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractNodeStatusAssert<S extends AbstractNodeStatusAssert<S, A>, A extends NodeStatus>
extends AbstractAssert<S, A> {
    protected AbstractNodeStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((NodeStatus)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractNodeStatusAssert)this.myself));
    }

    public S hasAddresses(NodeAddress ... addresses) {
        this.isNotNull();
        if (addresses == null) {
            throw new AssertionError((Object)"Expecting addresses parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((NodeStatus)this.actual).getAddresses(), (Object[])addresses);
        return (S)((Object)((AbstractNodeStatusAssert)this.myself));
    }

    public S hasNoAddresses() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have addresses but had :\n  <%s>";
        if (((NodeStatus)this.actual).getAddresses().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((NodeStatus)this.actual).getAddresses()});
        }
        return (S)((Object)((AbstractNodeStatusAssert)this.myself));
    }

    public S hasConditions(NodeCondition ... conditions) {
        this.isNotNull();
        if (conditions == null) {
            throw new AssertionError((Object)"Expecting conditions parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((NodeStatus)this.actual).getConditions(), (Object[])conditions);
        return (S)((Object)((AbstractNodeStatusAssert)this.myself));
    }

    public S hasNoConditions() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have conditions but had :\n  <%s>";
        if (((NodeStatus)this.actual).getConditions().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((NodeStatus)this.actual).getConditions()});
        }
        return (S)((Object)((AbstractNodeStatusAssert)this.myself));
    }

    public S hasNodeInfo(NodeSystemInfo nodeInfo) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected nodeInfo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        NodeSystemInfo actualNodeInfo = ((NodeStatus)this.actual).getNodeInfo();
        if (!Objects.areEqual((Object)actualNodeInfo, (Object)nodeInfo)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, nodeInfo, actualNodeInfo});
        }
        return (S)((Object)((AbstractNodeStatusAssert)this.myself));
    }

    public S hasPhase(String phase) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPhase = ((NodeStatus)this.actual).getPhase();
        if (!Objects.areEqual((Object)actualPhase, (Object)phase)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, phase, actualPhase});
        }
        return (S)((Object)((AbstractNodeStatusAssert)this.myself));
    }
}

