/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.LivenessProbe;
import io.fabric8.kubernetes.api.model.LivenessProbeFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LivenessProbeBuilder
extends LivenessProbeFluent<LivenessProbeBuilder>
implements Builder<LivenessProbe> {
    private final LivenessProbeFluent<?> fluent;

    public LivenessProbeBuilder() {
        this(new LivenessProbe());
    }

    public LivenessProbeBuilder(LivenessProbeFluent<?> fluent) {
        this(fluent, new LivenessProbe());
    }

    public LivenessProbeBuilder(LivenessProbeFluent<?> fluent, LivenessProbe instance) {
        this.fluent = fluent;
        fluent.withExec(instance.getExec());
        fluent.withHttpGet(instance.getHttpGet());
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        fluent.withTcpSocket(instance.getTcpSocket());
    }

    public LivenessProbeBuilder(LivenessProbe instance) {
        this.fluent = this;
        this.withExec(instance.getExec());
        this.withHttpGet(instance.getHttpGet());
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        this.withTcpSocket(instance.getTcpSocket());
    }

    public LivenessProbe build() {
        LivenessProbe buildable = new LivenessProbe(this.fluent.getExec(), this.fluent.getHttpGet(), this.fluent.getInitialDelaySeconds(), this.fluent.getTcpSocket());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

