/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.EmptyDir;
import io.fabric8.kubernetes.api.model.EmptyDirFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EmptyDirBuilder
extends EmptyDirFluent<EmptyDirBuilder>
implements Builder<EmptyDir> {
    private final EmptyDirFluent<?> fluent;

    public EmptyDirBuilder() {
        this(new EmptyDir());
    }

    public EmptyDirBuilder(EmptyDirFluent<?> fluent) {
        this(fluent, new EmptyDir());
    }

    public EmptyDirBuilder(EmptyDirFluent<?> fluent, EmptyDir instance) {
        this.fluent = fluent;
    }

    public EmptyDirBuilder(EmptyDir instance) {
        this.fluent = this;
    }

    public EmptyDir build() {
        EmptyDir buildable = new EmptyDir();
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

