/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.LifecycleBuilder;
import io.fabric8.kubernetes.api.model.LifecycleFluent;
import io.fabric8.kubernetes.api.model.LivenessProbe;
import io.fabric8.kubernetes.api.model.LivenessProbeBuilder;
import io.fabric8.kubernetes.api.model.LivenessProbeFluent;
import io.fabric8.kubernetes.api.model.Port;
import io.fabric8.kubernetes.api.model.PortBuilder;
import io.fabric8.kubernetes.api.model.PortFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerFluent<T extends ContainerFluent<T>>
implements Fluent<T> {
    private List<String> command = new ArrayList<String>();
    private Integer cpu;
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private String image;
    private String imagePullPolicy;
    private Lifecycle lifecycle;
    private LivenessProbe livenessProbe;
    private Integer memory;
    private String name;
    private List<Port> ports = new ArrayList<Port>();
    private Boolean privileged;
    private String terminationMessagePath;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private String workingDir;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public List<String> getCommand() {
        return this.command;
    }

    public T withCommand(List<String> command) {
        this.command.clear();
        if (command != null) {
            this.command.addAll(command);
        }
        return (T)this;
    }

    public Integer getCpu() {
        return this.cpu;
    }

    public T withCpu(Integer cpu) {
        this.cpu = cpu;
        return (T)this;
    }

    public List<EnvVar> getEnv() {
        return this.env;
    }

    public T withEnv(List<EnvVar> env) {
        this.env.clear();
        if (env != null) {
            this.env.addAll(env);
        }
        return (T)this;
    }

    public String getImage() {
        return this.image;
    }

    public T withImage(String image) {
        this.image = image;
        return (T)this;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public T withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (T)this;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public T withLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        return (T)this;
    }

    public LivenessProbe getLivenessProbe() {
        return this.livenessProbe;
    }

    public T withLivenessProbe(LivenessProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return (T)this;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public T withMemory(Integer memory) {
        this.memory = memory;
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    public List<Port> getPorts() {
        return this.ports;
    }

    public T withPorts(List<Port> ports) {
        this.ports.clear();
        if (ports != null) {
            this.ports.addAll(ports);
        }
        return (T)this;
    }

    public Boolean isPrivileged() {
        return this.privileged;
    }

    public T withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (T)this;
    }

    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public T withTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return (T)this;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public T withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts.clear();
        if (volumeMounts != null) {
            this.volumeMounts.addAll(volumeMounts);
        }
        return (T)this;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public T withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public T addToCommand(String item) {
        if (item != null) {
            this.command.add(item);
        }
        return (T)this;
    }

    public T addToEnv(EnvVar item) {
        if (item != null) {
            this.env.add(item);
        }
        return (T)this;
    }

    public EnvNested<T> addNewEnv() {
        return new EnvNested();
    }

    public LifecycleNested<T> withNewLifecycle() {
        return new LifecycleNested();
    }

    public LivenessProbeNested<T> withNewLivenessProbe() {
        return new LivenessProbeNested();
    }

    public T addToPorts(Port item) {
        if (item != null) {
            this.ports.add(item);
        }
        return (T)this;
    }

    public PortsNested<T> addNewPort() {
        return new PortsNested();
    }

    public T addToVolumeMounts(VolumeMount item) {
        if (item != null) {
            this.volumeMounts.add(item);
        }
        return (T)this;
    }

    public VolumeMountsNested<T> addNewVolumeMount() {
        return new VolumeMountsNested();
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public class VolumeMountsNested<N>
    extends VolumeMountFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        private final VolumeMountBuilder builder = new VolumeMountBuilder(this);

        public N endVolumeMount() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.addToVolumeMounts(this.builder.build());
        }
    }

    public class PortsNested<N>
    extends PortFluent<PortsNested<N>>
    implements Nested<N> {
        private final PortBuilder builder = new PortBuilder(this);

        public N endPort() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.addToPorts(this.builder.build());
        }
    }

    public class LivenessProbeNested<N>
    extends LivenessProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        private final LivenessProbeBuilder builder = new LivenessProbeBuilder(this);

        public N endLivenessProbe() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.withLivenessProbe(this.builder.build());
        }
    }

    public class LifecycleNested<N>
    extends LifecycleFluent<LifecycleNested<N>>
    implements Nested<N> {
        private final LifecycleBuilder builder = new LifecycleBuilder(this);

        public N and() {
            return (N)ContainerFluent.this.withLifecycle(this.builder.build());
        }

        public N endLifecycle() {
            return this.and();
        }
    }

    public class EnvNested<N>
    extends EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        private final EnvVarBuilder builder = new EnvVarBuilder(this);

        public N endEnv() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.addToEnv(this.builder.build());
        }
    }
}

