/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.PodStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Condition;

public class Conditions {
    public static Condition<Pod> status(final PodStatus status) {
        return new Condition<Pod>(){

            public String toString() {
                return "podStatus(" + status + ")";
            }

            public boolean matches(Pod pod) {
                return Objects.equals(status, KubernetesHelper.getPodStatus((Pod)pod));
            }
        };
    }

    public static Condition<Pod> runningStatus() {
        return Conditions.status(PodStatus.OK);
    }

    public static Condition<Pod> waitingStatus() {
        return Conditions.status(PodStatus.WAIT);
    }

    public static Condition<Pod> errorStatus() {
        return Conditions.status(PodStatus.ERROR);
    }

    public static Condition<Pod> podLabel(final String key, final String value) {
        return new Condition<Pod>(){

            public String toString() {
                return "podLabel(" + key + " = " + value + ")";
            }

            public boolean matches(Pod pod) {
                return Conditions.matchesLabel(pod.getLabels(), key, value);
            }
        };
    }

    public static Condition<ReplicationController> replicationControllerLabel(final String key, final String value) {
        return new Condition<ReplicationController>(){

            public String toString() {
                return "replicationControllerLabel(" + key + " = " + value + ")";
            }

            public boolean matches(ReplicationController replicationControllerSchema) {
                return Conditions.matchesLabel(replicationControllerSchema.getLabels(), key, value);
            }
        };
    }

    public static Condition<Service> serviceLabel(final String key, final String value) {
        return new Condition<Service>(){

            public String toString() {
                return "serviceLabel(" + key + " = " + value + ")";
            }

            public boolean matches(Service service) {
                return Conditions.matchesLabel(service.getLabels(), key, value);
            }
        };
    }

    public static boolean matchesLabel(Map<String, String> labels, String key, String value) {
        if (labels != null) {
            String actual = labels.get(key);
            return Objects.equals(value, actual);
        }
        return false;
    }
}

