/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="api/v1")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface Kubernetes {
    public static final String ROOT_API_PATH = "api/v1";
    public static final String NAMESPACE_ALL = "";
    public static final String NAMESPACE_DEFAULT = "default";
    public static final String SERVICE_ACCOUNT_TOKEN_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/token";

    @GET
    @Path(value="namespaces")
    public NamespaceList getNamespaces();

    @POST
    @Path(value="namespaces")
    @Consumes(value={"application/json"})
    public String createNamespace(Namespace var1) throws Exception;

    @GET
    @Path(value="namespaces/{name}")
    public Namespace getNamespace(@PathParam(value="name") @NotNull String var1);

    @PUT
    @Path(value="namespaces/{name}")
    @Consumes(value={"application/json"})
    public String updateNamespace(@PathParam(value="name") @NotNull String var1, Namespace var2) throws Exception;

    @DELETE
    @Path(value="namespaces/{name}")
    @Consumes(value={"text/plain"})
    public String deleteNamespace(@PathParam(value="name") @NotNull String var1) throws Exception;

    @GET
    @Path(value="namespaces/{namespace}/pods")
    public PodList getPods(@PathParam(value="namespace") String var1);

    @POST
    @Path(value="namespaces/{namespace}/pods")
    @Consumes(value={"application/json"})
    public String createPod(Pod var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="namespaces/{namespace}/pods/{podId}")
    public Pod getPod(@PathParam(value="podId") @NotNull String var1, @PathParam(value="namespace") String var2);

    @PUT
    @Path(value="namespaces/{namespace}/pods/{podId}")
    @Consumes(value={"application/json"})
    public String updatePod(@PathParam(value="podId") @NotNull String var1, Pod var2, @PathParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="namespaces/{namespace}/pods/{podId}")
    @Consumes(value={"text/plain"})
    public String deletePod(@PathParam(value="podId") @NotNull String var1, @PathParam(value="namespace") String var2) throws Exception;

    @Path(value="namespaces/{namespace}/services")
    @GET
    @Produces(value={"application/json"})
    public ServiceList getServices(@PathParam(value="namespace") String var1);

    @Path(value="namespaces/{namespace}/services")
    @POST
    @Consumes(value={"application/json"})
    public String createService(Service var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="namespaces/{namespace}/services/{serviceId}")
    @Produces(value={"application/json"})
    public Service getService(@PathParam(value="serviceId") @NotNull String var1, @PathParam(value="namespace") String var2);

    @PUT
    @Path(value="namespaces/{namespace}/services/{serviceId}")
    @Consumes(value={"application/json"})
    public String updateService(@PathParam(value="serviceId") @NotNull String var1, Service var2, @PathParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="namespaces/{namespace}/services/{serviceId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteService(@PathParam(value="serviceId") @NotNull String var1, @PathParam(value="namespace") String var2) throws Exception;

    @Path(value="namespaces/{namespace}/replicationcontrollers")
    @GET
    @Produces(value={"application/json"})
    public ReplicationControllerList getReplicationControllers(@PathParam(value="namespace") String var1);

    @Path(value="namespaces/{namespace}/replicationcontrollers")
    @POST
    @Consumes(value={"application/json"})
    public String createReplicationController(ReplicationController var1, @PathParam(value="namespace") String var2) throws Exception;

    @PUT
    @Path(value="namespaces/{namespace}/replicationcontrollers/{controllerId}")
    @Consumes(value={"application/json"})
    public String updateReplicationController(@PathParam(value="controllerId") @NotNull String var1, ReplicationController var2, @PathParam(value="namespace") String var3) throws Exception;

    @GET
    @Path(value="namespaces/{namespace}/replicationcontrollers/{controllerId}")
    @Produces(value={"application/json"})
    public ReplicationController getReplicationController(@PathParam(value="controllerId") @NotNull String var1, @PathParam(value="namespace") String var2);

    @DELETE
    @Path(value="namespaces/{namespace}/replicationcontrollers/{controllerId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteReplicationController(@PathParam(value="controllerId") @NotNull String var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="namespaces/{namespace}/endpoints")
    public EndpointsList getEndpoints(@PathParam(value="namespace") String var1);

    @GET
    @Path(value="namespaces/{namespace}/endpoints/{serviceId}")
    public Endpoints endpointsForService(@PathParam(value="serviceId") @NotNull String var1, @PathParam(value="namespace") String var2);

    @Path(value="namespaces/{namespace}/secrets")
    @GET
    @Produces(value={"application/json"})
    public SecretList getSecrets(@PathParam(value="namespace") String var1);

    @Path(value="namespaces/{namespace}/secrets")
    @POST
    @Consumes(value={"application/json"})
    public String createSecret(Secret var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="namespaces/{namespace}/secrets/{secretId}")
    @Produces(value={"application/json"})
    public Secret getSecret(@PathParam(value="secretId") @NotNull String var1, @PathParam(value="namespace") String var2);

    @PUT
    @Path(value="namespaces/{namespace}/secrets/{secretId}")
    @Consumes(value={"application/json"})
    public String updateSecret(@PathParam(value="secretId") @NotNull String var1, Secret var2, @PathParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="namespaces/{namespace}/secrets/{secretId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteSecret(@PathParam(value="secretId") @NotNull String var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="namespaces/{namespace}/serviceaccounts")
    @Produces(value={"application/json"})
    public ServiceAccountList getServiceAccounts(@PathParam(value="namespace") String var1);

    @GET
    @Path(value="namespaces/{namespace}/serviceaccounts/{serviceAccountId}")
    @Produces(value={"application/json"})
    public ServiceAccount getServiceAccount(@PathParam(value="serviceAccountId") @NotNull String var1, @PathParam(value="namespace") String var2);

    @POST
    @Path(value="namespaces/{namespace}/serviceaccounts")
    @Consumes(value={"application/json"})
    public String createServiceAccount(ServiceAccount var1, @PathParam(value="namespace") String var2) throws Exception;

    @PUT
    @Path(value="namespaces/{namespace}/serviceaccounts/{serviceAccountId}")
    @Consumes(value={"application/json"})
    public String updateServiceAccount(@PathParam(value="serviceAccountId") @NotNull String var1, ServiceAccount var2, @PathParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="namespaces/{namespace}/serviceaccounts/{serviceAccountId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteServiceAccount(@PathParam(value="serviceAccountId") @NotNull String var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="nodes")
    public NodeList getNodes();

    @GET
    @Path(value="nodes/{nodeId}")
    public Node node(@PathParam(value="nodeId") @NotNull String var1);
}

