/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionResponseMapper
implements ResponseExceptionMapper<Exception> {
    private static final transient Logger LOG = LoggerFactory.getLogger(ExceptionResponseMapper.class);

    public Exception fromResponse(Response response) {
        try {
            Object entity = response.getEntity();
            String message = ExceptionResponseMapper.extractErrorMessage(entity);
            message = "HTTP " + response.getStatus() + " " + message;
            return new WebApplicationException(message, response);
        }
        catch (Exception ex) {
            return new Exception("Could not deserialize server side exception: " + ex.getMessage());
        }
    }

    public static String extractErrorMessage(Object entity) {
        String message;
        block8: {
            message = "No message";
            ObjectMapper mapper = KubernetesFactory.createObjectMapper();
            try {
                String json = null;
                if (entity instanceof InputStream) {
                    InputStream inputStream = (InputStream)entity;
                    json = IOHelpers.readFully((InputStream)inputStream);
                } else if (entity != null) {
                    json = entity.toString();
                }
                if (!Strings.isNotBlank(json)) break block8;
                message = json;
                if (!ExceptionResponseMapper.textLooksLikeJsonObject(json)) break block8;
                try {
                    Status error = (Status)mapper.readValue(json, Status.class);
                    if (error != null && Strings.isNullOrBlank((String)(message = error.getMessage()))) {
                        message = error.getReason();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to parse Status from JSON:" + json + ". Reason: " + e, (Throwable)e);
                }
            }
            catch (Exception e) {
                message = "Failed to extract message from request: " + e;
            }
        }
        return message;
    }

    protected static boolean textLooksLikeJsonObject(String text) {
        return (text = text.trim()).startsWith("{") && text.endsWith("}");
    }
}

