/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builds;

import io.fabric8.kubernetes.api.builds.Builds;
import io.fabric8.openshift.api.model.Build;

public class BuildFinishedEvent {
    private final String uid;
    private final Build build;
    private final boolean loading;
    private final String buildLink;

    public BuildFinishedEvent(String uid, Build build, boolean loading, String buildLink) {
        this.uid = uid;
        this.build = build;
        this.loading = loading;
        this.buildLink = buildLink;
    }

    public String getUid() {
        return this.uid;
    }

    public Build getBuild() {
        return this.build;
    }

    public String getBuildLink() {
        return this.buildLink;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public String getStatus() {
        return this.build.getStatus().getPhase();
    }

    public String getConfigName() {
        return Builds.getBuildConfigName(this.build);
    }

    public String getNamespace() {
        return Builds.getNamespace(this.build);
    }
}

