/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.UserConfigurationCompare;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.Files;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Controller {
    private static final transient Logger LOG = LoggerFactory.getLogger(Controller.class);
    private final KubernetesClient kubernetes;
    private Map<String, Pod> podMap;
    private Map<String, ReplicationController> replicationControllerMap;
    private Map<String, Service> serviceMap;
    private boolean throwExceptionOnError = true;
    private boolean allowCreate = true;
    private boolean recreateMode;
    private boolean servicesOnlyMode;
    private boolean ignoreServiceMode;
    private boolean ignoreRunningOAuthClients = true;
    private boolean processTemplatesLocally;
    private File logJsonDir;
    private File basedir;
    private boolean failOnMissingParameterValue;
    private boolean supportOAuthClients;
    private boolean deletePodsOnReplicationControllerUpdate = true;

    public Controller() {
        this(new KubernetesClient());
    }

    public Controller(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    public String apply(File file) throws Exception {
        String ext = Files.getFileExtension((File)file);
        if ("yaml".equalsIgnoreCase(ext)) {
            return this.applyYaml(file);
        }
        if ("json".equalsIgnoreCase(ext)) {
            return this.applyJson(file);
        }
        throw new IllegalArgumentException("Unknown file type " + ext);
    }

    public String applyJson(byte[] json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(String json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(File json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyYaml(String yaml) throws Exception {
        String json = this.convertYamlToJson(yaml);
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyYaml(File yaml) throws Exception {
        String json = this.convertYamlToJson(yaml);
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    private String convertYamlToJson(String yamlString) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(yamlString);
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    private String convertYamlToJson(File yamlFile) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        FileInputStream fstream = new FileInputStream(yamlFile);
        Map map = (Map)yaml.load((InputStream)fstream);
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    public String applyJson(InputStream json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public void apply(Object dto, String sourceName) throws Exception {
        if (dto instanceof List) {
            List list = (List)dto;
            for (Object element : list) {
                if (dto == element) {
                    LOG.warn("Found recursive nested object for " + dto + " of class: " + dto.getClass().getName());
                    continue;
                }
                this.apply(element, sourceName);
            }
        } else if (dto instanceof KubernetesList) {
            this.applyList((KubernetesList)dto, sourceName);
        } else if (dto != null) {
            this.applyEntity(dto, sourceName);
        }
    }

    public void applyEntity(Object dto, String sourceName) throws Exception {
        if (dto instanceof Pod) {
            this.applyPod((Pod)dto, sourceName);
        } else if (dto instanceof ReplicationController) {
            this.applyReplicationController((ReplicationController)dto, sourceName);
        } else if (dto instanceof Service) {
            this.applyService((Service)dto, sourceName);
        } else if (dto instanceof Namespace) {
            this.applyNamespace((Namespace)dto);
        } else if (dto instanceof Route) {
            this.applyRoute((Route)dto, sourceName);
        } else if (dto instanceof BuildConfig) {
            this.applyBuildConfig((BuildConfig)dto, sourceName);
        } else if (dto instanceof DeploymentConfig) {
            this.applyDeploymentConfig((DeploymentConfig)dto, sourceName);
        } else if (dto instanceof ImageStream) {
            this.applyImageStream((ImageStream)dto, sourceName);
        } else if (dto instanceof OAuthClient) {
            this.applyOAuthClient((OAuthClient)dto, sourceName);
        } else if (dto instanceof Template) {
            this.applyTemplate((Template)dto, sourceName);
        } else if (dto instanceof ServiceAccount) {
            this.applyServiceAccount((ServiceAccount)dto, sourceName);
        } else if (dto instanceof Secret) {
            this.applySecret((Secret)dto, sourceName);
        } else {
            throw new IllegalArgumentException("Unknown entity type " + dto);
        }
    }

    public void applyOAuthClient(OAuthClient entity, String sourceName) {
        if (this.supportOAuthClients) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            if (this.isServicesOnlyMode()) {
                LOG.debug("Only processing Services right now so ignoring OAuthClient: " + id);
                return;
            }
            OAuthClient old = this.kubernetes.getOAuthClient(id);
            if (this.isRunning((HasMetadata)old)) {
                if (this.isIgnoreRunningOAuthClients()) {
                    LOG.info("Not updating the OAuthClient which are shared across namespaces as its already running");
                    return;
                }
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    LOG.info("OAuthClient hasn't changed so not doing anything");
                } else if (this.isRecreateMode()) {
                    this.kubernetes.deleteOAuthClient(id);
                    this.doCreateOAuthClient(entity, sourceName);
                } else {
                    try {
                        String answer = this.kubernetes.updateOAuthClient(id, entity);
                        LOG.info("Updated pod result: " + answer);
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update pod from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating an OAuthClient from " + sourceName + " name " + KubernetesHelper.getName((HasMetadata)entity));
            } else {
                this.doCreateOAuthClient(entity, sourceName);
            }
        }
    }

    protected void doCreateOAuthClient(OAuthClient entity, String sourceName) {
        String result = null;
        try {
            result = this.kubernetes.createOAuthClient(entity);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
        }
    }

    public Object applyTemplate(Template entity, String sourceName) throws Exception {
        if (!this.isProcessTemplatesLocally()) {
            String namespace = this.getNamespace();
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            Template old = this.kubernetes.getTemplate(id, namespace);
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    LOG.info("Template hasn't changed so not doing anything");
                } else {
                    boolean recreateMode = this.isRecreateMode();
                    recreateMode = true;
                    if (recreateMode) {
                        this.kubernetes.deleteTemplate(id, namespace);
                        this.doCreateTemplate(entity, namespace, sourceName);
                    } else {
                        LOG.info("Updating a entity from " + sourceName);
                        try {
                            String answer = this.kubernetes.updateTemplate(id, entity, namespace);
                            LOG.info("Updated entity: " + answer);
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update controller from " + sourceName + ". " + e + ". " + entity, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating a entity from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity));
            } else {
                this.doCreateTemplate(entity, namespace, sourceName);
            }
        }
        return this.processTemplate(entity, sourceName);
    }

    protected void doCreateTemplate(Template entity, String namespace, String sourceName) {
        LOG.info("Creating a template from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity));
        try {
            String answer = this.kubernetes.createTemplate(entity, namespace);
            this.logGeneratedEntity("Created template: ", namespace, (HasMetadata)entity, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to template entity from " + sourceName + ". " + e + ". " + entity, e);
        }
    }

    public void applyServiceAccount(ServiceAccount serviceAccount, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)serviceAccount);
        Objects.notNull((Object)id, (String)("No name for " + serviceAccount + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring ServiceAccount: " + id);
            return;
        }
        ServiceAccount old = this.kubernetes.getServiceAccount(id, namespace);
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(serviceAccount, old)) {
                LOG.info("ServiceAccount hasn't changed so not doing anything");
            } else if (this.isRecreateMode()) {
                this.kubernetes.deleteServiceAccount(serviceAccount, namespace);
                this.doCreateServiceAccount(serviceAccount, namespace, sourceName);
            } else {
                LOG.info("Updating a service account from " + sourceName);
                try {
                    String answer = this.kubernetes.updateServiceAccount(id, serviceAccount, namespace);
                    this.logGeneratedEntity("Updated service account: ", namespace, (HasMetadata)serviceAccount, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update service account from " + sourceName + ". " + e + ". " + serviceAccount, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)serviceAccount));
        } else {
            this.doCreateServiceAccount(serviceAccount, namespace, sourceName);
        }
    }

    protected void doCreateServiceAccount(ServiceAccount serviceAccount, String namespace, String sourceName) {
        LOG.info("Creating a service account from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)serviceAccount));
        try {
            String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createServiceAccount(serviceAccount, namespace) : this.kubernetes.createServiceAccount(serviceAccount);
            this.logGeneratedEntity("Created service account: ", namespace, (HasMetadata)serviceAccount, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create service account from " + sourceName + ". " + e + ". " + serviceAccount, e);
        }
    }

    public void applySecret(Secret secret, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)secret);
        Objects.notNull((Object)id, (String)("No name for " + secret + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring Secrets: " + id);
            return;
        }
        Secret old = this.kubernetes.getSecret(id, namespace);
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(secret, old)) {
                LOG.info("Secret hasn't changed so not doing anything");
                return;
            }
            if (this.isRecreateMode()) {
                this.kubernetes.deleteSecret(id, namespace);
                this.doCreateSecret(secret, namespace, sourceName);
            } else {
                LOG.info("Updateing a secret from " + sourceName);
                try {
                    String answer = this.kubernetes.updateSecret(id, secret, namespace);
                    this.logGeneratedEntity("Updated secret:", namespace, (HasMetadata)secret, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update secret from " + sourceName + ". " + e + ". " + secret, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a secret from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)secret));
        } else {
            this.doCreateSecret(secret, namespace, sourceName);
        }
    }

    protected void doCreateSecret(Secret secret, String namespace, String sourceName) {
        LOG.info("Creating a secret from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)secret));
        try {
            String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createSecret(secret, namespace) : this.kubernetes.createSecret(secret, this.getNamespace());
            this.logGeneratedEntity("Created secret: ", namespace, (HasMetadata)secret, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create secret from " + sourceName + ". " + e + ". " + secret, e);
        }
    }

    protected void logGeneratedEntity(String message, String namespace, HasMetadata entity, Object result) {
        if (this.logJsonDir != null) {
            File namespaceDir = new File(this.logJsonDir, namespace);
            namespaceDir.mkdirs();
            String kind = KubernetesHelper.getKind(entity);
            String name = KubernetesHelper.getName(entity);
            if (Strings.isNotBlank((String)kind)) {
                name = kind.toLowerCase() + "-" + name;
            }
            if (Strings.isNullOrBlank((String)name)) {
                LOG.warn("No name for the entity " + entity);
            } else {
                String text;
                String fileName = name + ".json";
                File file = new File(namespaceDir, fileName);
                if (file.exists()) {
                    int idx = 1;
                    while ((file = new File(namespaceDir, fileName = name + "-" + idx++ + ".json")).exists()) {
                    }
                }
                if (result instanceof String) {
                    text = result.toString();
                } else {
                    try {
                        text = KubernetesHelper.toJson(result);
                    }
                    catch (JsonProcessingException e) {
                        LOG.warn("Could not convert " + result + " to JSON: " + (Object)((Object)e), (Throwable)e);
                        text = result != null ? result.toString() : "null";
                    }
                }
                try {
                    String path;
                    IOHelpers.writeFully((File)file, (String)text);
                    Object fileLocation = file;
                    if (this.basedir != null && (path = Files.getRelativePath((File)this.basedir, (File)file)) != null) {
                        fileLocation = Strings.stripPrefix((String)path, (String)"/");
                    }
                    LOG.info(message + fileLocation);
                }
                catch (IOException e) {
                    LOG.warn("Failed to write to file " + file + ". " + e, (Throwable)e);
                }
                return;
            }
        }
        LOG.info(message + result);
    }

    public Object processTemplate(Template entity, String sourceName) {
        if (this.isProcessTemplatesLocally()) {
            try {
                return Templates.processTemplatesLocally(entity, this.failOnMissingParameterValue);
            }
            catch (IOException e) {
                this.onApplyError("Failed to process template " + sourceName + ". " + e + ". " + entity, e);
                return null;
            }
        }
        String id = KubernetesHelper.getName((HasMetadata)entity);
        Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
        String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
        LOG.info("Creating Template " + namespace + ":" + id + " " + KubernetesHelper.summaryText(entity));
        Object result = null;
        try {
            String json = this.kubernetes.processTemplate(entity, namespace);
            this.logGeneratedEntity("Template processed into: ", namespace, (HasMetadata)entity, json);
            result = KubernetesHelper.loadJson(json);
            this.printSummary(result);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create controller from " + sourceName + ". " + e + ". " + entity, e);
        }
        return result;
    }

    protected void printSummary(Object kubeResource) throws IOException {
        if (kubeResource != null) {
            LOG.debug("  " + kubeResource.getClass().getSimpleName() + " " + kubeResource);
        }
        if (kubeResource instanceof Template) {
            Template template = (Template)kubeResource;
            String id = KubernetesHelper.getName((HasMetadata)template);
            LOG.info("  Template " + id + " " + KubernetesHelper.summaryText(template));
            this.printSummary(template.getObjects());
            return;
        }
        List<HasMetadata> list = KubernetesHelper.toItemList(kubeResource);
        for (HasMetadata object : list) {
            if (object == null) continue;
            if (object == list) {
                LOG.warn("Ignoring recursive list " + list);
                continue;
            }
            if (object instanceof List) {
                this.printSummary(object);
                continue;
            }
            String kind = object.getClass().getSimpleName();
            String id = KubernetesHelper.getObjectId(object);
            LOG.info("    " + kind + " " + id + " " + KubernetesHelper.summaryText(object));
        }
    }

    public void applyRoute(Route entity, String sourceName) {
        Route route;
        String id = KubernetesHelper.getName((HasMetadata)entity);
        Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
        String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
        if (Strings.isNullOrBlank((String)namespace)) {
            namespace = this.kubernetes.getNamespace();
        }
        if ((route = this.kubernetes.findRoute(id, namespace)) == null) {
            try {
                LOG.info("Creating Route " + namespace + ":" + id + " " + KubernetesHelper.summaryText(entity));
                this.kubernetes.createRoute(entity, namespace);
            }
            catch (WebApplicationException e) {
                if (e.getResponse().getStatus() == 404) {
                    LOG.warn("Got a 404 - could be an old Kubernetes/OpenShift environment - lets try the old style REST API...");
                    try {
                        this.kubernetes.createRouteOldAPi(entity, namespace);
                    }
                    catch (Exception e1) {
                        this.onApplyError("Failed to create Route from " + sourceName + ". " + e1 + ". " + entity, e1);
                    }
                } else {
                    this.onApplyError("Failed to create Route from " + sourceName + ". " + (Object)((Object)e) + ". " + entity, (Exception)((Object)e));
                }
            }
            catch (Exception e) {
                this.onApplyError("Failed to create Route from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public void applyBuildConfig(BuildConfig entity, String sourceName) {
        BuildConfig old;
        String id = KubernetesHelper.getName((HasMetadata)entity);
        Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
        String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
        if (Strings.isNullOrBlank((String)namespace)) {
            namespace = this.kubernetes.getNamespace();
        }
        if (this.isRunning((HasMetadata)(old = this.kubernetes.getBuildConfig(id, namespace)))) {
            if (UserConfigurationCompare.configEqual(entity, old)) {
                LOG.info("BuildConfig hasn't changed so not doing anything");
            } else if (this.isRecreateMode()) {
                this.kubernetes.deleteBuildConfig(id, namespace);
                this.doCreateBuildConfig(entity, namespace, sourceName);
            } else {
                LOG.info("Updating BuildConfig from " + sourceName);
                try {
                    String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)old);
                    ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
                    metadata.setNamespace(namespace);
                    metadata.setResourceVersion(resourceVersion);
                    String answer = this.kubernetes.updateBuildConfig(id, entity, namespace);
                    this.logGeneratedEntity("Updated BuildConfig: ", namespace, (HasMetadata)entity, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update BuildConfig from " + sourceName + ". " + e + ". " + entity, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating BuildConfig from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity));
        } else {
            this.doCreateBuildConfig(entity, namespace, sourceName);
        }
    }

    public void doCreateBuildConfig(BuildConfig entity, String namespace, String sourceName) {
        try {
            this.kubernetes.createBuildConfig(entity, namespace);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e, e);
        }
    }

    public void applyDeploymentConfig(DeploymentConfig entity, String sourceName) {
        try {
            this.kubernetes.createDeploymentConfig(entity, this.getNamespace());
        }
        catch (Exception e) {
            this.onApplyError("Failed to create DeploymentConfig from " + sourceName + ". " + e, e);
        }
    }

    public void applyImageStream(ImageStream entity, String sourceName) {
        try {
            this.kubernetes.createImageStream(entity, this.getNamespace());
        }
        catch (Exception e) {
            this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e, e);
        }
    }

    public void applyList(KubernetesList list, String sourceName) throws Exception {
        List entities = list.getItems();
        if (entities != null) {
            for (Object entity : entities) {
                this.applyEntity(entity, sourceName);
            }
        }
    }

    public void applyService(Service service, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)service);
        Objects.notNull((Object)id, (String)("No name for " + service + " " + sourceName));
        if (this.isIgnoreServiceMode()) {
            LOG.debug("Ignoring Service: " + namespace + ":" + id);
            return;
        }
        Service old = this.kubernetes.getService(id, namespace);
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(service, old)) {
                LOG.info("Service hasn't changed so not doing anything");
            } else if (this.isRecreateMode()) {
                this.kubernetes.deleteService(service, namespace);
                this.doCreateService(service, namespace, sourceName);
            } else {
                LOG.info("Updating a service from " + sourceName);
                try {
                    String answer = this.kubernetes.updateService(id, service, namespace);
                    this.logGeneratedEntity("Updated service: ", namespace, (HasMetadata)service, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update controller from " + sourceName + ". " + e + ". " + service, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)service));
        } else {
            this.doCreateService(service, namespace, sourceName);
        }
    }

    protected void doCreateService(Service service, String namespace, String sourceName) {
        LOG.info("Creating a service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)service));
        try {
            String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createService(service, namespace) : this.kubernetes.createService(service);
            this.logGeneratedEntity("Created service: ", namespace, (HasMetadata)service, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create service from " + sourceName + ". " + e + ". " + service, e);
        }
    }

    public void applyNamespace(String namespaceName) {
        Namespace entity = new Namespace();
        KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setName(namespaceName);
        this.applyNamespace(entity);
    }

    public void applyNamespace(Namespace entity) {
        String namespace = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).getName();
        LOG.info("Creating a namespace " + namespace);
        String name = KubernetesHelper.getName((HasMetadata)entity);
        Objects.notNull((Object)name, (String)("No name for " + entity));
        Namespace old = this.kubernetes.getNamespace(name);
        if (!this.isRunning((HasMetadata)old)) {
            try {
                String answer = this.kubernetes.createNamespace(entity);
                this.logGeneratedEntity("Created namespace: ", namespace, (HasMetadata)entity, answer);
            }
            catch (Exception e) {
                this.onApplyError("Failed to create namespace. " + e + ". " + entity, e);
            }
        }
    }

    public void applyReplicationController(ReplicationController replicationController, String sourceName) throws Exception {
        block12: {
            String namespace = this.getNamespace();
            String id = KubernetesHelper.getName((HasMetadata)replicationController);
            Objects.notNull((Object)id, (String)("No name for " + replicationController + " " + sourceName));
            if (this.isServicesOnlyMode()) {
                LOG.debug("Only processing Services right now so ignoring ReplicationController: " + namespace + ":" + id);
                return;
            }
            ReplicationController old = this.kubernetes.getReplicationController(id, namespace);
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(replicationController, old)) {
                    LOG.info("ReplicationController hasn't changed so not doing anything");
                } else if (this.isRecreateMode()) {
                    this.kubernetes.deleteReplicationControllerAndPods(replicationController, namespace);
                    this.doCreateReplicationController(replicationController, namespace, sourceName);
                } else {
                    LOG.info("Updating replicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController));
                    try {
                        String answer = this.kubernetes.updateReplicationController(id, replicationController);
                        this.logGeneratedEntity("Updated replicationController: ", namespace, (HasMetadata)replicationController, answer);
                        if (this.deletePodsOnReplicationControllerUpdate) {
                            LOG.info("Deleting any pods for the replication controller to ensure they use the new configuration");
                            this.kubernetes.deleteReplicationControllerPods(replicationController);
                            break block12;
                        }
                        LOG.info("Warning not deleted any pods so they could well be running with the old configuration!");
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update replicationController from " + sourceName + ". " + e + ". " + replicationController, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating a replicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController));
            } else {
                this.doCreateReplicationController(replicationController, namespace, sourceName);
            }
        }
    }

    protected void doCreateReplicationController(ReplicationController replicationController, String namespace, String sourceName) {
        LOG.info("Creating a replicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController));
        try {
            PodTemplateSpec template;
            ReplicationControllerSpec spec = replicationController.getSpec();
            if (spec != null && (template = spec.getTemplate()) != null) {
                PodSpec podSpec = template.getSpec();
                this.validatePodSpec(podSpec, namespace);
            }
            String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createReplicationController(replicationController, namespace) : this.kubernetes.createReplicationController(replicationController);
            this.logGeneratedEntity("Created replicationController: ", namespace, (HasMetadata)replicationController, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create replicationController from " + sourceName + ". " + e + ". " + replicationController, e);
        }
    }

    protected void validatePodSpec(PodSpec podSpec, String namespace) {
        List volumes = podSpec.getVolumes();
        if (volumes != null) {
            for (Volume volume : volumes) {
                String secretName;
                SecretVolumeSource secret = volume.getSecret();
                if (secret == null || !Strings.isNotBlank((String)(secretName = secret.getSecretName()))) continue;
                KubernetesHelper.validateSecretExists(this.kubernetes, namespace, secretName);
            }
        }
    }

    public void applyPod(Pod pod, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)pod);
        Objects.notNull((Object)id, (String)("No name for " + pod + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring Pod: " + namespace + ":" + id);
            return;
        }
        Pod old = this.kubernetes.getPod(id, namespace);
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(pod, old)) {
                LOG.info("Pod hasn't changed so not doing anything");
            } else if (this.isRecreateMode()) {
                this.kubernetes.deletePod(pod, namespace);
                this.doCreatePod(pod, namespace, sourceName);
            } else {
                LOG.info("Updating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)pod));
                try {
                    String answer = this.kubernetes.updatePod(id, pod);
                    LOG.info("Updated pod result: " + answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update pod from " + sourceName + ". " + e + ". " + pod, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)pod));
        } else {
            this.doCreatePod(pod, namespace, sourceName);
        }
    }

    protected void doCreatePod(Pod pod, String namespace, String sourceName) {
        LOG.info("Creating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)pod));
        try {
            PodSpec podSpec = pod.getSpec();
            if (podSpec != null) {
                this.validatePodSpec(podSpec, namespace);
            }
            String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createPod(pod, namespace) : this.kubernetes.createPod(pod);
            LOG.info("Created pod result: " + answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create pod from " + sourceName + ". " + e + ". " + pod, e);
        }
    }

    public String getNamespace() {
        return this.kubernetes.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.kubernetes.setNamespace(namespace);
    }

    public boolean isThrowExceptionOnError() {
        return this.throwExceptionOnError;
    }

    public void setThrowExceptionOnError(boolean throwExceptionOnError) {
        this.throwExceptionOnError = throwExceptionOnError;
    }

    public boolean isProcessTemplatesLocally() {
        return this.processTemplatesLocally;
    }

    public void setProcessTemplatesLocally(boolean processTemplatesLocally) {
        this.processTemplatesLocally = processTemplatesLocally;
    }

    public boolean isDeletePodsOnReplicationControllerUpdate() {
        return this.deletePodsOnReplicationControllerUpdate;
    }

    public void setDeletePodsOnReplicationControllerUpdate(boolean deletePodsOnReplicationControllerUpdate) {
        this.deletePodsOnReplicationControllerUpdate = deletePodsOnReplicationControllerUpdate;
    }

    public File getLogJsonDir() {
        return this.logJsonDir;
    }

    public void setLogJsonDir(File logJsonDir) {
        this.logJsonDir = logJsonDir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    protected boolean isRunning(HasMetadata entity) {
        return entity != null;
    }

    protected void onApplyError(String message, Exception e) {
        LOG.error(message, (Throwable)e);
        if (this.throwExceptionOnError) {
            throw new RuntimeException(message, e);
        }
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isRecreateMode() {
        return this.recreateMode;
    }

    public void setRecreateMode(boolean recreateMode) {
        this.recreateMode = recreateMode;
    }

    public void setServicesOnlyMode(boolean servicesOnlyMode) {
        this.servicesOnlyMode = servicesOnlyMode;
    }

    public boolean isServicesOnlyMode() {
        return this.servicesOnlyMode;
    }

    public boolean isIgnoreServiceMode() {
        return this.ignoreServiceMode;
    }

    public void setIgnoreServiceMode(boolean ignoreServiceMode) {
        this.ignoreServiceMode = ignoreServiceMode;
    }

    public boolean isIgnoreRunningOAuthClients() {
        return this.ignoreRunningOAuthClients;
    }

    public void setIgnoreRunningOAuthClients(boolean ignoreRunningOAuthClients) {
        this.ignoreRunningOAuthClients = ignoreRunningOAuthClients;
    }

    public boolean isFailOnMissingParameterValue() {
        return this.failOnMissingParameterValue;
    }

    public void setFailOnMissingParameterValue(boolean failOnMissingParameterValue) {
        this.failOnMissingParameterValue = failOnMissingParameterValue;
    }

    public boolean isSupportOAuthClients() {
        return this.supportOAuthClients;
    }

    public void setSupportOAuthClients(boolean supportOAuthClients) {
        this.supportOAuthClients = supportOAuthClients;
    }
}

