/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.PodStatusType;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.NodeSpec;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressTLS;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Files;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Filters;
import io.fabric8.utils.KubernetesServices;
import io.fabric8.utils.Lists;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import io.fabric8.utils.URLUtils;
import io.fabric8.utils.ssl.TrustEverythingSSLTrustManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocketFactory;
import javax.tools.FileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

public final class KubernetesHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesHelper.class);
    public static final String KUBERNETES_NAMESPACE_SYSTEM_PROPERTY = "kubernetes.namespace";
    public static final String KUBERNETES_NAMESPACE_ENV = "KUBERNETES_NAMESPACE";
    public static final String DEFAULT_NAMESPACE = "default";
    private static final transient Logger LOG = LoggerFactory.getLogger(KubernetesHelper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final int INTORSTRING_KIND_INT = 0;
    public static final int INTORSTRING_KIND_STRING = 1;
    public static final String DEFAULT_DOCKER_HOST = "tcp://localhost:2375";
    protected static SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    public static final String defaultApiVersion = "v1";
    public static final String defaultOsApiVersion = "v1";
    private static final ConcurrentMap<URL, Boolean> IS_OPENSHIFT = new ConcurrentHashMap<URL, Boolean>();
    private static final Config CONFIG = new ConfigBuilder().build();

    public static String defaultNamespace() {
        return CONFIG.getNamespace();
    }

    public static String getObjectId(Object object) {
        if (object instanceof HasMetadata) {
            return KubernetesHelper.getName((HasMetadata)object);
        }
        return object != null ? object.toString() : null;
    }

    public static ObjectMeta getOrCreateMetadata(HasMetadata entity) {
        ObjectMeta metadata = entity.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            entity.setMetadata(metadata);
        }
        return metadata;
    }

    public static String getResourceVersion(HasMetadata entity) {
        String resourceVersion;
        ObjectMeta metadata;
        if (entity != null && (metadata = entity.getMetadata()) != null && Strings.isNotBlank((String)(resourceVersion = metadata.getResourceVersion()))) {
            return resourceVersion;
        }
        return null;
    }

    public static boolean hasResourceVersion(HasMetadata entity) {
        return KubernetesHelper.getResourceVersion(entity) != null;
    }

    public static String getName(ObjectMeta entity) {
        if (entity != null) {
            return Strings.firstNonBlank((String[])new String[]{entity.getName(), KubernetesHelper.getAdditionalPropertyText(entity.getAdditionalProperties(), "id"), entity.getUid()});
        }
        return null;
    }

    public static String getKind(HasMetadata entity) {
        if (entity != null) {
            if (entity instanceof KubernetesList) {
                return "List";
            }
            return entity.getClass().getSimpleName();
        }
        return null;
    }

    public static String getName(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getName(entity.getMetadata());
        }
        return null;
    }

    public static void setName(HasMetadata entity, String name) {
        KubernetesHelper.getOrCreateMetadata(entity).setName(name);
    }

    public static void setName(HasMetadata entity, String namespace, String name) {
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
        metadata.setNamespace(namespace);
        metadata.setName(name);
    }

    public static void setNamespace(HasMetadata entity, String namespace) {
        KubernetesHelper.getOrCreateMetadata(entity).setNamespace(namespace);
    }

    public static String getNamespace(ObjectMeta entity) {
        if (entity != null) {
            return entity.getNamespace();
        }
        return null;
    }

    public static String getNamespace(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getNamespace(entity.getMetadata());
        }
        return null;
    }

    public static Map<String, String> getOrCreateAnnotations(HasMetadata entity) {
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
        LinkedHashMap answer = metadata.getAnnotations();
        if (answer == null) {
            answer = new LinkedHashMap();
            metadata.setAnnotations(answer);
        }
        return answer;
    }

    public static Map<String, String> getOrCreateLabels(HasMetadata entity) {
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
        LinkedHashMap answer = metadata.getLabels();
        if (answer == null) {
            answer = new LinkedHashMap();
            metadata.setLabels(answer);
        }
        return answer;
    }

    public static Map<String, String> getLabels(ObjectMeta metadata) {
        Map labels;
        if (metadata != null && (labels = metadata.getLabels()) != null) {
            return labels;
        }
        return Collections.EMPTY_MAP;
    }

    public static Map<String, String> getLabels(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getLabels(entity.getMetadata());
        }
        return Collections.EMPTY_MAP;
    }

    public static ServiceSpec getOrCreateSpec(Service entity) {
        ServiceSpec spec = entity.getSpec();
        if (spec == null) {
            spec = new ServiceSpec();
            entity.setSpec(spec);
        }
        return spec;
    }

    public static String getPortalIP(Service entity) {
        String answer = null;
        if (entity != null) {
            ServiceSpec spec = KubernetesHelper.getOrCreateSpec(entity);
            return spec.getClusterIP();
        }
        return answer;
    }

    public static Map<String, String> getSelector(Service entity) {
        Map answer = null;
        if (entity != null) {
            ServiceSpec spec = KubernetesHelper.getOrCreateSpec(entity);
            answer = spec.getSelector();
        }
        return answer != null ? answer : Collections.EMPTY_MAP;
    }

    public static void setSelector(Service entity, Map<String, String> labels) {
        ServiceSpec spec = KubernetesHelper.getOrCreateSpec(entity);
        spec.setSelector(labels);
    }

    public static Set<Integer> getPorts(Service entity) {
        HashSet<Integer> answer = new HashSet<Integer>();
        if (entity != null) {
            ServiceSpec spec = KubernetesHelper.getOrCreateSpec(entity);
            for (ServicePort port : spec.getPorts()) {
                answer.add(port.getPort());
            }
        }
        return answer;
    }

    protected static String getAdditionalPropertyText(Map<String, Object> additionalProperties, String name) {
        Object value;
        if (additionalProperties != null && (value = additionalProperties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    protected static Map<String, Object> getMetadata(Map<String, Object> additionalProperties, boolean create) {
        Map<String, Object> answer = KubernetesHelper.getAdditionalPropertyMap(additionalProperties, "metadata");
        if (answer == null) {
            answer = new LinkedHashMap<String, Object>();
            if (create) {
                additionalProperties.put("metadata", answer);
            }
        }
        return answer;
    }

    protected static Map<String, Object> getAdditionalPropertyMap(Map<String, Object> additionalProperties, String name) {
        Object value;
        if (additionalProperties != null && (value = additionalProperties.get(name)) instanceof Map) {
            return (Map)value;
        }
        return null;
    }

    public static String getDockerIp() {
        String url = KubernetesHelper.resolveDockerHost();
        int idx = url.indexOf("://");
        if (idx > 0) {
            url = url.substring(idx + 3);
        }
        if ((idx = url.indexOf(":")) > 0) {
            url = url.substring(0, idx);
        }
        return url;
    }

    public static String resolveDockerHost() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (Strings.isNullOrBlank((String)dockerHost)) {
            dockerHost = System.getProperty("docker.host");
        }
        if (Strings.isNullOrBlank((String)dockerHost)) {
            return DEFAULT_DOCKER_HOST;
        }
        return dockerHost;
    }

    public static String toJson(Object dto) throws JsonProcessingException {
        if (dto == null) {
            return "null";
        }
        Class<?> clazz = dto.getClass();
        return OBJECT_MAPPER.writerFor(clazz).writeValueAsString(dto);
    }

    public static Object loadJson(File file) throws IOException {
        byte[] data = Files.readBytes((File)file);
        return KubernetesHelper.loadJson(data);
    }

    public static Object loadJson(InputStream in) throws IOException {
        byte[] data = Files.readBytes((InputStream)in);
        return KubernetesHelper.loadJson(data);
    }

    public static Object loadJson(String json) throws IOException {
        byte[] data = json.getBytes();
        return KubernetesHelper.loadJson(data);
    }

    public static Object loadJson(byte[] json) throws IOException {
        if (json != null && json.length > 0) {
            return OBJECT_MAPPER.readerFor(KubernetesResource.class).readValue(json);
        }
        return null;
    }

    public static <T> T loadYaml(InputStream in, Class<T> clazz) throws IOException {
        byte[] data = Files.readBytes((InputStream)in);
        return KubernetesHelper.loadYaml(data, clazz);
    }

    public static <T> T loadYaml(File file, Class<T> clazz) throws IOException {
        byte[] data = Files.readBytes((File)file);
        return KubernetesHelper.loadYaml(data, clazz);
    }

    public static <T> T loadYaml(byte[] data, Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (T)mapper.readValue(data, clazz);
    }

    public static void saveYaml(Object data, File file) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.writeValue(file, data);
    }

    public static void saveYaml(Object data, FileObject fileObject) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try (Writer writer = fileObject.openWriter();){
            mapper.writeValue(writer, data);
        }
    }

    public static List<HasMetadata> toItemList(Object entity) throws IOException {
        if (entity instanceof List) {
            return (List)entity;
        }
        if (entity instanceof HasMetadata[]) {
            HasMetadata[] array = (HasMetadata[])entity;
            return Arrays.asList(array);
        }
        if (entity instanceof KubernetesList) {
            KubernetesList config = (KubernetesList)entity;
            return config.getItems();
        }
        if (entity instanceof Template) {
            Template objects = (Template)entity;
            return objects.getObjects();
        }
        ArrayList<HasMetadata> answer = new ArrayList<HasMetadata>();
        if (entity instanceof HasMetadata) {
            answer.add((HasMetadata)entity);
        }
        return answer;
    }

    public static void saveJson(File json, Object object) throws IOException {
        OBJECT_MAPPER.writer().withDefaultPrettyPrinter().writeValue(json, object);
    }

    public static Map<String, Pod> toPodMap(PodList podSchema) {
        return KubernetesHelper.toFilteredPodMap(podSchema, (Filter<Pod>)Filters.trueFilter());
    }

    protected static Map<String, Pod> toFilteredPodMap(PodList podSchema, Filter<Pod> filter) {
        List list = podSchema != null ? podSchema.getItems() : null;
        List filteredList = Filters.filter((Iterable)list, filter);
        return KubernetesHelper.toPodMap(filteredList);
    }

    public static Map<String, Pod> toPodMap(List<Pod> pods) {
        List list = Lists.notNullList(pods);
        HashMap<String, Pod> answer = new HashMap<String, Pod>();
        for (Pod pod : list) {
            String id = KubernetesHelper.getName((HasMetadata)pod);
            if (!Strings.isNotBlank((String)id)) continue;
            answer.put(id, pod);
        }
        return answer;
    }

    public static Map<String, Service> toServiceMap(ServiceList serviceSchema) {
        return KubernetesHelper.toServiceMap(serviceSchema != null ? serviceSchema.getItems() : null);
    }

    public static Map<String, Service> toServiceMap(List<Service> services) {
        List list = Lists.notNullList(services);
        HashMap<String, Service> answer = new HashMap<String, Service>();
        for (Service service : list) {
            String id = KubernetesHelper.getName((HasMetadata)service);
            if (!Strings.isNotBlank((String)id)) continue;
            answer.put(id, service);
        }
        return answer;
    }

    public static Map<String, Service> toFilteredServiceMap(ServiceList serviceList, Filter<Service> filter) {
        List list = serviceList != null ? serviceList.getItems() : null;
        List filteredList = Filters.filter((Iterable)list, filter);
        return KubernetesHelper.toServiceMap(filteredList);
    }

    public static Map<String, ReplicationController> toReplicationControllerMap(ReplicationControllerList replicationControllerSchema) {
        Filter<ReplicationController> filter = KubernetesHelper.createReplicationControllerFilter((String)null);
        return KubernetesHelper.toFilteredReplicationControllerMap(replicationControllerSchema, filter);
    }

    protected static Map<String, ReplicationController> toFilteredReplicationControllerMap(ReplicationControllerList replicationControllerSchema, Filter<ReplicationController> filter) {
        List list = replicationControllerSchema != null ? replicationControllerSchema.getItems() : null;
        List filteredList = Filters.filter((Iterable)list, filter);
        return KubernetesHelper.toReplicationControllerMap(filteredList);
    }

    public static Map<String, ReplicationController> toReplicationControllerMap(List<ReplicationController> replicationControllers) {
        List list = Lists.notNullList(replicationControllers);
        HashMap<String, ReplicationController> answer = new HashMap<String, ReplicationController>();
        for (ReplicationController replicationControllerSchema : list) {
            String id = KubernetesHelper.getName((HasMetadata)replicationControllerSchema);
            if (!Strings.isNotBlank((String)id)) continue;
            answer.put(id, replicationControllerSchema);
        }
        return answer;
    }

    public static Map<String, Pod> getPodMap(KubernetesClient kubernetes) {
        return KubernetesHelper.getPodMap(kubernetes, null);
    }

    public static Map<String, Pod> getPodMap(KubernetesClient kubernetes, String namespace) {
        PodList pods;
        block2: {
            pods = null;
            try {
                pods = (PodList)((ClientNonNamespaceOperation)kubernetes.pods().inNamespace(namespace)).list();
            }
            catch (KubernetesClientException e) {
                if (e.getCode() == 404) break block2;
                throw e;
            }
        }
        return KubernetesHelper.toPodMap(pods);
    }

    public static Map<String, Pod> getSelectedPodMap(KubernetesClient kubernetes, String selector) {
        return KubernetesHelper.getSelectedPodMap(kubernetes, null, selector);
    }

    public static Map<String, Pod> getSelectedPodMap(KubernetesClient kubernetes, String namespace, String selector) {
        return KubernetesHelper.getFilteredPodMap(kubernetes, namespace, KubernetesHelper.createPodFilter(selector));
    }

    public static Map<String, Pod> getFilteredPodMap(KubernetesClient kubernetes, Filter<Pod> filter) {
        return KubernetesHelper.getFilteredPodMap(kubernetes, null, filter);
    }

    public static Map<String, Pod> getFilteredPodMap(KubernetesClient kubernetes, String namespace, Filter<Pod> filter) {
        return KubernetesHelper.toFilteredPodMap((PodList)((ClientNonNamespaceOperation)kubernetes.pods().inNamespace(namespace)).list(), filter);
    }

    public static Map<String, Service> getServiceMap(KubernetesClient kubernetes) {
        return KubernetesHelper.getServiceMap(kubernetes, null);
    }

    public static Map<String, Service> getServiceMap(KubernetesClient kubernetes, String namespace) {
        return KubernetesHelper.toServiceMap((ServiceList)((ClientNonNamespaceOperation)kubernetes.services().inNamespace(namespace)).list());
    }

    public static Map<String, ReplicationController> getReplicationControllerMap(KubernetesClient kubernetes) {
        return KubernetesHelper.getReplicationControllerMap(kubernetes, null);
    }

    public static Map<String, ReplicationController> getReplicationControllerMap(KubernetesClient kubernetes, String namespace) {
        return KubernetesHelper.toReplicationControllerMap((ReplicationControllerList)((ClientNonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).list());
    }

    public static Map<String, ReplicationController> getSelectedReplicationControllerMap(KubernetesClient kubernetes, String selector) {
        return KubernetesHelper.getSelectedReplicationControllerMap(kubernetes, null, selector);
    }

    public static Map<String, ReplicationController> getSelectedReplicationControllerMap(KubernetesClient kubernetes, String namespace, String selector) {
        return KubernetesHelper.toReplicationControllerMap((ReplicationControllerList)((FilterWatchListDeletable)((ClientNonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withLabels(KubernetesHelper.toLabelsMap(selector))).list());
    }

    public static void removeEmptyPods(PodList podSchema) {
        List list = Lists.notNullList((List)podSchema.getItems());
        ArrayList<Pod> removeItems = new ArrayList<Pod>();
        for (Pod pod : list) {
            if (!Strings.isNullOrBlank((String)KubernetesHelper.getName((HasMetadata)pod))) continue;
            removeItems.add(pod);
        }
        list.removeAll(removeItems);
    }

    public static String containerNameToPodId(String containerName) {
        return containerName;
    }

    public static String toLabelsString(Map<String, String> labelMap) {
        StringBuilder buffer = new StringBuilder();
        if (labelMap != null) {
            Set<Map.Entry<String, String>> entries = labelMap.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(entry.getKey());
                buffer.append("=");
                buffer.append(entry.getValue());
            }
        }
        return buffer.toString();
    }

    public static Map<String, String> toLabelsMap(String labels) {
        String[] elements;
        HashMap<String, String> map = new HashMap<String, String>();
        if (labels != null && !labels.isEmpty() && (elements = labels.split(",")).length > 0) {
            for (String str : elements) {
                String[] keyValue = str.split("=");
                if (keyValue.length != 2) continue;
                String key = keyValue[0];
                String value = keyValue[1];
                if (key == null || value == null) continue;
                map.put(key.trim(), value.trim());
            }
        }
        return map;
    }

    public static Filter<Pod> createPodFilter(final String textFilter) {
        if (Strings.isNullOrBlank((String)textFilter)) {
            return Filters.trueFilter();
        }
        return new Filter<Pod>(){

            public String toString() {
                return "PodFilter(" + textFilter + ")";
            }

            public boolean matches(Pod entity) {
                return KubernetesHelper.filterMatchesIdOrLabels(textFilter, KubernetesHelper.getName((HasMetadata)entity), entity.getMetadata().getLabels());
            }
        };
    }

    public static Filter<Pod> createPodFilter(final Map<String, String> labelSelector) {
        if (labelSelector == null || labelSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<Pod>(){

            public String toString() {
                return "PodFilter(" + labelSelector + ")";
            }

            public boolean matches(Pod entity) {
                return KubernetesHelper.filterLabels(labelSelector, entity.getMetadata().getLabels());
            }
        };
    }

    public static Filter<Pod> createPodAnnotationFilter(final Map<String, String> annotationSelector) {
        if (annotationSelector == null || annotationSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<Pod>(){

            public String toString() {
                return "PodAnnotationFilter(" + annotationSelector + ")";
            }

            public boolean matches(Pod entity) {
                return KubernetesHelper.filterLabels(annotationSelector, entity.getMetadata().getAnnotations());
            }
        };
    }

    public static Filter<Service> createServiceFilter(final String textFilter) {
        if (Strings.isNullOrBlank((String)textFilter)) {
            return Filters.trueFilter();
        }
        return new Filter<Service>(){

            public String toString() {
                return "ServiceFilter(" + textFilter + ")";
            }

            public boolean matches(Service entity) {
                return KubernetesHelper.filterMatchesIdOrLabels(textFilter, KubernetesHelper.getName((HasMetadata)entity), entity.getMetadata().getLabels());
            }
        };
    }

    public static Filter<Service> createNamespaceServiceFilter(final String namespace) {
        if (Strings.isNullOrBlank((String)namespace)) {
            return Filters.trueFilter();
        }
        return new Filter<Service>(){

            public String toString() {
                return "NamespaceServiceFilter(" + namespace + ")";
            }

            public boolean matches(Service entity) {
                return io.fabric8.utils.Objects.equal((Object)namespace, (Object)KubernetesHelper.getNamespace(entity.getMetadata()));
            }
        };
    }

    public static Filter<Service> createServiceFilter(final Map<String, String> labelSelector) {
        if (labelSelector == null || labelSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<Service>(){

            public String toString() {
                return "ServiceFilter(" + labelSelector + ")";
            }

            public boolean matches(Service entity) {
                return KubernetesHelper.filterLabels(labelSelector, entity.getMetadata().getLabels());
            }
        };
    }

    public static Filter<ReplicationController> createReplicationControllerFilter(final String textFilter) {
        if (Strings.isNullOrBlank((String)textFilter)) {
            return Filters.trueFilter();
        }
        return new Filter<ReplicationController>(){

            public String toString() {
                return "ReplicationControllerFilter(" + textFilter + ")";
            }

            public boolean matches(ReplicationController entity) {
                return KubernetesHelper.filterMatchesIdOrLabels(textFilter, KubernetesHelper.getName((HasMetadata)entity), entity.getMetadata().getLabels());
            }
        };
    }

    public static Filter<ReplicationController> createReplicationControllerFilter(final Map<String, String> labelSelector) {
        if (labelSelector == null || labelSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<ReplicationController>(){

            public String toString() {
                return "ReplicationControllerFilter(" + labelSelector + ")";
            }

            public boolean matches(ReplicationController entity) {
                return KubernetesHelper.filterLabels(labelSelector, entity.getMetadata().getLabels());
            }
        };
    }

    public static boolean filterMatchesIdOrLabels(String textFilter, String id, Map<String, String> labels) {
        Map<String, String> selectorMap;
        boolean result;
        String text = KubernetesHelper.toLabelsString(labels);
        boolean bl = result = text != null && text.contains(textFilter) || id != null && id.contains(textFilter);
        if (!(result || (selectorMap = KubernetesHelper.toLabelsMap(textFilter)).isEmpty() || labels == null || labels.isEmpty())) {
            result = true;
            for (Map.Entry<String, String> entry : selectorMap.entrySet()) {
                String value = labels.get(entry.getKey());
                if (value != null && value.matches(entry.getValue())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean filterLabels(Map<String, String> filterLabels, Map<String, String> labels) {
        if (labels == null) {
            return false;
        }
        Set<Map.Entry<String, String>> entries = filterLabels.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String actualValue;
            String key = entry.getKey();
            String expectedValue = entry.getValue();
            if (io.fabric8.utils.Objects.equal((Object)expectedValue, (Object)(actualValue = labels.get(key)))) continue;
            return false;
        }
        return true;
    }

    public static String toPositiveNonZeroText(Integer port) {
        int value;
        if (port != null && (value = port.intValue()) > 0) {
            return "" + value;
        }
        return "";
    }

    public static List<Container> getContainers(Pod pod) {
        if (pod != null) {
            PodSpec podSpec = pod.getSpec();
            return KubernetesHelper.getContainers(podSpec);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(ReplicationController replicationController) {
        if (replicationController != null) {
            ReplicationControllerSpec replicationControllerSpec = replicationController.getSpec();
            return KubernetesHelper.getContainers(replicationControllerSpec);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(ReplicationControllerSpec replicationControllerSpec) {
        if (replicationControllerSpec != null) {
            PodTemplateSpec podTemplateSpec = replicationControllerSpec.getTemplate();
            return KubernetesHelper.getContainers(podTemplateSpec);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(PodSpec podSpec) {
        if (podSpec != null) {
            return podSpec.getContainers();
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(PodTemplateSpec podTemplateSpec) {
        if (podTemplateSpec != null) {
            return KubernetesHelper.getContainers(podTemplateSpec.getSpec());
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getCurrentContainers(ReplicationController replicationController) {
        if (replicationController != null) {
            // empty if block
        }
        return Collections.EMPTY_LIST;
    }

    public static Map<String, ContainerStatus> getCurrentContainers(Pod pod) {
        if (pod != null) {
            PodStatus currentStatus = pod.getStatus();
            return KubernetesHelper.getCurrentContainers(currentStatus);
        }
        return Collections.EMPTY_MAP;
    }

    public static Map<String, ContainerStatus> getCurrentContainers(PodStatus podStatus) {
        if (podStatus != null) {
            List containerStatuses = podStatus.getContainerStatuses();
            Hashtable<String, ContainerStatus> info = new Hashtable<String, ContainerStatus>(containerStatuses.size());
            for (ContainerStatus status : containerStatuses) {
                info.put(status.getContainerID(), status);
            }
            return info;
        }
        return Collections.EMPTY_MAP;
    }

    public static String getHost(Pod pod) {
        PodStatus currentState;
        if (pod != null && (currentState = pod.getStatus()) != null) {
            return currentState.getHostIP();
        }
        return null;
    }

    public static Set<Integer> getContainerPorts(Service service) {
        HashSet<Integer> answer = Collections.EMPTY_SET;
        String id = KubernetesHelper.getName((HasMetadata)service);
        ServiceSpec spec = service.getSpec();
        if (spec != null) {
            List servicePorts = spec.getPorts();
            io.fabric8.utils.Objects.notNull((Object)servicePorts, (String)("servicePorts for service " + id));
            answer = new HashSet<Integer>(servicePorts.size());
            String message = "service " + id;
            for (ServicePort port : servicePorts) {
                IntOrString intOrStringValue = port.getTargetPort();
                Integer intValue = KubernetesHelper.intOrStringToInteger(intOrStringValue, message);
                if (intValue == null) continue;
                answer.add(intValue);
            }
        }
        return answer;
    }

    public static Integer intOrStringToInteger(IntOrString intOrStringValue, String message) {
        Integer intValue = intOrStringValue.getIntVal();
        if (intValue == null) {
            String containerPortText = intOrStringValue.getStrVal();
            if (Strings.isNullOrBlank((String)containerPortText)) {
                throw new IllegalArgumentException("No port for " + message);
            }
            try {
                intValue = Integer.parseInt(containerPortText);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Invalid servicePorts expression " + containerPortText + " for " + message + ". " + e, e);
            }
        }
        return intValue;
    }

    public static Set<String> getContainerPortsStrings(Service service) {
        HashSet<String> answer = Collections.EMPTY_SET;
        String id = KubernetesHelper.getName((HasMetadata)service);
        ServiceSpec spec = service.getSpec();
        if (spec != null) {
            List servicePorts = spec.getPorts();
            io.fabric8.utils.Objects.notNull((Object)servicePorts, (String)("servicePorts for service " + id));
            answer = new HashSet<String>(servicePorts.size());
            for (ServicePort port : servicePorts) {
                IntOrString intOrStringValue = port.getTargetPort();
                Integer intValue = intOrStringValue.getIntVal();
                if (intValue != null) {
                    answer.add(intValue.toString());
                    continue;
                }
                String containerPortText = intOrStringValue.getStrVal();
                if (Strings.isNullOrBlank((String)containerPortText)) {
                    throw new IllegalArgumentException("No servicePorts for service " + id);
                }
                answer.add(containerPortText);
            }
        }
        return answer;
    }

    public static Object combineJson(Object ... objects) throws IOException {
        KubernetesList list = KubernetesHelper.findOrCreateList(objects);
        List<HasMetadata> items = list.getItems();
        if (items == null) {
            items = new ArrayList<HasMetadata>();
            list.setItems(items);
        }
        for (Object object : objects) {
            if (object == list) continue;
            KubernetesHelper.addObjectsToItemArray(items, object);
        }
        KubernetesList fullList = new KubernetesList();
        fullList.setItems(items);
        KubernetesHelper.moveServicesToFrontOfArray(items);
        KubernetesHelper.removeDuplicates(items);
        Object answer = Templates.combineTemplates(fullList);
        items = KubernetesHelper.toItemList(answer);
        KubernetesHelper.removeDuplicates(items);
        return answer;
    }

    public static void moveServicesToFrontOfArray(List<HasMetadata> list) {
        int size = list.size();
        int lastNonService = -1;
        for (int i = 0; i < size; ++i) {
            HasMetadata item = list.get(i);
            if (item instanceof Service) {
                if (lastNonService < 0) continue;
                HasMetadata nonService = list.get(lastNonService);
                list.set(i, nonService);
                list.set(lastNonService, item);
                ++lastNonService;
                continue;
            }
            if (lastNonService >= 0) continue;
            lastNonService = i;
        }
    }

    protected static void removeDuplicates(List<HasMetadata> itemArray) {
        int size = itemArray.size();
        int lastNonService = -1;
        HashSet<String> keys = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            String key;
            HasMetadata item = itemArray.get(i);
            if (item == null) {
                itemArray.remove(i);
                --i;
                --size;
                continue;
            }
            String id = KubernetesHelper.getObjectId(item);
            String kind = item.getClass().getSimpleName();
            if (!Strings.isNotBlank((String)id) || keys.add(key = kind + ":" + id)) continue;
            itemArray.remove(i);
            --i;
            --size;
        }
    }

    protected static void addObjectsToItemArray(List destinationList, Object object) throws IOException {
        if (object instanceof KubernetesList) {
            KubernetesList kubernetesList = (KubernetesList)object;
            List items = kubernetesList.getItems();
            if (items != null) {
                destinationList.addAll(items);
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            destinationList.addAll(collection);
        } else {
            destinationList.add(object);
        }
    }

    protected static KubernetesList findOrCreateList(Object[] objects) {
        KubernetesList list = null;
        for (Object object : objects) {
            if (!(object instanceof KubernetesList)) continue;
            list = (KubernetesList)object;
            break;
        }
        if (list == null) {
            list = new KubernetesList();
        }
        return list;
    }

    public static String getServiceURL(Service service) {
        String portalIP;
        ServiceSpec spec;
        if (service != null && (spec = service.getSpec()) != null && (portalIP = spec.getClusterIP()) != null) {
            Integer port = ((ServicePort)spec.getPorts().iterator().next()).getPort();
            if (port != null && port > 0) {
                portalIP = portalIP + ":" + port;
            }
            String protocol = "http://";
            if (KubernetesHelper.isServiceSsl(spec.getClusterIP(), port, Utils.getSystemPropertyOrEnvVar((String)"kubernetes.trust.certificates", (Boolean)false))) {
                protocol = "https://";
            }
            return protocol + portalIP;
        }
        return null;
    }

    public static String getServiceURL(KubernetesClient client, String serviceName, String serviceNamespace, String serviceProtocol, boolean serviceExternal) {
        return KubernetesHelper.getServiceURL(client, serviceName, serviceNamespace, serviceProtocol, null, serviceExternal);
    }

    public static String getServiceURL(KubernetesClient client, String serviceName, String serviceNamespace, String serviceProtocol, String servicePortName, boolean serviceExternal) {
        Integer portNumber;
        String portalIP;
        String serviceProto;
        block26: {
            String hostAndPort;
            String actualNamespace;
            Service srv = null;
            String serviceHost = KubernetesServices.serviceToHostOrBlank((String)serviceName);
            String servicePort = KubernetesServices.serviceToPortOrBlank((String)serviceName, (String)servicePortName);
            serviceProto = serviceProtocol != null ? serviceProtocol : KubernetesServices.serviceToProtocol((String)serviceName, (String)servicePort);
            String string = actualNamespace = Strings.isNotBlank((String)serviceNamespace) ? serviceNamespace : client.getNamespace();
            if (!serviceExternal && Strings.isNotBlank((String)serviceHost) && Strings.isNotBlank((String)servicePort) && Strings.isNotBlank((String)serviceProtocol)) {
                return serviceProtocol + "://" + serviceHost + ":" + servicePort;
            }
            if (Strings.isNotBlank((String)actualNamespace)) {
                try {
                    srv = (Service)((ClientResource)((ClientNonNamespaceOperation)client.services().inNamespace(actualNamespace)).withName(serviceName)).get();
                }
                catch (Exception e) {
                    LOGGER.warn("Could not lookup service:" + serviceName + " in namespace:" + actualNamespace + ", due to: " + e.getMessage());
                }
            }
            if (srv == null && !(hostAndPort = Systems.getServiceHostAndPort((String)serviceName, (String)"", (String)"")).startsWith(":")) {
                return serviceProto + "://" + hostAndPort;
            }
            if (srv == null) {
                throw new IllegalArgumentException("No kubernetes service could be found for name: " + serviceName + " in namespace: " + actualNamespace);
            }
            try {
                OpenShiftClient openShiftClient;
                Route route;
                if (Strings.isNullOrBlank((String)servicePortName) && KubernetesHelper.isOpenShift(client) && (route = (Route)((ClientResource)((ClientNonNamespaceOperation)(openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class)).routes().inNamespace(actualNamespace)).withName(serviceName)).get()) != null) {
                    return (serviceProto + "://" + route.getSpec().getHost()).toLowerCase();
                }
            }
            catch (KubernetesClientException e) {
                if (e.getCode() == 403) {
                    LOGGER.warn("Could not lookup route:" + serviceName + " in namespace:" + actualNamespace + ", due to: " + e.getMessage());
                }
                throw e;
            }
            ServicePort port = KubernetesHelper.findServicePortByName(srv, servicePortName);
            if (port == null) {
                throw new RuntimeException("Couldn't find port: " + servicePortName + " for service:" + serviceName);
            }
            if ("None".equals(srv.getSpec().getClusterIP())) {
                throw new IllegalStateException("Service: " + serviceName + " in namespace:" + serviceNamespace + "is head-less. Search for endpoints instead.");
            }
            portalIP = srv.getSpec().getPortalIP();
            portNumber = port.getPort();
            if (Strings.isNullOrBlank((String)portalIP)) {
                Integer nodePort;
                List items;
                IngressList ingresses = (IngressList)((ClientNonNamespaceOperation)client.extensions().ingresses().inNamespace(serviceNamespace)).list();
                if (ingresses != null && (items = ingresses.getItems()) != null) {
                    for (Ingress item : items) {
                        IngressSpec spec;
                        String ns = KubernetesHelper.getNamespace((HasMetadata)item);
                        if (!io.fabric8.utils.Objects.equal((Object)serviceNamespace, (Object)ns) || (spec = item.getSpec()) == null) continue;
                        List rules = spec.getRules();
                        List tls = spec.getTls();
                        if (rules == null) continue;
                        for (IngressRule rule : rules) {
                            List paths;
                            HTTPIngressRuleValue http = rule.getHttp();
                            if (http == null || (paths = http.getPaths()) == null) continue;
                            for (HTTPIngressPath path : paths) {
                                String answer;
                                String backendServiceName;
                                IngressBackend backend = path.getBackend();
                                if (backend == null || !serviceName.equals(backendServiceName = backend.getServiceName()) || !KubernetesHelper.portsMatch(port, backend.getServicePort())) continue;
                                String pathPostfix = path.getPath();
                                if (tls != null) {
                                    for (IngressTLS tlsHost : tls) {
                                        List hosts = tlsHost.getHosts();
                                        if (hosts == null) continue;
                                        for (String host : hosts) {
                                            if (!Strings.isNotBlank((String)host)) continue;
                                            if (Strings.isNullOrBlank((String)pathPostfix)) {
                                                pathPostfix = "/";
                                            }
                                            return "https://" + URLUtils.pathJoin((String[])new String[]{host, pathPostfix});
                                        }
                                    }
                                }
                                if (!Strings.isNotBlank((String)(answer = rule.getHost()))) continue;
                                if (Strings.isNullOrBlank((String)pathPostfix)) {
                                    pathPostfix = "/";
                                }
                                return "http://" + URLUtils.pathJoin((String[])new String[]{answer, pathPostfix});
                            }
                        }
                    }
                }
                if ((nodePort = port.getNodePort()) != null) {
                    try {
                        List items2;
                        NodeList nodeList = (NodeList)client.nodes().list();
                        if (nodeList == null || (items2 = nodeList.getItems()) == null) break block26;
                        for (Node item : items2) {
                            NodeSpec spec = item.getSpec();
                            if (spec == null || !Strings.isNotBlank((String)(portalIP = spec.getExternalID()))) continue;
                            portNumber = nodePort;
                            break;
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Could not find a node!: " + e, (Throwable)e);
                    }
                }
            }
        }
        return (serviceProto + "://" + portalIP + ":" + portNumber).toLowerCase();
    }

    private static boolean portsMatch(ServicePort servicePort, IntOrString intOrString) {
        if (intOrString != null) {
            Integer port = servicePort.getPort();
            Integer intVal = intOrString.getIntVal();
            String strVal = intOrString.getStrVal();
            if (intVal != null) {
                if (port != null) {
                    return port.intValue() == intVal.intValue();
                }
            } else if (strVal != null) {
                return io.fabric8.utils.Objects.equal((Object)strVal, (Object)servicePort.getName());
            }
        }
        return false;
    }

    public static String getServiceURLInCurrentNamespace(KubernetesClient client, String serviceName, String serviceProtocol, String servicePortName, boolean serviceExternal) {
        ServicePort port;
        String serviceProto;
        Service srv = null;
        String serviceHost = KubernetesServices.serviceToHostOrBlank((String)serviceName);
        String servicePort = KubernetesServices.serviceToPortOrBlank((String)serviceName, (String)servicePortName);
        String string = serviceProto = serviceProtocol != null ? serviceProtocol : KubernetesServices.serviceToProtocol((String)serviceName, (String)servicePort);
        if (!serviceExternal && Strings.isNotBlank((String)serviceHost) && Strings.isNotBlank((String)servicePort) && Strings.isNotBlank((String)serviceProtocol)) {
            return serviceProtocol + "://" + serviceHost + ":" + servicePort;
        }
        srv = (Service)((ClientResource)client.services().withName(serviceName)).get();
        if (srv == null) {
            throw new IllegalArgumentException("No kubernetes service could be found for name: " + serviceName);
        }
        if (Strings.isNullOrBlank((String)servicePortName) && KubernetesHelper.isOpenShift(client)) {
            OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            RouteList routeList = (RouteList)openShiftClient.routes().list();
            for (Route route : routeList.getItems()) {
                if (!route.getSpec().getTo().getName().equals(serviceName)) continue;
                return (serviceProto + "://" + route.getSpec().getHost()).toLowerCase();
            }
        }
        if ((port = KubernetesHelper.findServicePortByName(srv, servicePortName)) == null) {
            throw new RuntimeException("Couldn't find port: " + servicePortName + " for service:" + serviceName);
        }
        return (serviceProto + "://" + srv.getSpec().getPortalIP() + ":" + port.getPort()).toLowerCase();
    }

    public static ContainerPort findContainerPort(Pod pod, Integer portNumber) {
        List<Container> containers = KubernetesHelper.getContainers(pod);
        for (Container container : containers) {
            List ports = container.getPorts();
            for (ContainerPort port : ports) {
                if (!io.fabric8.utils.Objects.equal((Object)portNumber, (Object)port.getContainerPort())) continue;
                return port;
            }
        }
        return null;
    }

    public static ServicePort findServicePortByName(Service service, String portName) {
        if (Strings.isNullOrBlank((String)portName)) {
            return (ServicePort)service.getSpec().getPorts().iterator().next();
        }
        for (ServicePort servicePort : service.getSpec().getPorts()) {
            if (!io.fabric8.utils.Objects.equal((Object)servicePort.getName(), (Object)portName)) continue;
            return servicePort;
        }
        return null;
    }

    public static ContainerPort findContainerPortByName(Pod pod, String name) {
        List<Container> containers = KubernetesHelper.getContainers(pod);
        for (Container container : containers) {
            List ports = container.getPorts();
            for (ContainerPort port : ports) {
                if (!io.fabric8.utils.Objects.equal((Object)name, (Object)port.getName())) continue;
                return port;
            }
        }
        return null;
    }

    public static ContainerPort findContainerPortByNumberOrName(Pod pod, String numberOrName) {
        Integer portNumber = KubernetesHelper.toOptionalNumber(numberOrName);
        if (portNumber != null) {
            return KubernetesHelper.findContainerPort(pod, portNumber);
        }
        return KubernetesHelper.findContainerPortByName(pod, numberOrName);
    }

    protected static Integer toOptionalNumber(String text) {
        if (Strings.isNotBlank((String)text)) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static PodStatusType getPodStatus(Pod pod) {
        String text = KubernetesHelper.getPodStatusText(pod);
        if (Strings.isNotBlank((String)text)) {
            if ((text = text.toLowerCase()).startsWith("run")) {
                return PodStatusType.OK;
            }
            if (text.startsWith("wait")) {
                return PodStatusType.WAIT;
            }
            return PodStatusType.ERROR;
        }
        return PodStatusType.WAIT;
    }

    public static boolean isPodRunning(Pod pod) {
        PodStatusType status = KubernetesHelper.getPodStatus(pod);
        return io.fabric8.utils.Objects.equal((Object)((Object)status), (Object)((Object)PodStatusType.OK));
    }

    public static boolean isPodReady(Pod pod) {
        if (!KubernetesHelper.isPodRunning(pod)) {
            return false;
        }
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return true;
        }
        List conditions = podStatus.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        for (PodCondition condition : conditions) {
            if (!"ready".equalsIgnoreCase(condition.getType())) continue;
            return Boolean.parseBoolean(condition.getStatus());
        }
        return true;
    }

    public static String getPodStatusText(Pod pod) {
        PodStatus podStatus;
        if (pod != null && (podStatus = pod.getStatus()) != null) {
            return podStatus.getPhase();
        }
        return null;
    }

    public static String getPodEnvVar(Pod pod, String envVarName) {
        List containers;
        PodSpec spec;
        if (pod != null && (spec = pod.getSpec()) != null && (containers = spec.getContainers()) != null) {
            for (Container container : containers) {
                String answer = KubernetesHelper.getContainerEnvVar(container, envVarName);
                if (!Strings.isNotBlank((String)answer)) continue;
                return answer;
            }
        }
        return null;
    }

    public static String getContainerEnvVar(Container container, String envVarName) {
        List env;
        if (container != null && (env = container.getEnv()) != null) {
            for (EnvVar envVar : env) {
                if (!io.fabric8.utils.Objects.equal((Object)envVarName, (Object)envVar.getName())) continue;
                return envVar.getValue();
            }
        }
        return null;
    }

    public static List<Pod> getPodsForReplicationController(ReplicationController replicationController, Iterable<Pod> pods) {
        ReplicationControllerSpec replicationControllerSpec = replicationController.getSpec();
        if (replicationControllerSpec != null) {
            Map replicaSelector = replicationControllerSpec.getSelector();
            Filter<Pod> podFilter = KubernetesHelper.createPodFilter(replicaSelector);
            return Filters.filter(pods, podFilter);
        }
        LOG.warn("Cannot instantiate replication controller: " + KubernetesHelper.getName((HasMetadata)replicationController) + " due to missing ReplicationController.Spec!");
        return Collections.EMPTY_LIST;
    }

    public static List<Pod> getPodsForService(Service service, Iterable<Pod> pods) {
        Map<String, String> selector = KubernetesHelper.getSelector(service);
        Filter<Pod> podFilter = KubernetesHelper.createPodFilter(selector);
        return Filters.filter(pods, podFilter);
    }

    public static List<String> lookupServiceEndpointsInDns(String serviceName) throws IllegalArgumentException, UnknownHostException {
        try {
            Lookup l = new Lookup(serviceName, 33);
            Record[] records = l.run();
            if (l.getResult() == 0) {
                SRVRecord[] srvRecords = (SRVRecord[])Arrays.copyOf(records, records.length, SRVRecord[].class);
                Arrays.sort(srvRecords, new Comparator<SRVRecord>(){

                    @Override
                    public int compare(SRVRecord a, SRVRecord b) {
                        int ret = Integer.compare(b.getPriority(), a.getPriority());
                        if (ret == 0) {
                            ret = Integer.compare(b.getWeight(), a.getWeight());
                        }
                        return ret;
                    }
                });
                ArrayList<String> endpointAddresses = new ArrayList<String>(srvRecords.length);
                for (SRVRecord srvRecord : srvRecords) {
                    endpointAddresses.add(srvRecord.getTarget().toString(true).concat(":").concat(String.valueOf(srvRecord.getPort())));
                }
                return endpointAddresses;
            }
            LOG.warn("Lookup {} result: {}", (Object)serviceName, (Object)l.getErrorString());
        }
        catch (TextParseException e) {
            LOG.error("Unparseable service name: {}", (Object)serviceName, (Object)e);
        }
        catch (ClassCastException e) {
            LOG.error("Invalid response from DNS server - should have been A records", (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public static Set<String> lookupServiceInDns(String serviceName) throws IllegalArgumentException, UnknownHostException {
        try {
            Lookup l = new Lookup(serviceName);
            Record[] records = l.run();
            if (l.getResult() == 0) {
                HashSet<String> endpointAddresses = new HashSet<String>(records.length);
                for (int i = 0; i < records.length; ++i) {
                    ARecord aRecord = (ARecord)records[i];
                    endpointAddresses.add(aRecord.getAddress().getHostAddress());
                }
                return endpointAddresses;
            }
            LOG.warn("Lookup {} result: {}", (Object)serviceName, (Object)l.getErrorString());
        }
        catch (TextParseException e) {
            LOG.error("Unparseable service name: {}", (Object)serviceName, (Object)e);
        }
        catch (ClassCastException e) {
            LOG.error("Invalid response from DNS server - should have been A records", (Throwable)e);
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServiceSsl(String host, int port, boolean trustAllCerts) {
        block11: {
            boolean bl;
            LOG.info("Checking if a service is SSL on " + host + ":" + port);
            SSLSocketFactory sslsocketfactory = trustAllCerts ? TrustEverythingSSLTrustManager.getTrustingSSLSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
            Socket socket = sslsocketfactory.createSocket();
            socket.connect(new InetSocketAddress(host, port), 1000);
            try {
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                out.write(1);
                while (in.available() > 0) {
                    System.out.print(in.read());
                }
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    LOG.info("Checked if a service is SSL on " + host + ":" + port);
                    socket.close();
                    throw throwable;
                }
                catch (SSLHandshakeException e) {
                    LOG.error("SSL handshake failed - this probably means that you need to trust the kubernetes root SSL certificate or set the environment variable " + Utils.convertSystemPropertyNameToEnvVar((String)"kubernetes.trust.certificates"), (Throwable)e);
                    break block11;
                }
                catch (SSLProtocolException e) {
                    LOG.error("SSL protocol error", (Throwable)e);
                    break block11;
                }
                catch (SSLKeyException e) {
                    LOG.error("Bad SSL key", (Throwable)e);
                    break block11;
                }
                catch (SSLPeerUnverifiedException e) {
                    LOG.error("Could not verify server", (Throwable)e);
                    break block11;
                }
                catch (SSLException e) {
                    LOG.debug("Address does not appear to be SSL-enabled - falling back to http", (Throwable)e);
                    break block11;
                }
                catch (IOException e) {
                    LOG.debug("Failed to validate service", (Throwable)e);
                }
            }
            LOG.info("Checked if a service is SSL on " + host + ":" + port);
            socket.close();
            return bl;
        }
        return false;
    }

    public static String validateKubernetesId(String currentValue, String description) throws IllegalArgumentException {
        if (Strings.isNullOrBlank((String)currentValue)) {
            throw new IllegalArgumentException("No " + description + " is specified!");
        }
        int size = currentValue.length();
        for (int i = 0; i < size; ++i) {
            char ch = currentValue.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            throw new IllegalArgumentException("Invalid upper case letter '" + ch + "' at index " + i + " for " + description + " value: " + currentValue);
        }
        return currentValue;
    }

    public static Date parseDate(String text) {
        try {
            return dateTimeFormat.parse(text);
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse date: " + text + ". Reason: " + e);
            return null;
        }
    }

    public static String summaryText(Object object) {
        if (object instanceof Route) {
            return KubernetesHelper.summaryText((Route)object);
        }
        if (object instanceof Service) {
            return KubernetesHelper.summaryText((Service)object);
        }
        if (object instanceof ReplicationController) {
            return KubernetesHelper.summaryText((ReplicationController)object);
        }
        if (object instanceof Pod) {
            return KubernetesHelper.summaryText((Pod)object);
        }
        if (object instanceof Template) {
            return KubernetesHelper.summaryText((Template)object);
        }
        if (object instanceof DeploymentConfig) {
            return KubernetesHelper.summaryText((DeploymentConfig)object);
        }
        if (object instanceof OAuthClient) {
            return KubernetesHelper.summaryText((OAuthClient)object);
        }
        if (object instanceof String) {
            return object.toString();
        }
        return "";
    }

    public static String summaryText(Route entity) {
        RouteSpec spec = entity.getSpec();
        if (spec == null) {
            return "No spec!";
        }
        return "host: " + spec.getHost();
    }

    public static String summaryText(ContainerState entity) {
        ContainerStateRunning running = entity.getRunning();
        if (running != null) {
            return "Running";
        }
        ContainerStateWaiting waiting = entity.getWaiting();
        if (waiting != null) {
            return "Waiting";
        }
        ContainerStateTerminated termination = entity.getTerminated();
        if (termination != null) {
            return "Terminated";
        }
        return "Unknown";
    }

    public static String summaryText(Template entity) {
        StringBuilder buffer = new StringBuilder();
        List parameters = entity.getParameters();
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String name = parameter.getName();
                KubernetesHelper.appendText(buffer, name);
            }
        }
        return "parameters: " + buffer;
    }

    public static String summaryText(OAuthClient entity) {
        return "redirectURIs: " + entity.getRedirectURIs();
    }

    public static String summaryText(Service entity) {
        StringBuilder portText = new StringBuilder();
        ServiceSpec spec = entity.getSpec();
        if (spec == null) {
            return "No spec";
        }
        List ports = spec.getPorts();
        if (ports != null) {
            for (ServicePort port : ports) {
                Integer number = port.getPort();
                if (number == null) continue;
                if (portText.length() > 0) {
                    portText.append(", ");
                }
                portText.append("").append(number);
            }
        }
        return "selector: " + spec.getSelector() + " ports: " + portText;
    }

    public static String summaryText(ReplicationController entity) {
        StringBuilder buffer = new StringBuilder();
        ReplicationControllerSpec spec = entity.getSpec();
        if (spec != null) {
            buffer.append("replicas: ").append(spec.getReplicas());
            PodTemplateSpec podTemplateSpec = spec.getTemplate();
            if (podTemplateSpec != null) {
                KubernetesHelper.appendSummaryText(buffer, podTemplateSpec);
            }
        }
        return buffer.toString();
    }

    public static String summaryText(DeploymentConfig entity) {
        StringBuilder buffer = new StringBuilder();
        DeploymentConfigSpec spec = entity.getSpec();
        if (spec != null) {
            buffer.append("replicas: " + spec.getReplicas());
            PodTemplateSpec podTemplateSpec = spec.getTemplate();
            if (podTemplateSpec != null) {
                KubernetesHelper.appendSummaryText(buffer, podTemplateSpec);
            }
        }
        return buffer.toString();
    }

    public static String summaryText(Pod entity) {
        StringBuilder buffer = new StringBuilder();
        PodSpec podSpec = entity.getSpec();
        KubernetesHelper.appendSummaryText(buffer, podSpec);
        return buffer.toString();
    }

    protected static void appendSummaryText(StringBuilder buffer, PodTemplateSpec podTemplateSpec) {
        if (podTemplateSpec != null) {
            KubernetesHelper.appendSummaryText(buffer, podTemplateSpec.getSpec());
        }
    }

    protected static void appendSummaryText(StringBuilder buffer, PodSpec podSpec) {
        List containers;
        if (podSpec != null && (containers = podSpec.getContainers()) != null) {
            for (Container container : containers) {
                String image = container.getImage();
                KubernetesHelper.appendText(buffer, "image: " + image);
            }
        }
    }

    protected static void appendText(StringBuilder buffer, String text) {
        if (buffer.length() > 0) {
            buffer.append(", ");
        }
        buffer.append(text);
    }

    public static IntOrString createIntOrString(int intVal) {
        IntOrString answer = new IntOrString();
        answer.setIntVal(Integer.valueOf(intVal));
        answer.setKind(Integer.valueOf(0));
        return answer;
    }

    public static IntOrString createIntOrString(String nameOrNumber) {
        if (Strings.isNullOrBlank((String)nameOrNumber)) {
            return null;
        }
        IntOrString answer = new IntOrString();
        Integer intVal = null;
        try {
            intVal = Integer.parseInt(nameOrNumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (intVal != null) {
            answer.setIntVal(intVal);
            answer.setKind(Integer.valueOf(0));
        } else {
            answer.setStrVal(nameOrNumber);
            answer.setKind(Integer.valueOf(1));
        }
        return answer;
    }

    public static String getStatusText(PodStatus podStatus) {
        ArrayList<String> statusList = new ArrayList<String>();
        List containerStatuses = podStatus.getContainerStatuses();
        for (ContainerStatus containerStatus : containerStatuses) {
            ContainerState state = containerStatus.getState();
            String statusText = KubernetesHelper.summaryText(state);
            if (statusText == null) continue;
            statusList.add(statusText);
        }
        String status = statusList.size() == 1 ? (String)statusList.get(0) : ((Object)statusList).toString();
        return status;
    }

    public static Secret validateSecretExists(KubernetesClient kubernetes, String namespace, String secretName) {
        Secret secret;
        block3: {
            secret = null;
            try {
                secret = (Secret)((ClientResource)((ClientNonNamespaceOperation)kubernetes.secrets().inNamespace(namespace)).withName(secretName)).get();
            }
            catch (KubernetesClientException e) {
                if (e.getCode() == 404 || e.getCode() == 403) break block3;
                throw e;
            }
        }
        if (secret == null) {
            throw new IllegalArgumentException("No secret named: " + secretName + " for namespace " + namespace + " is available on Kubernetes" + ". For how to create secrets see: http://fabric8.io/guide/fabric8OnOpenShift.html#requirements ");
        }
        return secret;
    }

    public static KubernetesList asKubernetesList(Object dto) throws IOException {
        if (dto instanceof KubernetesList) {
            return (KubernetesList)dto;
        }
        KubernetesList answer = new KubernetesList();
        List<HasMetadata> items = KubernetesHelper.toItemList(dto);
        answer.setItems(items);
        return answer;
    }

    public static boolean isPureKubernetes(HasMetadata item) {
        if (item != null) {
            String name = item.getClass().getName();
            return name.startsWith("io.fabric8.kubernetes");
        }
        return false;
    }

    public static boolean isOpenShift(KubernetesClient client) {
        List paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_OPENSHIFT.containsKey(masterUrl)) {
            return (Boolean)IS_OPENSHIFT.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path)) continue;
                IS_OPENSHIFT.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_OPENSHIFT.putIfAbsent(masterUrl, false);
        return false;
    }
}

