/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.kubernetes.api.ExceptionResponseMapper;
import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesExtensions;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.KubernetesGlobalExtensions;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.Watcher;
import io.fabric8.kubernetes.api.builds.Builds;
import io.fabric8.kubernetes.api.extensions.Configs;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.config.Config;
import io.fabric8.kubernetes.api.model.config.Context;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.openshift.api.model.template.Template;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Filters;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClient
implements Kubernetes,
KubernetesExtensions,
KubernetesGlobalExtensions {
    private static final transient Logger LOG = LoggerFactory.getLogger(KubernetesClient.class);
    private static final long DEFAULT_TRIGGER_TIMEOUT = 60000L;
    private KubernetesFactory factory;
    private Kubernetes kubernetes;
    private KubernetesExtensions kubernetesExtensions;
    private KubernetesGlobalExtensions kubernetesGlobalExtensions;
    private String namespace = KubernetesClient.defaultNamespace();

    public static String defaultNamespace() {
        String namespace = System.getenv("KUBERNETES_NAMESPACE");
        if (Strings.isNullOrBlank((String)namespace)) {
            namespace = KubernetesClient.findDefaultOpenShiftNamespace();
        }
        if (Strings.isNotBlank((String)namespace)) {
            return namespace;
        }
        return "default";
    }

    public static String findDefaultOpenShiftNamespace() {
        Context context;
        Config config = Configs.parseConfigs();
        if (config != null && (context = Configs.getCurrentContext(config)) != null) {
            return context.getNamespace();
        }
        return null;
    }

    public KubernetesClient() {
        this(new KubernetesFactory());
    }

    public KubernetesClient(String url) {
        this(new KubernetesFactory(url));
    }

    public KubernetesClient(KubernetesFactory factory) {
        this.factory = factory;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Kubernetes getKubernetes() {
        if (this.kubernetes == null) {
            this.kubernetes = this.getFactory().createKubernetes();
        }
        return this.kubernetes;
    }

    public KubernetesExtensions getKubernetesExtensions() {
        if (this.kubernetesExtensions == null) {
            this.kubernetesExtensions = this.getFactory().createKubernetesExtensions();
        }
        return this.kubernetesExtensions;
    }

    public KubernetesGlobalExtensions getKubernetesGlobalExtensions() {
        if (this.kubernetesGlobalExtensions == null) {
            this.kubernetesGlobalExtensions = this.getFactory().createKubernetesGlobalExtensions();
        }
        return this.kubernetesGlobalExtensions;
    }

    public KubernetesFactory getFactory() {
        if (this.factory == null) {
            this.factory = new KubernetesFactory();
        }
        return this.factory;
    }

    public void setFactory(KubernetesFactory factory) {
        this.factory = factory;
    }

    public String getAddress() {
        return this.getFactory().getAddress();
    }

    public String getWriteableAddress() {
        return this.getFactory().getAddress();
    }

    @Override
    @GET
    @Path(value="namespaces")
    public NamespaceList getNamespaces() {
        return this.getKubernetes().getNamespaces();
    }

    @Override
    public String createNamespace(Namespace entity) throws Exception {
        return this.getKubernetes().createNamespace(entity);
    }

    @Override
    @GET
    @Path(value="namespaces/{name}")
    public Namespace getNamespace(final @NotNull String name) {
        return KubernetesClient.handle404ByReturningNull(new Callable<Namespace>(){

            @Override
            public Namespace call() throws Exception {
                return KubernetesClient.this.getKubernetes().getNamespace(name);
            }
        });
    }

    @Override
    @PUT
    @Path(value="namespaces/{name}")
    @Consumes(value={"application/json"})
    public String updateNamespace(@NotNull String namespaceId, Namespace entity) throws Exception {
        return this.getKubernetes().updateNamespace(namespaceId, entity);
    }

    @Override
    @DELETE
    @Path(value="namespaces/{name}")
    @Consumes(value={"text/plain"})
    public String deleteNamespace(@NotNull String name) throws Exception {
        return this.getKubernetes().deleteNamespace(name);
    }

    @GET
    @Path(value="pods")
    public PodList getPods() {
        return this.getPods(this.getNamespace());
    }

    @Override
    public PodList getPods(@QueryParam(value="namespace") String namespace) {
        this.validateNamespace(namespace, null);
        return this.getKubernetes().getPods(namespace);
    }

    @DELETE
    @Path(value="pods/{podId}")
    public String deletePod(@NotNull String podId) throws Exception {
        this.validateNamespace(this.namespace, podId);
        return this.getKubernetes().deletePod(podId, this.getNamespace());
    }

    @Override
    @DELETE
    @Path(value="pods/{podId}")
    @Consumes(value={"text/plain"})
    public String deletePod(@NotNull String podId, String namespace) throws Exception {
        this.validateNamespace(namespace, podId);
        return this.getKubernetes().deletePod(podId, namespace);
    }

    @GET
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    public ReplicationController getReplicationController(@NotNull String controllerId) {
        this.validateNamespace(this.namespace, controllerId);
        return this.getReplicationController(controllerId, this.getNamespace());
    }

    @Override
    public ReplicationController getReplicationController(final @PathParam(value="controllerId") @NotNull String controllerId, final @QueryParam(value="namespace") String namespace) {
        this.validateNamespace(namespace, controllerId);
        return KubernetesClient.handle404ByReturningNull(new Callable<ReplicationController>(){

            @Override
            public ReplicationController call() throws Exception {
                return KubernetesClient.this.getKubernetes().getReplicationController(controllerId, namespace);
            }
        });
    }

    @DELETE
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    public String deleteReplicationController(@NotNull String controllerId) throws Exception {
        this.validateNamespace(this.namespace, controllerId);
        return this.getKubernetes().deleteReplicationController(controllerId, this.getNamespace());
    }

    @Override
    @DELETE
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteReplicationController(@NotNull String controllerId, String namespace) throws Exception {
        this.validateNamespace(namespace, controllerId);
        return this.getKubernetes().deleteReplicationController(controllerId, namespace);
    }

    @Override
    @DELETE
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteService(@NotNull String serviceId, String namespace) throws Exception {
        this.validateNamespace(namespace, serviceId);
        return this.getKubernetes().deleteService(serviceId, namespace);
    }

    @Path(value="replicationControllers")
    @GET
    @Produces(value={"application/json"})
    public ReplicationControllerList getReplicationControllers() {
        return this.getReplicationControllers(this.getNamespace());
    }

    @Override
    public ReplicationControllerList getReplicationControllers(@QueryParam(value="namespace") String namespace) {
        this.validateNamespace(namespace, null);
        return this.getKubernetes().getReplicationControllers(namespace);
    }

    @PUT
    @Path(value="replicationControllers/{controllerId}")
    @Consumes(value={"application/json"})
    public String updateReplicationController(@NotNull String controllerId, ReplicationController entity) throws Exception {
        this.validateNamespace(this.namespace, entity);
        return this.updateReplicationController(controllerId, entity, this.getNamespace());
    }

    @Override
    @PUT
    @Path(value="replicationControllers/{controllerId}")
    @Consumes(value={"application/json"})
    public String updateReplicationController(@NotNull String controllerId, ReplicationController entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        if (!KubernetesHelper.hasResourceVersion((HasMetadata)entity)) {
            ReplicationController oldEntity = this.getReplicationController(controllerId, namespace);
            if (oldEntity == null) {
                return this.createReplicationController(entity, namespace);
            }
            String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)oldEntity);
            KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setResourceVersion(resourceVersion);
        }
        return this.getKubernetes().updateReplicationController(controllerId, entity, namespace);
    }

    @PUT
    @Path(value="services/{serviceId}")
    @Consumes(value={"application/json"})
    public String updateService(@NotNull String serviceId, Service entity) throws Exception {
        this.validateNamespace(this.namespace, entity);
        return this.updateService(serviceId, entity, this.getNamespace());
    }

    @Override
    public String updateService(@PathParam(value="serviceId") @NotNull String serviceId, Service entity, @QueryParam(value="namespace") String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        if (!KubernetesHelper.hasResourceVersion((HasMetadata)entity)) {
            Service service = this.getService(serviceId, namespace);
            if (service == null) {
                return this.createService(entity, namespace);
            }
            String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)service);
            KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setResourceVersion(resourceVersion);
            ServiceSpec oldSpec = service.getSpec();
            ServiceSpec newSpec = entity.getSpec();
            if (oldSpec != null && newSpec != null && Strings.isNullOrBlank((String)newSpec.getPortalIP())) {
                newSpec.setPortalIP(oldSpec.getPortalIP());
            }
        }
        return this.getKubernetes().updateService(serviceId, entity, namespace);
    }

    @GET
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    public Service getService(@NotNull String serviceId) {
        return this.getService(serviceId, this.getNamespace());
    }

    @Override
    public Service getService(final @PathParam(value="serviceId") @NotNull String serviceId, final @QueryParam(value="namespace") String namespace) {
        this.validateNamespace(namespace, serviceId);
        return KubernetesClient.handle404ByReturningNull(new Callable<Service>(){

            @Override
            public Service call() throws Exception {
                return KubernetesClient.this.getKubernetes().getService(serviceId, namespace);
            }
        });
    }

    @DELETE
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    public String deleteService(@NotNull String serviceId) throws Exception {
        this.validateNamespace(this.namespace, serviceId);
        return this.deleteService(serviceId, this.getNamespace());
    }

    @GET
    @Path(value="pods/{podId}")
    public Pod getPod(@NotNull String podId) {
        return this.getPod(podId, this.getNamespace());
    }

    @Override
    public Pod getPod(final @PathParam(value="podId") @NotNull String podId, final @QueryParam(value="namespace") String namespace) {
        this.validateNamespace(namespace, podId);
        return KubernetesClient.handle404ByReturningNull(new Callable<Pod>(){

            @Override
            public Pod call() throws Exception {
                return KubernetesClient.this.getKubernetes().getPod(podId, namespace);
            }
        });
    }

    @PUT
    @Path(value="pods/{podId}")
    @Consumes(value={"application/json"})
    public String updatePod(@NotNull String podId, Pod entity) throws Exception {
        return this.updatePod(podId, entity, this.getNamespace());
    }

    @Override
    public String updatePod(@PathParam(value="podId") @NotNull String podId, Pod entity, @QueryParam(value="namespace") String namespace) throws Exception {
        this.validateNamespace(namespace, podId);
        return this.getKubernetes().updatePod(podId, entity, namespace);
    }

    @Path(value="services")
    @GET
    @Produces(value={"application/json"})
    public ServiceList getServices() {
        this.validateNamespace(this.namespace, null);
        return this.getServices(this.getNamespace());
    }

    @Override
    public ServiceList getServices(@QueryParam(value="namespace") String namespace) {
        this.validateNamespace(namespace, null);
        return this.getKubernetes().getServices(namespace);
    }

    @POST
    @Path(value="pods")
    @Consumes(value={"application/json"})
    public String createPod(Pod entity) throws Exception {
        this.validateNamespace(this.namespace, entity);
        return this.createPod(entity, this.getNamespace());
    }

    @Override
    @POST
    @Path(value="pods")
    @Consumes(value={"application/json"})
    public String createPod(Pod entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setNamespace(namespace);
        return this.getKubernetes().createPod(entity, namespace);
    }

    @Path(value="services")
    @POST
    @Consumes(value={"application/json"})
    public String createService(Service entity) throws Exception {
        this.validateNamespace(this.namespace, entity);
        return this.createService(entity, this.getNamespace());
    }

    @Override
    @Path(value="services")
    @POST
    @Consumes(value={"application/json"})
    public String createService(Service entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setNamespace(namespace);
        return this.getKubernetes().createService(entity, namespace);
    }

    @Path(value="replicationControllers")
    @POST
    @Consumes(value={"application/json"})
    public String createReplicationController(ReplicationController entity) throws Exception {
        this.validateNamespace(this.namespace, entity);
        return this.createReplicationController(entity, this.getNamespace());
    }

    @Override
    @Path(value="replicationControllers")
    @POST
    @Consumes(value={"application/json"})
    public String createReplicationController(ReplicationController entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setNamespace(namespace);
        return this.getKubernetes().createReplicationController(entity, namespace);
    }

    @GET
    @Path(value="endpoints")
    public EndpointsList getEndpoints() {
        return this.getEndpoints(this.getNamespace());
    }

    @Override
    @GET
    @Path(value="endpoints")
    public EndpointsList getEndpoints(String namespace) {
        this.validateNamespace(namespace, null);
        return this.getKubernetes().getEndpoints(namespace);
    }

    @Override
    @GET
    @Path(value="endpoints/{serviceId}")
    public Endpoints endpointsForService(@NotNull String serviceId, String namespace) {
        try {
            this.validateNamespace(namespace, serviceId);
            return this.getKubernetes().endpointsForService(serviceId, namespace);
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                Endpoints answer = new Endpoints();
                answer.setSubsets(new ArrayList());
                return answer;
            }
            throw e;
        }
    }

    @Override
    @Path(value="namespaces/{namespace}/secrets")
    @POST
    @Consumes(value={"application/json"})
    public String createSecret(Secret entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        return this.getKubernetes().createSecret(entity, namespace);
    }

    @Override
    @DELETE
    @Path(value="namespaces/{namespace}/secrets/{secretId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteSecret(@NotNull String secretId, String namespace) throws Exception {
        this.validateNamespace(namespace, secretId);
        return this.getKubernetes().deleteSecret(secretId, namespace);
    }

    @Override
    @GET
    @Path(value="namespaces/{namespace}/secrets/{secretId}")
    @Produces(value={"application/json"})
    public Secret getSecret(final @NotNull String secretId, final String namespace) {
        this.validateNamespace(namespace, secretId);
        return KubernetesClient.handle404ByReturningNull(new Callable<Secret>(){

            @Override
            public Secret call() throws Exception {
                return KubernetesClient.this.getKubernetes().getSecret(secretId, namespace);
            }
        });
    }

    @Override
    @Path(value="namespaces/{namespace}/secrets")
    @GET
    @Produces(value={"application/json"})
    public SecretList getSecrets(final String namespace) {
        this.validateNamespace(namespace, null);
        SecretList answer = KubernetesClient.handle404ByReturningNull(new Callable<SecretList>(){

            @Override
            public SecretList call() throws Exception {
                return KubernetesClient.this.getKubernetes().getSecrets(namespace);
            }
        });
        if (answer == null) {
            answer = new SecretList();
        }
        return answer;
    }

    @Override
    @PUT
    @Path(value="namespaces/{namespace}/secrets/{secretId}")
    @Consumes(value={"application/json"})
    public String updateSecret(@NotNull String secretId, Secret entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        return this.getKubernetes().updateSecret(secretId, entity, namespace);
    }

    @Override
    @GET
    @Path(value="nodes")
    public NodeList getNodes() {
        return this.getKubernetes().getNodes();
    }

    @Override
    @GET
    @Path(value="nodes/{nodeId}")
    public Node node(@NotNull String nodeId) {
        return this.getKubernetes().node(nodeId);
    }

    @Override
    @POST
    @Path(value="oauthclients")
    @Consumes(value={"application/json"})
    public String createOAuthClient(OAuthClient entity) throws Exception {
        KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setNamespace(this.namespace);
        String id = KubernetesHelper.getName((HasMetadata)entity);
        LOG.info("Creating OAuthClient " + id + " " + KubernetesHelper.summaryText(entity));
        return this.getKubernetesGlobalExtensions().createOAuthClient(entity);
    }

    @Override
    @DELETE
    @Path(value="oauthclients/{name}")
    public String deleteOAuthClient(@NotNull String name) {
        LOG.info("Deleting OAuthClient " + name);
        return this.getKubernetesGlobalExtensions().deleteOAuthClient(name);
    }

    @Override
    @GET
    @Path(value="oauthclients/{name}")
    public OAuthClient getOAuthClient(final @NotNull String name) {
        return KubernetesClient.handle404ByReturningNull(new Callable<OAuthClient>(){

            @Override
            public OAuthClient call() throws Exception {
                return KubernetesClient.this.getKubernetesGlobalExtensions().getOAuthClient(name);
            }
        });
    }

    @Override
    @PUT
    @Path(value="oauthclients/{name}")
    @Consumes(value={"application/json"})
    public String updateOAuthClient(@NotNull String name, OAuthClient entity) throws Exception {
        LOG.info("Updating OAuthClient " + name + " " + KubernetesHelper.summaryText(entity));
        return this.getKubernetesGlobalExtensions().updateOAuthClient(name, entity);
    }

    @Override
    @POST
    @Path(value="routes")
    public String createRoute(Route entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        return this.getKubernetesExtensions().createRoute(entity, namespace);
    }

    public void createRouteOldAPi(Route entity, String namespace) {
        this.validateNamespace(namespace, entity);
        WebClient webClient = this.getFactory().createWebClient();
        String name = KubernetesHelper.getName((HasMetadata)entity);
        RouteSpec spec = entity.getSpec();
        String host = null;
        String serviceName = null;
        if (spec != null) {
            host = spec.getHost();
            ObjectReference to = spec.getTo();
            if (to != null) {
                serviceName = to.getName();
            }
        }
        if (Strings.isNullOrBlank(host)) {
            throw new IllegalArgumentException("No host defined!");
        }
        if (Strings.isNullOrBlank(serviceName)) {
            throw new IllegalArgumentException("No to.name defined!");
        }
        String json = "{ \"kind\": \"Route\", \"apiVersion\": \"v1beta1\",  \"metadata\": { \"name\": \"" + name + "\"}, \"host\": \"" + host + "\", \"serviceName\": \"" + serviceName + "\"}";
        System.out.println("Posting JSON: " + json);
        Response response = webClient.path((Object)"/oapi/v1/routes").query("namespace", new Object[]{namespace}).post((Object)json);
        Object responseEntity = response.getEntity();
        if (responseEntity instanceof InputStream) {
            InputStream inputStream = (InputStream)responseEntity;
            try {
                responseEntity = IOHelpers.readFully((InputStream)inputStream);
            }
            catch (IOException e) {
                LOG.error("Failed to parse response: " + e, (Throwable)e);
            }
        }
        System.out.println("Result: " + responseEntity);
        int status = response.getStatus();
        System.out.println("Posted and got result: " + status);
    }

    @Override
    @POST
    @Path(value="deploymentConfigs")
    public String createDeploymentConfig(DeploymentConfig entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setNamespace(namespace);
        return this.getKubernetesExtensions().createDeploymentConfig(entity, namespace);
    }

    @Override
    @POST
    @Path(value="templates")
    @Consumes(value={"application/json"})
    public String processTemplate(Template entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        return this.getKubernetesExtensions().processTemplate(entity, namespace);
    }

    @Override
    @Path(value="templates")
    @POST
    @Consumes(value={"application/json"})
    public String createTemplate(Template entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        return this.getKubernetesExtensions().createTemplate(entity, namespace);
    }

    @Override
    @GET
    @Path(value="templates/{name}")
    @Produces(value={"application/json"})
    public Template getTemplate(final @NotNull String name, final String namespace) {
        return KubernetesClient.handle404ByReturningNull(new Callable<Template>(){

            @Override
            public Template call() throws Exception {
                return KubernetesClient.this.getKubernetesExtensions().getTemplate(name, namespace);
            }
        });
    }

    @Override
    @PUT
    @Path(value="templates/{name}")
    @Consumes(value={"application/json"})
    public String updateTemplate(@NotNull String name, Template entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        if (!KubernetesHelper.hasResourceVersion((HasMetadata)entity)) {
            ReplicationController oldEntity = this.getReplicationController(name, namespace);
            if (oldEntity == null) {
                return this.createTemplate(entity, namespace);
            }
            String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)oldEntity);
            KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setResourceVersion(resourceVersion);
        }
        return this.getKubernetesExtensions().updateTemplate(name, entity, namespace);
    }

    @Override
    @DELETE
    @Path(value="templates/{name}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteTemplate(@NotNull String name, String namespace) throws Exception {
        return this.getKubernetesExtensions().deleteTemplate(name, namespace);
    }

    @Override
    @DELETE
    @Path(value="buildConfigs/{name}")
    public String deleteBuildConfig(@NotNull String name, String namespace) {
        this.validateNamespace(namespace, name);
        return this.getKubernetesExtensions().deleteBuildConfig(name, namespace);
    }

    @Override
    @DELETE
    @Path(value="deploymentConfigs/{name}")
    public String deleteDeploymentConfig(@NotNull String name, String namespace) {
        this.validateNamespace(namespace, name);
        return this.getKubernetesExtensions().deleteDeploymentConfig(name, namespace);
    }

    @Override
    @GET
    @Path(value="routes")
    public RouteList getRoutes(final @QueryParam(value="namespace") String namespace) {
        this.validateNamespace(namespace, null);
        RouteList answer = KubernetesClient.handle404ByReturningNull(new Callable<RouteList>(){

            @Override
            public RouteList call() throws Exception {
                return KubernetesClient.this.getKubernetesExtensions().getRoutes(namespace);
            }
        });
        if (answer == null) {
            answer = new RouteList();
        }
        return answer;
    }

    @Override
    @GET
    @Path(value="routes/{name}")
    public Route getRoute(final @PathParam(value="name") @NotNull String name, final @QueryParam(value="namespace") String namespace) {
        this.validateNamespace(namespace, name);
        return KubernetesClient.handle404ByReturningNull(new Callable<Route>(){

            @Override
            public Route call() throws Exception {
                return KubernetesClient.this.getKubernetesExtensions().getRoute(name, namespace);
            }
        });
    }

    @Override
    @PUT
    @Path(value="routes/{name}")
    @Consumes(value={"application/json"})
    public String updateRoute(@NotNull String name, Route entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        return this.getKubernetesExtensions().updateRoute(name, entity, namespace);
    }

    @Override
    @DELETE
    @Path(value="routes/{name}")
    public String deleteRoute(@NotNull String name, String namespace) {
        this.validateNamespace(namespace, name);
        return this.getKubernetesExtensions().deleteRoute(name, namespace);
    }

    @Override
    @POST
    @Path(value="builds")
    public String createBuild(Build entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setNamespace(namespace);
        return this.getKubernetesExtensions().createBuild(entity, namespace);
    }

    @Override
    @DELETE
    @Path(value="builds/{name}")
    public String deleteBuild(@NotNull String name, String namespace) {
        this.validateNamespace(namespace, name);
        return this.getKubernetesExtensions().deleteBuild(name, namespace);
    }

    @Override
    @GET
    @Path(value="builds/{name}")
    public Build getBuild(final @NotNull String name, final String namespace) {
        this.validateNamespace(namespace, name);
        return KubernetesClient.handle404ByReturningNull(new Callable<Build>(){

            @Override
            public Build call() throws Exception {
                return KubernetesClient.this.getKubernetesExtensions().getBuild(name, namespace);
            }
        });
    }

    @Override
    @GET
    @Path(value="builds")
    @Produces(value={"application/json"})
    public BuildList getBuilds(final String namespace) {
        this.validateNamespace(namespace, null);
        BuildList answer = KubernetesClient.handle404ByReturningNull(new Callable<BuildList>(){

            @Override
            public BuildList call() throws Exception {
                return KubernetesClient.this.getKubernetesExtensions().getBuilds(namespace);
            }
        });
        if (answer == null) {
            answer = new BuildList();
        }
        return answer;
    }

    @Override
    @PUT
    @Path(value="builds/{name}")
    @Consumes(value={"application/json"})
    public String updateBuild(@NotNull String name, Build entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        return this.getKubernetesExtensions().updateBuild(name, entity, namespace);
    }

    @Override
    @GET
    @Path(value="buildConfigs/{name}")
    public BuildConfig getBuildConfig(final @NotNull String name, final String namespace) {
        this.validateNamespace(namespace, name);
        return KubernetesClient.handle404ByReturningNull(new Callable<BuildConfig>(){

            @Override
            public BuildConfig call() throws Exception {
                return KubernetesClient.this.getKubernetesExtensions().getBuildConfig(name, namespace);
            }
        });
    }

    @Override
    @GET
    @Path(value="buildConfigs")
    public BuildConfigList getBuildConfigs(String namespace) {
        this.validateNamespace(namespace, null);
        return this.getKubernetesExtensions().getBuildConfigs(namespace);
    }

    @Override
    @GET
    @Path(value="deploymentConfigs/{name}")
    public DeploymentConfig getDeploymentConfig(final @NotNull String name, final String namespace) {
        this.validateNamespace(namespace, name);
        return KubernetesClient.handle404ByReturningNull(new Callable<DeploymentConfig>(){

            @Override
            public DeploymentConfig call() throws Exception {
                return KubernetesClient.this.getKubernetesExtensions().getDeploymentConfig(name, namespace);
            }
        });
    }

    @Override
    @GET
    @Path(value="deploymentConfigs")
    public DeploymentConfigList getDeploymentConfigs(final String namespace) {
        this.validateNamespace(namespace, null);
        DeploymentConfigList answer = KubernetesClient.handle404ByReturningNull(new Callable<DeploymentConfigList>(){

            @Override
            public DeploymentConfigList call() throws Exception {
                return KubernetesClient.this.getKubernetesExtensions().getDeploymentConfigs(namespace);
            }
        });
        if (answer == null) {
            answer = new DeploymentConfigList();
        }
        return answer;
    }

    @Override
    @PUT
    @Path(value="buildConfigs/{name}")
    @Consumes(value={"application/json"})
    public String updateBuildConfig(@NotNull String name, BuildConfig entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
        metadata.setNamespace(namespace);
        if (!KubernetesHelper.hasResourceVersion((HasMetadata)entity)) {
            BuildConfig old = this.getBuildConfig(name, namespace);
            if (old == null) {
                return this.createBuildConfig(entity, namespace);
            }
            String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)old);
            metadata.setResourceVersion(resourceVersion);
        }
        return this.getKubernetesExtensions().updateBuildConfig(name, entity, namespace);
    }

    @Override
    @PUT
    @Path(value="deploymentConfigs/{name}")
    @Consumes(value={"application/json"})
    public String updateDeploymentConfig(@NotNull String name, DeploymentConfig entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        return this.getKubernetesExtensions().updateDeploymentConfig(name, entity, namespace);
    }

    @Override
    @POST
    @Path(value="buildConfigs")
    public String createBuildConfig(BuildConfig entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setNamespace(namespace);
        return this.getKubernetesExtensions().createBuildConfig(entity, namespace);
    }

    @Override
    @GET
    @Path(value="imageStreams/{name}")
    public ImageStream getImageStream(final @NotNull String name, final String namespace) {
        this.validateNamespace(namespace, name);
        return KubernetesClient.handle404ByReturningNull(new Callable<ImageStream>(){

            @Override
            public ImageStream call() throws Exception {
                return KubernetesClient.this.getKubernetesExtensions().getImageStream(name, namespace);
            }
        });
    }

    @Override
    @GET
    @Path(value="imageStreams")
    public ImageStreamList getImageStreams(final String namespace) {
        this.validateNamespace(namespace, null);
        ImageStreamList answer = KubernetesClient.handle404ByReturningNull(new Callable<ImageStreamList>(){

            @Override
            public ImageStreamList call() throws Exception {
                return KubernetesClient.this.getKubernetesExtensions().getImageStreams(namespace);
            }
        });
        if (answer == null) {
            answer = new ImageStreamList();
        }
        return answer;
    }

    @Override
    @PUT
    @Path(value="imageStreams/{name}")
    @Consumes(value={"application/json"})
    public String updateImageStream(@NotNull String name, ImageStream entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        return this.getKubernetesExtensions().updateImageStream(name, entity, namespace);
    }

    @Override
    @DELETE
    @Path(value="imageStreams/{name}")
    public String deleteImageStream(@NotNull String name, String namespace) {
        this.validateNamespace(namespace, name);
        return this.getKubernetesExtensions().deleteImageStream(name, namespace);
    }

    @Override
    @POST
    @Path(value="imageStreams")
    public String createImageStream(ImageStream entity, String namespace) throws Exception {
        this.validateNamespace(namespace, entity);
        KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setNamespace(namespace);
        return this.getKubernetesExtensions().createImageStream(entity, namespace);
    }

    @Override
    @POST
    @Path(value="buildconfigs/{name}/webhooks/{secret}/{type}")
    public String triggerBuild(@NotNull String name, String namespace, @NotNull String secret, @NotNull String type, byte[] body) {
        this.validateNamespace(namespace, name);
        return this.getKubernetesExtensions().triggerBuild(name, namespace, secret, type, body);
    }

    @Override
    @POST
    @Path(value="buildconfigs/{name}/instantiate")
    public String instantiateBuild(@NotNull String name, BuildRequest request, String namespace) {
        return this.getKubernetesExtensions().instantiateBuild(name, request, namespace);
    }

    public void deletePod(Pod entity, String namespace) throws Exception {
        if (Strings.isNotBlank((String)namespace)) {
            entity.getMetadata().setNamespace(namespace);
        }
        this.deletePod(entity);
    }

    public void deletePod(Pod entity) throws Exception {
        String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
        String id = KubernetesHelper.getName((HasMetadata)entity);
        this.validateNamespace(namespace, entity);
        LOG.info("Deleting Pod: " + id + " namespace: " + namespace);
        if (Strings.isNotBlank((String)namespace)) {
            this.deletePod(id, namespace);
        } else {
            this.deletePod(id);
        }
    }

    public void deleteService(Service entity, String namespace) throws Exception {
        if (Strings.isNotBlank((String)namespace)) {
            entity.getMetadata().setNamespace(namespace);
        }
        this.deleteService(entity);
    }

    public void deleteService(Service entity) throws Exception {
        String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
        String id = KubernetesHelper.getName((HasMetadata)entity);
        this.validateNamespace(namespace, entity);
        LOG.info("Deleting Service: " + id + " namespace: " + namespace);
        if (Strings.isNotBlank((String)namespace)) {
            this.deleteService(id, namespace);
        } else {
            this.deleteService(id);
        }
    }

    public void deleteReplicationControllerAndPods(ReplicationController replicationController, String namespace) throws Exception {
        if (Strings.isNotBlank((String)namespace)) {
            replicationController.getMetadata().setNamespace(namespace);
        }
        this.deleteReplicationControllerAndPods(replicationController);
    }

    public void deleteReplicationControllerAndPods(ReplicationController replicationController) throws Exception {
        String id = KubernetesHelper.getName((HasMetadata)replicationController);
        String namespace = KubernetesHelper.getNamespace((HasMetadata)replicationController);
        this.validateNamespace(namespace, replicationController);
        LOG.info("Deleting ReplicationController: " + id + " namespace: " + namespace);
        this.deleteReplicationController(replicationController);
        List<Pod> podsToDelete = this.getPodsForReplicationController(replicationController);
        for (Pod pod : podsToDelete) {
            this.deletePod(pod);
        }
    }

    protected void validateNamespace(String namespace, Object entity) {
        if (Strings.isNullOrBlank((String)namespace)) {
            String message = "No namespace supported";
            if (entity != null) {
                message = message + " for " + KubernetesHelper.summaryText(entity);
            }
            throw new IllegalArgumentException(message);
        }
    }

    public void deleteReplicationController(ReplicationController replicationController, String namespace) throws Exception {
        if (Strings.isNotBlank((String)namespace)) {
            replicationController.getMetadata().setNamespace(namespace);
        }
        this.deleteReplicationController(replicationController);
    }

    public void deleteReplicationController(ReplicationController entity) throws Exception {
        String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
        String id = KubernetesHelper.getName((HasMetadata)entity);
        if (Strings.isNotBlank((String)namespace)) {
            this.deleteReplicationController(id, namespace);
        } else {
            this.deleteReplicationController(id);
        }
    }

    public ReplicationController getReplicationControllerForPod(String podId) {
        Pod pod = this.getPod(podId);
        return this.getReplicationControllerForPod(pod);
    }

    public ReplicationController getReplicationControllerForPod(Pod pod) {
        ReplicationControllerList replicationControllers;
        List items;
        Map labels;
        if (pod != null && (labels = pod.getMetadata().getLabels()) != null && labels.size() > 0 && (items = (replicationControllers = this.getReplicationControllers()).getItems()) != null) {
            List nonZeroReplicas;
            int size;
            ArrayList<ReplicationController> matched = new ArrayList<ReplicationController>();
            for (ReplicationController item : items) {
                if (!KubernetesHelper.filterLabels(labels, item.getMetadata().getLabels())) continue;
                matched.add(item);
            }
            int matchedSize = matched.size();
            if (matchedSize > 1 && (size = (nonZeroReplicas = Filters.filter(matched, (Filter)new Filter<ReplicationController>(){

                public boolean matches(ReplicationController replicationController) {
                    Integer replicas;
                    ReplicationControllerStatus currentStatus;
                    Integer desiredReplicas;
                    ReplicationControllerSpec replicationControllerSpec = replicationController.getSpec();
                    return replicationControllerSpec != null && (desiredReplicas = replicationControllerSpec.getReplicas()) != null && desiredReplicas > 0 && (currentStatus = replicationController.getStatus()) != null && (replicas = currentStatus.getReplicas()) != null && replicas > 0;
                }
            })).size()) > 0) {
                return (ReplicationController)nonZeroReplicas.get(0);
            }
            if (matchedSize >= 1) {
                return (ReplicationController)matched.get(0);
            }
        }
        return null;
    }

    public List<Pod> getPodsForReplicationController(ReplicationController service) {
        return KubernetesHelper.getPodsForReplicationController(service, this.getPodList());
    }

    public List<Pod> getPodsForReplicationController(String replicationControllerId) {
        ReplicationController replicationController = this.getReplicationController(replicationControllerId);
        if (replicationController == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getPodsForReplicationController(replicationController);
    }

    public List<Pod> getPodsForService(Service service) {
        return KubernetesHelper.getPodsForService(service, this.getPodList());
    }

    public List<Pod> getPodsForService(String serviceId) {
        Service service = this.getService(serviceId);
        if (service == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getPodsForService(service);
    }

    public WebSocketClient watchPods(Watcher<Pod> watcher) throws Exception {
        return this.watchPods(null, watcher);
    }

    public WebSocketClient watchPods(Map<String, String> labels, Watcher<Pod> watcher) throws Exception {
        return this.watchPods(this.getNamespace(), labels, watcher);
    }

    public WebSocketClient watchPods(String namespace, Map<String, String> labels, Watcher<Pod> watcher) throws Exception {
        PodList currentPodList = this.getPods(namespace);
        return this.watchPods(namespace, labels, watcher, currentPodList.getMetadata().getResourceVersion());
    }

    public WebSocketClient watchPods(String namespace, Map<String, String> labels, Watcher<Pod> watcher, String resourceVersion) throws Exception {
        return this.watchKubernetesEntities("pods", namespace, labels, watcher, resourceVersion);
    }

    public WebSocketClient watchServices(Watcher<Service> watcher) throws Exception {
        return this.watchServices(null, watcher);
    }

    public WebSocketClient watchServices(Map<String, String> labels, Watcher<Service> watcher) throws Exception {
        return this.watchServices(this.getNamespace(), labels, watcher);
    }

    public WebSocketClient watchServices(String namespace, Map<String, String> labels, Watcher<Service> watcher) throws Exception {
        ServiceList currentServiceList = this.getServices(namespace);
        return this.watchServices(namespace, labels, watcher, currentServiceList.getMetadata().getResourceVersion());
    }

    public WebSocketClient watchServices(String namespace, Map<String, String> labels, Watcher<Service> watcher, String resourceVersion) throws Exception {
        return this.watchKubernetesEntities("services", namespace, labels, watcher, resourceVersion);
    }

    public WebSocketClient watchEndpoints(Watcher<Endpoints> watcher) throws Exception {
        return this.watchEndpoints(null, watcher);
    }

    public WebSocketClient watchEndpoints(Map<String, String> labels, Watcher<Endpoints> watcher) throws Exception {
        return this.watchEndpoints(this.getNamespace(), labels, watcher);
    }

    public WebSocketClient watchEndpoints(String namespace, Map<String, String> labels, Watcher<Endpoints> watcher) throws Exception {
        EndpointsList currentEndpointList = this.getEndpoints(namespace);
        return this.watchEndpoints(namespace, labels, watcher, currentEndpointList.getMetadata().getResourceVersion());
    }

    public WebSocketClient watchEndpoints(String namespace, Map<String, String> labels, Watcher<Endpoints> watcher, String resourceVersion) throws Exception {
        return this.watchKubernetesEntities("endpoints", namespace, labels, watcher, resourceVersion);
    }

    public WebSocketClient watchReplicationControllers(Watcher<ReplicationController> watcher) throws Exception {
        return this.watchReplicationControllers(null, watcher);
    }

    public WebSocketClient watchReplicationControllers(Map<String, String> labels, Watcher<ReplicationController> watcher) throws Exception {
        return this.watchReplicationControllers(this.getNamespace(), labels, watcher);
    }

    public WebSocketClient watchReplicationControllers(String namespace, Map<String, String> labels, Watcher<ReplicationController> watcher) throws Exception {
        ReplicationControllerList currentReplicationControllerList = this.getReplicationControllers(namespace);
        return this.watchReplicationControllers(namespace, labels, watcher, currentReplicationControllerList.getMetadata().getResourceVersion());
    }

    public WebSocketClient watchReplicationControllers(String namespace, Map<String, String> labels, Watcher<ReplicationController> watcher, String resourceVersion) throws Exception {
        return this.watchKubernetesEntities("replicationcontrollers", namespace, labels, watcher, resourceVersion);
    }

    public WebSocketClient watchBuilds(Watcher<Build> watcher) throws Exception {
        return this.watchBuilds(null, watcher);
    }

    public WebSocketClient watchBuilds(Map<String, String> labels, Watcher<Build> watcher) throws Exception {
        return this.watchBuilds(this.getNamespace(), labels, watcher);
    }

    public WebSocketClient watchBuilds(String namespace, Map<String, String> labels, Watcher<Build> watcher) throws Exception {
        BuildList currentList = this.getBuilds(namespace);
        return this.watchBuilds(namespace, labels, watcher, currentList.getMetadata().getResourceVersion());
    }

    public WebSocketClient watchBuilds(String namespace, Map<String, String> labels, Watcher<Build> watcher, String resourceVersion) throws Exception {
        return this.watchOpenShiftEntities("builds", namespace, labels, watcher, resourceVersion);
    }

    public WebSocketClient watchBuildConfigs(Watcher<BuildConfig> watcher) throws Exception {
        return this.watchBuildConfigs(null, watcher);
    }

    public WebSocketClient watchBuildConfigs(Map<String, String> labels, Watcher<BuildConfig> watcher) throws Exception {
        return this.watchBuildConfigs(this.getNamespace(), labels, watcher);
    }

    public WebSocketClient watchBuildConfigs(String namespace, Map<String, String> labels, Watcher<BuildConfig> watcher) throws Exception {
        BuildConfigList currentList = this.getBuildConfigs(namespace);
        return this.watchBuildConfigs(namespace, labels, watcher, currentList.getMetadata().getResourceVersion());
    }

    public WebSocketClient watchBuildConfigs(String namespace, Map<String, String> labels, Watcher<BuildConfig> watcher, String resourceVersion) throws Exception {
        return this.watchOpenShiftEntities("buildconfigs", namespace, labels, watcher, resourceVersion);
    }

    public WebSocketClient watchRoutes(Watcher<Route> watcher) throws Exception {
        return this.watchRoutes(null, watcher);
    }

    public WebSocketClient watchRoutes(Map<String, String> labels, Watcher<Route> watcher) throws Exception {
        return this.watchRoutes(this.getNamespace(), labels, watcher);
    }

    public WebSocketClient watchRoutes(String namespace, Map<String, String> labels, Watcher<Route> watcher) throws Exception {
        RouteList currentList = this.getRoutes(namespace);
        return this.watchRoutes(namespace, labels, watcher, currentList.getMetadata().getResourceVersion());
    }

    public WebSocketClient watchRoutes(String namespace, Map<String, String> labels, Watcher<Route> watcher, String resourceVersion) throws Exception {
        return this.watchOpenShiftEntities("routes", namespace, labels, watcher, resourceVersion);
    }

    public WebSocketClient watchDeploymentConfigs(Watcher<DeploymentConfig> watcher) throws Exception {
        return this.watchDeploymentConfigs(null, watcher);
    }

    public WebSocketClient watchDeploymentConfigs(Map<String, String> labels, Watcher<DeploymentConfig> watcher) throws Exception {
        return this.watchDeploymentConfigs(this.getNamespace(), labels, watcher);
    }

    public WebSocketClient watchDeploymentConfigs(String namespace, Map<String, String> labels, Watcher<DeploymentConfig> watcher) throws Exception {
        DeploymentConfigList currentList = this.getDeploymentConfigs(namespace);
        return this.watchDeploymentConfigs(namespace, labels, watcher, currentList.getMetadata().getResourceVersion());
    }

    public WebSocketClient watchDeploymentConfigs(String namespace, Map<String, String> labels, Watcher<DeploymentConfig> watcher, String resourceVersion) throws Exception {
        return this.watchOpenShiftEntities("deploymentconfigs", namespace, labels, watcher, resourceVersion);
    }

    private WebSocketClient watchKubernetesEntities(String entityType, String namespace, Map<String, String> labels, Watcher<? extends HasMetadata> watcher, String resourceVersion) throws Exception {
        return this.watchEntities("api/v1", entityType, namespace, labels, watcher, resourceVersion);
    }

    private WebSocketClient watchOpenShiftEntities(String entityType, String namespace, Map<String, String> labels, Watcher<? extends HasMetadata> watcher, String resourceVersion) throws Exception {
        return this.watchEntities("oapi/v1", entityType, namespace, labels, watcher, resourceVersion);
    }

    private WebSocketClient watchEntities(String apiPath, String entityType, String namespace, Map<String, String> labels, Watcher<? extends HasMetadata> watcher, String resourceVersion) throws Exception {
        String watchUrl = this.getAddress().replaceFirst("^http", "ws") + "/" + apiPath + "/namespaces/" + namespace + "/" + entityType + "?watch=true&resourceVersion=" + resourceVersion;
        String labelsString = KubernetesHelper.toLabelsString(labels);
        if (Strings.isNotBlank((String)labelsString)) {
            watchUrl = watchUrl + "&labelSelector=" + labelsString;
        }
        LOG.debug("Connecting to {}", (Object)watchUrl);
        WebSocketClient client = this.getFactory().createWebSocketClient();
        try {
            URI watchUri = URI.create(watchUrl);
            ClientUpgradeRequest upgradeRequest = new ClientUpgradeRequest();
            upgradeRequest.setRequestURI(watchUri);
            upgradeRequest.setHeader("Origin", watchUri.getHost() + ":" + watchUri.getPort());
            String token = this.getFactory().findToken();
            if (token != null) {
                upgradeRequest.setHeader("Authorization", "Bearer " + token);
            }
            client.start();
            client.connect(watcher, watchUri, upgradeRequest);
            return client;
        }
        catch (Throwable t) {
            LOG.error("Failed to watch pods", t);
            return null;
        }
    }

    public String getServiceURL(String serviceName, String namespace, String serviceProtocol, boolean serviceExternal) {
        String serviceProto;
        Service srv = null;
        String serviceHost = KubernetesHelper.serviceToHost(serviceName);
        String servicePort = KubernetesHelper.serviceToPort(serviceName);
        String string = serviceProto = serviceProtocol != null ? serviceProtocol : KubernetesHelper.serviceToProtocol(serviceName, servicePort);
        if (!serviceExternal && Strings.isNotBlank((String)serviceHost) && Strings.isNotBlank((String)servicePort) && Strings.isNotBlank((String)serviceProtocol)) {
            return serviceProtocol + "://" + serviceHost + ":" + servicePort;
        }
        if (Strings.isNotBlank((String)namespace)) {
            srv = this.getService(serviceName, namespace);
        } else {
            for (Service s : this.getServices().getItems()) {
                String sid = KubernetesHelper.getName((HasMetadata)s);
                if (!serviceName.equals(sid)) continue;
                srv = s;
                break;
            }
        }
        if (srv == null) {
            throw new IllegalArgumentException("No kubernetes service could be found for name: " + serviceName + " in namespace: " + namespace);
        }
        RouteList routeList = this.getRoutes(namespace);
        for (Route route : routeList.getItems()) {
            if (!route.getSpec().getTo().getName().equals(serviceName)) continue;
            return (serviceProto + "://" + route.getSpec().getHost()).toLowerCase();
        }
        return (serviceProto + "://" + srv.getSpec().getPortalIP() + ":" + ((ServicePort)srv.getSpec().getPorts().iterator().next()).getPort()).toLowerCase();
    }

    public Route findRoute(String id, String namespace) {
        Route route;
        block2: {
            route = null;
            try {
                route = this.getRoute(id, namespace);
            }
            catch (WebApplicationException e) {
                if (e.getResponse().getStatus() == 404) break block2;
                throw e;
            }
        }
        return route;
    }

    public String triggerBuildAndGetUuid(@NotNull String name, String namespace) {
        return this.triggerBuildAndGetUuid(name, namespace, 60000L);
    }

    public String triggerBuildAndGetUuid(@NotNull String name, String namespace, long maxTimeoutMs) {
        String answer = this.triggerBuild(name, namespace);
        if (Strings.isNullOrBlank((String)answer)) {
            int sleepMillis = 2000;
            long endTime = System.currentTimeMillis() + maxTimeoutMs;
            while (true) {
                Build build;
                if ((build = this.findLatestBuild(name, namespace)) != null) {
                    String uid;
                    answer = uid = Builds.getUid(build);
                    break;
                }
                if (System.currentTimeMillis() > endTime) break;
                try {
                    Thread.sleep(sleepMillis);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return answer;
    }

    public List<Build> findBuilds(String buildConfigName, String namespace) {
        List items;
        ArrayList<Build> answer = new ArrayList<Build>();
        BuildList buildList = this.getBuilds(namespace);
        if (buildList != null && (items = buildList.getItems()) != null) {
            for (Build build : items) {
                String namespace2 = Builds.getNamespace(build);
                String name2 = Builds.getBuildConfigName(build);
                if (!Objects.equals(namespace, namespace2) || !Objects.equals(buildConfigName, name2)) continue;
                answer.add(build);
            }
        }
        return answer;
    }

    public Build findLatestBuild(String name, String namespace) {
        Build build2;
        List<Build> builds = this.findBuilds(name, namespace);
        int size = builds.size();
        if (size < 1) {
            return null;
        }
        if (size == 1) {
            return builds.get(0);
        }
        TreeMap<Date, Build> map = new TreeMap<Date, Build>();
        for (Build build2 : builds) {
            Date date = Builds.getCreationTimestampDate(build2);
            if (date == null) continue;
            Build otherBuild = (Build)map.get(date);
            if (otherBuild != null) {
                LOG.warn("Got 2 builds at the same time: " + build2 + " and " + otherBuild);
                continue;
            }
            map.put(date, build2);
        }
        Date lastKey = (Date)map.lastKey();
        build2 = (Build)map.get(lastKey);
        if (build2 == null) {
            LOG.warn("Should have a value for the last key " + lastKey + " for builds " + map);
        }
        return build2;
    }

    public String triggerBuild(@NotNull String name, String namespace) {
        BuildConfig buildConfig = this.getBuildConfig(name, namespace);
        if (buildConfig != null) {
            String aType;
            WebHookTrigger hook;
            List triggers = buildConfig.getSpec().getTriggers();
            String type = null;
            String secret = null;
            for (BuildTriggerPolicy trigger : triggers) {
                hook = trigger.getGeneric();
                if (hook == null) continue;
                secret = hook.getSecret();
                aType = trigger.getType();
                if (!Strings.isNotBlank((String)secret) || !Strings.isNotBlank((String)aType)) continue;
                type = aType;
            }
            if (Strings.isNullOrBlank(secret) || Strings.isNullOrBlank(type)) {
                for (BuildTriggerPolicy trigger : triggers) {
                    hook = trigger.getGithub();
                    if (hook == null) continue;
                    secret = hook.getSecret();
                    aType = trigger.getType();
                    if (!Strings.isNotBlank((String)secret) || !Strings.isNotBlank((String)aType)) continue;
                    type = aType;
                }
            }
            if (Strings.isNullOrBlank(type)) {
                throw new IllegalArgumentException("BuildConfig does not have a generic or github trigger for build: " + name + " namespace: " + namespace);
            }
            if (Strings.isNullOrBlank(secret)) {
                throw new IllegalArgumentException("BuildConfig does not have secret for build: " + name + " namespace: " + namespace);
            }
            LOG.info("Triggering build " + name + " namespace: " + namespace + " type: " + type);
            return this.doTriggerBuild(name, namespace, type, secret);
        }
        throw new IllegalArgumentException("No BuildConfig for build: " + name + " namespace: " + namespace);
    }

    protected String doTriggerBuild(String name, String namespace, String type, String secret) {
        WebClient webClient;
        String url;
        String baseUrl;
        boolean useVanillaUrl = true;
        boolean useFabric8Console = true;
        if (useFabric8Console) {
            baseUrl = this.getServiceURL("fabric8", namespace, "http", false);
            url = URLUtils.pathJoin((String[])new String[]{"/kubernetes/oapi", "v1", "buildConfigHooks", name, secret, type});
            webClient = new KubernetesFactory(baseUrl, true).createWebClient();
        } else {
            KubernetesFactory factory = this.getFactory();
            baseUrl = factory.getAddress();
            webClient = factory.createWebClient();
            url = URLUtils.pathJoin((String[])new String[]{"/oapi", "v1", "buildConfigHooks", name, secret, type});
        }
        if (Strings.isNotBlank((String)namespace)) {
            url = url + "?namespace=" + namespace;
        }
        if (useVanillaUrl) {
            String triggerBuildUrlText = URLUtils.pathJoin((String[])new String[]{baseUrl, url});
            LOG.info("Using a URL to trigger: " + triggerBuildUrlText);
            try {
                URL triggerBuildURL = new URL(triggerBuildUrlText);
                HttpURLConnection connection = (HttpURLConnection)triggerBuildURL.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Accept", "application/json");
                connection.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                out.close();
                int status = connection.getResponseCode();
                String message = connection.getResponseMessage();
                System.out.println("Got response code: " + status + " message: " + message);
                if (status != 200) {
                    throw new WebApplicationException(status + ": " + message, status);
                }
                return null;
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e, 400);
            }
        }
        LOG.info("Triggering build by posting to: " + url);
        webClient.getHeaders().remove((Object)"Accept");
        webClient = webClient.path((Object)url).header("Content-Type", new Object[]{"application/json"});
        Response response = webClient.post(new HashMap());
        int status = response.getStatus();
        if (status != 200) {
            Object entity = response.getEntity();
            if (entity != null) {
                String message = ExceptionResponseMapper.extractErrorMessage(entity);
                throw new WebApplicationException(status + ": " + message, status);
            }
            throw new WebApplicationException(status);
        }
        return null;
    }

    protected static <T> T handle404ByReturningNull(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                return null;
            }
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected Collection<Pod> getPodList() {
        return KubernetesHelper.getPodMap(this, this.namespace).values();
    }
}

