/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.UserConfigurationCompare;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.template.Template;
import io.fabric8.utils.Files;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Controller {
    private static final transient Logger LOG = LoggerFactory.getLogger(Controller.class);
    private final KubernetesClient kubernetes;
    private Map<String, Pod> podMap;
    private Map<String, ReplicationController> replicationControllerMap;
    private Map<String, Service> serviceMap;
    private boolean throwExceptionOnError = true;
    private boolean allowCreate = true;
    private boolean recreateMode;
    private boolean servicesOnlyMode;
    private boolean ignoreServiceMode;
    private boolean ignoreRunningOAuthClients = true;

    public Controller() {
        this(new KubernetesClient());
    }

    public Controller(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    public String apply(File file) throws Exception {
        String ext = Files.getFileExtension((File)file);
        if ("yaml".equalsIgnoreCase(ext)) {
            return this.applyYaml(file);
        }
        if ("json".equalsIgnoreCase(ext)) {
            return this.applyJson(file);
        }
        throw new IllegalArgumentException("Unknown file type " + ext);
    }

    public String applyJson(byte[] json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(String json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(File json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyYaml(String yaml) throws Exception {
        String json = this.convertYamlToJson(yaml);
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyYaml(File yaml) throws Exception {
        String json = this.convertYamlToJson(yaml);
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    private String convertYamlToJson(String yamlString) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(yamlString);
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    private String convertYamlToJson(File yamlFile) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        FileInputStream fstream = new FileInputStream(yamlFile);
        Map map = (Map)yaml.load((InputStream)fstream);
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    public String applyJson(InputStream json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public void apply(Object dto, String sourceName) throws Exception {
        if (dto instanceof List) {
            List list = (List)dto;
            for (Object element : list) {
                if (dto == element) {
                    LOG.warn("Found recursive nested object for " + dto + " of class: " + dto.getClass().getName());
                    continue;
                }
                this.apply(element, sourceName);
            }
        } else if (dto instanceof KubernetesList) {
            this.applyList((KubernetesList)dto, sourceName);
        } else if (dto != null) {
            this.applyEntity(dto, sourceName);
        }
    }

    public void applyEntity(Object dto, String sourceName) throws Exception {
        if (dto instanceof Pod) {
            this.applyPod((Pod)dto, sourceName);
        } else if (dto instanceof ReplicationController) {
            this.applyReplicationController((ReplicationController)dto, sourceName);
        } else if (dto instanceof Service) {
            this.applyService((Service)dto, sourceName);
        } else if (dto instanceof Namespace) {
            this.applyNamespace((Namespace)dto);
        } else if (dto instanceof Route) {
            this.applyRoute((Route)dto, sourceName);
        } else if (dto instanceof BuildConfig) {
            this.applyBuildConfig((BuildConfig)dto, sourceName);
        } else if (dto instanceof DeploymentConfig) {
            this.applyDeploymentConfig((DeploymentConfig)dto, sourceName);
        } else if (dto instanceof ImageStream) {
            this.applyImageStream((ImageStream)dto, sourceName);
        } else if (dto instanceof OAuthClient) {
            this.applyOAuthClient((OAuthClient)dto, sourceName);
        } else if (dto instanceof Template) {
            this.applyTemplate((Template)dto, sourceName);
        } else {
            throw new IllegalArgumentException("Unknown entity type " + dto);
        }
    }

    public void applyOAuthClient(OAuthClient entity, String sourceName) {
        String id = KubernetesHelper.getName(entity);
        Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring OAuthClient: " + id);
            return;
        }
        OAuthClient old = this.kubernetes.getOAuthClient(id);
        if (this.isRunning(old)) {
            if (this.isIgnoreRunningOAuthClients()) {
                LOG.info("Not updating the OAuthClient which are shared across namespaces as its already running");
                return;
            }
            if (UserConfigurationCompare.configEqual(entity, old)) {
                LOG.info("OAuthClient hasn't changed so not doing anything");
            } else if (this.isRecreateMode()) {
                this.kubernetes.deleteOAuthClient(id);
                this.doCreateOAuthClient(entity, sourceName);
            } else {
                try {
                    String answer = this.kubernetes.updateOAuthClient(id, entity);
                    LOG.info("Updated pod result: " + answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update pod from " + sourceName + ". " + e + ". " + entity, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating an OAuthClient from " + sourceName + " name " + KubernetesHelper.getName(entity));
        } else {
            this.doCreateOAuthClient(entity, sourceName);
        }
    }

    protected void doCreateOAuthClient(OAuthClient entity, String sourceName) {
        String result = null;
        try {
            result = this.kubernetes.createOAuthClient(entity);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
        }
    }

    public void applyTemplate(Template entity, String sourceName) {
        Object result = this.processTemplate(entity, sourceName);
        if (result != null) {
            try {
                this.applyEntity(result, sourceName);
            }
            catch (Exception e) {
                this.onApplyError("Failed to apply result of template expansion from " + sourceName + ". " + e + ". " + result, e);
            }
        }
    }

    public Object processTemplate(Template entity, String sourceName) {
        String id = KubernetesHelper.getName(entity);
        Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
        String namespace = KubernetesHelper.getNamespace(entity);
        LOG.info("Creating Template " + namespace + ":" + id + " " + KubernetesHelper.summaryText(entity));
        Object result = null;
        try {
            String json = this.kubernetes.createTemplate(entity, namespace);
            LOG.info("Template processed into: " + json);
            result = KubernetesHelper.loadJson(json);
            this.printSummary(result);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create controller from " + sourceName + ". " + e + ". " + entity, e);
        }
        return result;
    }

    protected void printSummary(Object kubeResource) throws IOException {
        if (kubeResource != null) {
            LOG.debug("  " + kubeResource.getClass().getSimpleName() + " " + kubeResource);
        }
        if (kubeResource instanceof Template) {
            Template template = (Template)kubeResource;
            String id = KubernetesHelper.getName(template);
            LOG.info("  Template " + id + " " + KubernetesHelper.summaryText(template));
            this.printSummary(template.getObjects());
            return;
        }
        List<Object> list = KubernetesHelper.toItemList(kubeResource);
        for (Object object : list) {
            if (object == null) continue;
            if (object == list) {
                LOG.warn("Ignoring recursive list " + list);
                continue;
            }
            if (object instanceof List) {
                this.printSummary(object);
                continue;
            }
            String kind = object.getClass().getSimpleName();
            String id = KubernetesHelper.getObjectId(object);
            LOG.info("    " + kind + " " + id + " " + KubernetesHelper.summaryText(object));
        }
    }

    public void applyRoute(Route entity, String sourceName) {
        Route route;
        String id = KubernetesHelper.getName(entity);
        Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
        String namespace = KubernetesHelper.getNamespace(entity);
        if (Strings.isNullOrBlank((String)namespace)) {
            namespace = this.kubernetes.getNamespace();
        }
        if ((route = this.kubernetes.findRoute(id, namespace)) == null) {
            try {
                LOG.info("Creating Route " + namespace + ":" + id);
                this.kubernetes.createRoute(entity, namespace);
            }
            catch (Exception e) {
                this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public void applyBuildConfig(BuildConfig entity, String sourceName) {
        try {
            this.kubernetes.createBuildConfig(entity, this.getNamespace());
        }
        catch (Exception e) {
            this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e, e);
        }
    }

    public void applyDeploymentConfig(DeploymentConfig entity, String sourceName) {
        try {
            this.kubernetes.createDeploymentConfig(entity, this.getNamespace());
        }
        catch (Exception e) {
            this.onApplyError("Failed to create DeploymentConfig from " + sourceName + ". " + e, e);
        }
    }

    public void applyImageStream(ImageStream entity, String sourceName) {
        try {
            this.kubernetes.createImageStream(entity, this.getNamespace());
        }
        catch (Exception e) {
            this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e, e);
        }
    }

    public void applyList(KubernetesList list, String sourceName) throws Exception {
        List entities = list.getItems();
        if (entities != null) {
            for (Object entity : entities) {
                this.applyEntity(entity, sourceName);
            }
        }
    }

    public void applyService(Service service, String sourceName) throws Exception {
        Service old;
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName(service);
        Objects.notNull((Object)id, (String)("No name for " + service + " " + sourceName));
        if (this.isIgnoreServiceMode()) {
            LOG.debug("Ignoring Service: " + namespace + ":" + id);
            return;
        }
        if (this.serviceMap == null) {
            this.serviceMap = KubernetesHelper.getServiceMap(this.kubernetes, namespace);
        }
        if (this.isRunning(old = this.serviceMap.get(id))) {
            if (UserConfigurationCompare.configEqual(service, old)) {
                LOG.info("Service hasn't changed so not doing anything");
            } else if (this.isRecreateMode()) {
                this.kubernetes.deleteService(service, namespace);
                this.doCreateService(service, namespace, sourceName);
            } else {
                LOG.info("Updating a service from " + sourceName);
                try {
                    String answer = this.kubernetes.updateService(id, service, namespace);
                    LOG.info("Updated service: " + answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update controller from " + sourceName + ". " + e + ". " + service, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(service));
        } else {
            this.doCreateService(service, namespace, sourceName);
        }
    }

    protected void doCreateService(Service service, String namespace, String sourceName) {
        LOG.info("Creating a service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(service));
        try {
            String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createService(service, namespace) : this.kubernetes.createService(service);
            LOG.info("Created service: " + answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create service from " + sourceName + ". " + e + ". " + service, e);
        }
    }

    public void applyNamespace(Namespace entity) {
        LOG.info("Creating a namespace " + KubernetesHelper.getOrCreateMetadata(entity).getName());
        try {
            String answer = this.kubernetes.createNamespace(entity);
            LOG.info("Created namespace: " + answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create namespace. " + e + ". " + entity, e);
        }
    }

    public void applyReplicationController(ReplicationController replicationController, String sourceName) throws Exception {
        ReplicationController old;
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName(replicationController);
        Objects.notNull((Object)id, (String)("No name for " + replicationController + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring ReplicationController: " + namespace + ":" + id);
            return;
        }
        if (this.replicationControllerMap == null) {
            this.replicationControllerMap = KubernetesHelper.getReplicationControllerMap(this.kubernetes, namespace);
        }
        if (this.isRunning(old = this.replicationControllerMap.get(id))) {
            if (UserConfigurationCompare.configEqual(replicationController, old)) {
                LOG.info("ReplicationController hasn't changed so not doing anything");
            } else if (this.isRecreateMode()) {
                this.kubernetes.deleteReplicationControllerAndPods(replicationController, namespace);
                this.doCreateReplicationController(replicationController, namespace, sourceName);
            } else {
                LOG.info("Updating replicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(replicationController));
                try {
                    String answer = this.kubernetes.updateReplicationController(id, replicationController);
                    LOG.info("Updated replicationController: " + answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update replicationController from " + sourceName + ". " + e + ". " + replicationController, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a replicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(replicationController));
        } else {
            this.doCreateReplicationController(replicationController, namespace, sourceName);
        }
    }

    protected void doCreateReplicationController(ReplicationController replicationController, String namespace, String sourceName) {
        LOG.info("Creating a replicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(replicationController));
        try {
            PodTemplateSpec template;
            ReplicationControllerSpec spec = replicationController.getSpec();
            if (spec != null && (template = spec.getTemplate()) != null) {
                PodSpec podSpec = template.getSpec();
                this.validatePodSpec(podSpec, namespace);
            }
            String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createReplicationController(replicationController, namespace) : this.kubernetes.createReplicationController(replicationController);
            LOG.info("Created replicationController: " + answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create replicationController from " + sourceName + ". " + e + ". " + replicationController, e);
        }
    }

    protected void validatePodSpec(PodSpec podSpec, String namespace) {
        List volumes = podSpec.getVolumes();
        if (volumes != null) {
            for (Volume volume : volumes) {
                String secretName;
                SecretVolumeSource secret = volume.getSecret();
                if (secret == null || !Strings.isNotBlank((String)(secretName = secret.getSecretName()))) continue;
                KubernetesHelper.validateSecretExists(this.kubernetes, namespace, secretName);
            }
        }
    }

    public void applyPod(Pod pod, String sourceName) throws Exception {
        Pod old;
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName(pod);
        Objects.notNull((Object)id, (String)("No name for " + pod + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring Pod: " + namespace + ":" + id);
            return;
        }
        if (this.podMap == null) {
            this.podMap = KubernetesHelper.getPodMap(this.kubernetes, namespace);
        }
        if (this.isRunning(old = this.podMap.get(id))) {
            if (UserConfigurationCompare.configEqual(pod, old)) {
                LOG.info("Pod hasn't changed so not doing anything");
            } else if (this.isRecreateMode()) {
                this.kubernetes.deletePod(pod, namespace);
                this.doCreatePod(pod, namespace, sourceName);
            } else {
                LOG.info("Updating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(pod));
                try {
                    String answer = this.kubernetes.updatePod(id, pod);
                    LOG.info("Updated pod result: " + answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update pod from " + sourceName + ". " + e + ". " + pod, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(pod));
        } else {
            this.doCreatePod(pod, namespace, sourceName);
        }
    }

    protected void doCreatePod(Pod pod, String namespace, String sourceName) {
        LOG.info("Creating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(pod));
        try {
            PodSpec podSpec = pod.getSpec();
            if (podSpec != null) {
                this.validatePodSpec(podSpec, namespace);
            }
            String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createPod(pod, namespace) : this.kubernetes.createPod(pod);
            LOG.info("Created pod result: " + answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create pod from " + sourceName + ". " + e + ". " + pod, e);
        }
    }

    public String getNamespace() {
        return this.kubernetes.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.kubernetes.setNamespace(namespace);
    }

    public boolean isThrowExceptionOnError() {
        return this.throwExceptionOnError;
    }

    public void setThrowExceptionOnError(boolean throwExceptionOnError) {
        this.throwExceptionOnError = throwExceptionOnError;
    }

    protected boolean isRunning(OAuthClient entity) {
        return entity != null;
    }

    protected boolean isRunning(Pod entity) {
        return entity != null;
    }

    protected boolean isRunning(ReplicationController entity) {
        return entity != null;
    }

    protected boolean isRunning(Service entity) {
        return entity != null;
    }

    protected void onApplyError(String message, Exception e) {
        LOG.error(message, (Throwable)e);
        if (this.throwExceptionOnError) {
            throw new RuntimeException(message, e);
        }
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isRecreateMode() {
        return this.recreateMode;
    }

    public void setRecreateMode(boolean recreateMode) {
        this.recreateMode = recreateMode;
    }

    public void setServicesOnlyMode(boolean servicesOnlyMode) {
        this.servicesOnlyMode = servicesOnlyMode;
    }

    public boolean isServicesOnlyMode() {
        return this.servicesOnlyMode;
    }

    public boolean isIgnoreServiceMode() {
        return this.ignoreServiceMode;
    }

    public void setIgnoreServiceMode(boolean ignoreServiceMode) {
        this.ignoreServiceMode = ignoreServiceMode;
    }

    public boolean isIgnoreRunningOAuthClients() {
        return this.ignoreRunningOAuthClients;
    }

    public void setIgnoreRunningOAuthClients(boolean ignoreRunningOAuthClients) {
        this.ignoreRunningOAuthClients = ignoreRunningOAuthClients;
    }
}

