/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesExtensions;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Minion;
import io.fabric8.kubernetes.api.model.MinionList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerState;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.ImageRepository;
import io.fabric8.openshift.api.model.ImageRepositoryList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Filters;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClient
implements Kubernetes,
KubernetesExtensions {
    private static final transient Logger LOG = LoggerFactory.getLogger(KubernetesClient.class);
    private KubernetesFactory factoryReadOnly;
    private KubernetesFactory factoryWriteable;
    private Kubernetes kubernetes;
    private Kubernetes kubernetesWriteable;
    private KubernetesExtensions kubernetesExtensions;
    private String namespace = "";

    public KubernetesClient() {
        this(new KubernetesFactory());
    }

    public KubernetesClient(String url) {
        this(new KubernetesFactory(url));
    }

    public KubernetesClient(KubernetesFactory factory) {
        this.factoryReadOnly = factory;
    }

    public KubernetesClient(KubernetesFactory factoryReadOnly, KubernetesFactory factoryWriteable) {
        this.factoryReadOnly = factoryReadOnly;
        this.factoryWriteable = factoryWriteable;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Kubernetes getKubernetes() {
        return this.getKubernetes(false);
    }

    public Kubernetes getKubernetes(boolean writeable) {
        if (writeable) {
            if (this.kubernetesWriteable == null) {
                this.kubernetesWriteable = this.getFactory(true).createKubernetes();
            }
            return this.kubernetesWriteable;
        }
        if (this.kubernetes == null) {
            this.kubernetes = this.getFactory(false).createKubernetes();
        }
        return this.kubernetes;
    }

    public KubernetesExtensions getKubernetesExtensions() {
        if (this.kubernetesExtensions == null) {
            this.kubernetesExtensions = this.getFactory(true).createKubernetesExtensions();
        }
        return this.kubernetesExtensions;
    }

    public KubernetesFactory getFactory(boolean writeable) {
        if (writeable) {
            if (this.factoryWriteable == null) {
                this.factoryWriteable = new KubernetesFactory(true);
            }
            return this.factoryWriteable;
        }
        if (this.factoryReadOnly == null) {
            this.factoryReadOnly = new KubernetesFactory();
        }
        return this.factoryReadOnly;
    }

    public void setFactory(KubernetesFactory factory) {
        this.factoryReadOnly = this.factoryReadOnly;
    }

    public void setWriteableFactory(KubernetesFactory factory) {
        this.factoryWriteable = factory;
    }

    public String getAddress() {
        return this.getFactory(false).getAddress();
    }

    public String getWriteableAddress() {
        return this.getFactory(true).getAddress();
    }

    @GET
    @Path(value="pods")
    public PodList getPods() {
        return this.getPods(this.getNamespace());
    }

    @Override
    public PodList getPods(@QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getPods(namespace);
    }

    @DELETE
    @Path(value="pods/{podId}")
    public String deletePod(@NotNull String podId) throws Exception {
        return this.getWriteableKubernetes().deletePod(podId, this.getNamespace());
    }

    @Override
    @DELETE
    @Path(value="pods/{podId}")
    @Consumes(value={"text/plain"})
    public String deletePod(@NotNull String podId, String namespace) throws Exception {
        return this.getWriteableKubernetes().deletePod(podId, namespace);
    }

    @GET
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    public ReplicationController getReplicationController(@NotNull String controllerId) {
        return this.getReplicationController(controllerId, this.getNamespace());
    }

    @Override
    public ReplicationController getReplicationController(@PathParam(value="controllerId") @NotNull String controllerId, @QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getReplicationController(controllerId, namespace);
    }

    @DELETE
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    public String deleteReplicationController(@NotNull String controllerId) throws Exception {
        return this.getWriteableKubernetes().deleteReplicationController(controllerId, this.getNamespace());
    }

    @Override
    @DELETE
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteReplicationController(@NotNull String controllerId, String namespace) throws Exception {
        return this.getWriteableKubernetes().deleteReplicationController(controllerId, namespace);
    }

    @Override
    @DELETE
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteService(@NotNull String serviceId, String namespace) throws Exception {
        return this.getWriteableKubernetes().deleteService(serviceId, namespace);
    }

    @Path(value="replicationControllers")
    @GET
    @Produces(value={"application/json"})
    public ReplicationControllerList getReplicationControllers() {
        return this.getReplicationControllers(this.getNamespace());
    }

    @Override
    public ReplicationControllerList getReplicationControllers(@QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getReplicationControllers(namespace);
    }

    @PUT
    @Path(value="replicationControllers/{controllerId}")
    @Consumes(value={"application/json"})
    public String updateReplicationController(@NotNull String controllerId, ReplicationController entity) throws Exception {
        return this.updateReplicationController(controllerId, entity, this.getNamespace());
    }

    @Override
    @PUT
    @Path(value="replicationControllers/{controllerId}")
    @Consumes(value={"application/json"})
    public String updateReplicationController(@NotNull String controllerId, ReplicationController entity, String namespace) throws Exception {
        return this.getWriteableKubernetes().updateReplicationController(controllerId, entity, namespace);
    }

    @PUT
    @Path(value="services/{serviceId}")
    @Consumes(value={"application/json"})
    public String updateService(@NotNull String serviceId, Service entity) throws Exception {
        return this.updateService(serviceId, entity, this.getNamespace());
    }

    @Override
    public String updateService(@PathParam(value="serviceId") @NotNull String serviceId, Service entity, @QueryParam(value="namespace") String namespace) throws Exception {
        return this.getWriteableKubernetes().updateService(serviceId, entity, namespace);
    }

    @GET
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    public Service getService(@NotNull String serviceId) {
        return this.getService(serviceId, this.getNamespace());
    }

    @Override
    public Service getService(@PathParam(value="serviceId") @NotNull String serviceId, @QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getService(serviceId, namespace);
    }

    @DELETE
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    public String deleteService(@NotNull String serviceId) throws Exception {
        return this.deleteService(serviceId, this.getNamespace());
    }

    @GET
    @Path(value="pods/{podId}")
    public Pod getPod(@NotNull String podId) {
        return this.getPod(podId, this.getNamespace());
    }

    @Override
    public Pod getPod(@PathParam(value="podId") @NotNull String podId, @QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getPod(podId, namespace);
    }

    @PUT
    @Path(value="pods/{podId}")
    @Consumes(value={"application/json"})
    public String updatePod(@NotNull String podId, Pod entity) throws Exception {
        return this.updatePod(podId, entity, this.getNamespace());
    }

    @Override
    public String updatePod(@PathParam(value="podId") @NotNull String podId, Pod entity, @QueryParam(value="namespace") String namespace) throws Exception {
        return this.getKubernetes().updatePod(podId, entity, namespace);
    }

    @Path(value="services")
    @GET
    @Produces(value={"application/json"})
    public ServiceList getServices() {
        return this.getServices(this.getNamespace());
    }

    @Override
    public ServiceList getServices(@QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getServices(namespace);
    }

    @POST
    @Path(value="pods")
    @Consumes(value={"application/json"})
    public String createPod(Pod entity) throws Exception {
        return this.createPod(entity, this.getNamespace());
    }

    @Override
    @POST
    @Path(value="pods")
    @Consumes(value={"application/json"})
    public String createPod(Pod entity, String namespace) throws Exception {
        return this.getWriteableKubernetes().createPod(entity, namespace);
    }

    @Path(value="services")
    @POST
    @Consumes(value={"application/json"})
    public String createService(Service entity) throws Exception {
        return this.createService(entity, this.getNamespace());
    }

    @Override
    @Path(value="services")
    @POST
    @Consumes(value={"application/json"})
    public String createService(Service entity, String namespace) throws Exception {
        return this.getWriteableKubernetes().createService(entity, namespace);
    }

    @Path(value="replicationControllers")
    @POST
    @Consumes(value={"application/json"})
    public String createReplicationController(ReplicationController entity) throws Exception {
        return this.createReplicationController(entity, this.getNamespace());
    }

    @Override
    @Path(value="replicationControllers")
    @POST
    @Consumes(value={"application/json"})
    public String createReplicationController(ReplicationController entity, String namespace) throws Exception {
        return this.getWriteableKubernetes().createReplicationController(entity, namespace);
    }

    @GET
    @Path(value="endpoints")
    public EndpointsList getEndpoints() {
        return this.getEndpoints(this.getNamespace());
    }

    @Override
    @GET
    @Path(value="endpoints")
    public EndpointsList getEndpoints(String namespace) {
        return this.getEndpoints(namespace);
    }

    @Override
    @GET
    @Path(value="endpoints/{serviceId}")
    public Endpoints endpointsForService(@NotNull String serviceId, String namespace) {
        return this.getKubernetes().endpointsForService(serviceId, namespace);
    }

    @Override
    @GET
    @Path(value="minions")
    public MinionList getMinions() {
        return this.getKubernetes().getMinions();
    }

    @Override
    @GET
    @Path(value="minions/{minionId}")
    public Minion minion(@NotNull String minionId) {
        return this.getKubernetes().minion(minionId);
    }

    @Override
    @POST
    @Path(value="configs")
    @Consumes(value={"application/json"})
    public String createConfig(Object entity) throws Exception {
        return this.getKubernetesExtensions().createConfig(entity);
    }

    @Override
    @POST
    @Path(value="deploymentConfigs")
    public String createDeploymentConfig(DeploymentConfig entity) throws Exception {
        return this.getKubernetesExtensions().createDeploymentConfig(entity);
    }

    @Override
    @POST
    @Path(value="template")
    @Consumes(value={"application/json"})
    public String createTemplate(Object entity) throws Exception {
        return this.getKubernetesExtensions().createTemplate(entity);
    }

    @Override
    @POST
    @Path(value="templateConfigs")
    @Consumes(value={"application/json"})
    public String createTemplateConfig(Object entity) throws Exception {
        return this.getKubernetesExtensions().createTemplateConfig(entity);
    }

    @Override
    @DELETE
    @Path(value="buildConfigs/{name}")
    public String deleteBuildConfig(@NotNull String name, String namespace) {
        return this.getKubernetesExtensions().deleteBuildConfig(name, namespace);
    }

    @Override
    @DELETE
    @Path(value="deploymentConfigs/{name}")
    public String deleteDeploymentConfig(@NotNull String name, String namespace) {
        return this.getKubernetesExtensions().deleteDeploymentConfig(name, namespace);
    }

    @Override
    public RouteList getRoutes(@QueryParam(value="namespace") String namespace) {
        return this.getKubernetesExtensions().getRoutes(namespace);
    }

    @Override
    public Route getRoute(@PathParam(value="name") @NotNull String name, @QueryParam(value="namespace") String namespace) {
        return this.getKubernetesExtensions().getRoute(name, namespace);
    }

    @Override
    @POST
    @Path(value="builds")
    public String createBuild(Build entity) throws Exception {
        return this.getKubernetesExtensions().createBuild(entity);
    }

    @Override
    @DELETE
    @Path(value="builds/{name}")
    public String deleteBuild(@NotNull String name, String namespace) {
        return this.getKubernetesExtensions().deleteBuild(name, namespace);
    }

    @Override
    @GET
    @Path(value="builds/{name}")
    public Build getBuild(@NotNull String name, String namespace) {
        return this.getKubernetesExtensions().getBuild(name, namespace);
    }

    @Override
    @GET
    @Path(value="builds")
    public BuildList getBuilds(String namespace) {
        return this.getKubernetesExtensions().getBuilds(namespace);
    }

    @Override
    @PUT
    @Path(value="builds/{name}")
    @Consumes(value={"application/json"})
    public String updateBuild(@NotNull String name, Build entity, String namespace) throws Exception {
        return this.getKubernetesExtensions().updateBuild(name, entity, namespace);
    }

    @Override
    @GET
    @Path(value="buildConfigs/{name}")
    public BuildConfig getBuildConfig(@NotNull String name, String namespace) {
        return this.getKubernetesExtensions().getBuildConfig(name, namespace);
    }

    @Override
    @GET
    @Path(value="buildConfigs")
    public BuildConfigList getBuildConfigs(String namespace) {
        return this.getKubernetesExtensions().getBuildConfigs(namespace);
    }

    @Override
    @GET
    @Path(value="deploymentConfigs/{name}")
    public DeploymentConfig getDeploymentConfig(@NotNull String name, String namespace) {
        return this.getKubernetesExtensions().getDeploymentConfig(name, namespace);
    }

    @Override
    @GET
    @Path(value="deploymentConfigs")
    public DeploymentConfigList getDeploymentConfigs(String namespace) {
        return this.getKubernetesExtensions().getDeploymentConfigs(namespace);
    }

    @Override
    @PUT
    @Path(value="buildConfigs/{name}")
    @Consumes(value={"application/json"})
    public String updateBuildConfig(@NotNull String name, BuildConfig entity, String namespace) throws Exception {
        return this.getKubernetesExtensions().updateBuildConfig(name, entity, namespace);
    }

    @Override
    @PUT
    @Path(value="deploymentConfigs/{name}")
    @Consumes(value={"application/json"})
    public String updateDeploymentConfig(@NotNull String name, DeploymentConfig entity, String namespace) throws Exception {
        return this.getKubernetesExtensions().updateDeploymentConfig(name, entity, namespace);
    }

    @Override
    @POST
    @Path(value="buildConfigs")
    public String createBuildConfig(BuildConfig entity) throws Exception {
        return this.getKubernetesExtensions().createBuildConfig(entity);
    }

    @Override
    @GET
    @Path(value="imageRepositories/{name}")
    public ImageRepository getImageRepository(@NotNull String name, String namespace) {
        return this.getKubernetesExtensions().getImageRepository(name, namespace);
    }

    @Override
    @GET
    @Path(value="imageRepositories")
    public ImageRepositoryList getImageRepositories(String namespace) {
        return this.getKubernetesExtensions().getImageRepositories(namespace);
    }

    @Override
    @PUT
    @Path(value="imageRepositories/{name}")
    @Consumes(value={"application/json"})
    public String updateImageRepository(@NotNull String name, ImageRepository entity, String namespace) throws Exception {
        return this.getKubernetesExtensions().updateImageRepository(name, entity, namespace);
    }

    @Override
    @DELETE
    @Path(value="imageRepositories/{name}")
    public String deleteImageRepository(@NotNull String name, String namespace) {
        return this.getKubernetesExtensions().deleteImageRepository(name, namespace);
    }

    @Override
    @POST
    @Path(value="imageRepositories")
    public String createImageRepository(ImageRepository entity) throws Exception {
        return this.getKubernetesExtensions().createImageRepository(entity);
    }

    @Override
    @POST
    @Path(value="buildConfigHooks/{name}/{secret}/{type}")
    public String triggerBuild(@NotNull String name, String namespace, @NotNull String secret, @NotNull String type, Object body) {
        return this.getKubernetesExtensions().triggerBuild(name, namespace, secret, type, body);
    }

    public void deletePod(Pod entity) throws Exception {
        String id = entity.getId();
        String namespace = entity.getNamespace();
        if (Strings.isNotBlank((String)namespace)) {
            this.deletePod(id, namespace);
        } else {
            this.deletePod(id);
        }
    }

    public void deleteService(Service entity) throws Exception {
        String id = entity.getId();
        String namespace = entity.getNamespace();
        if (Strings.isNotBlank((String)namespace)) {
            this.deleteService(id, namespace);
        } else {
            this.deleteService(id);
        }
    }

    public void deleteReplicationController(ReplicationController entity) throws Exception {
        String id = entity.getId();
        String namespace = entity.getNamespace();
        if (Strings.isNotBlank((String)namespace)) {
            this.deleteReplicationController(id, namespace);
        } else {
            this.deleteReplicationController(id);
        }
    }

    public ReplicationController getReplicationControllerForPod(String podId) {
        Pod pod = this.getPod(podId);
        return this.getReplicationControllerForPod(pod);
    }

    public ReplicationController getReplicationControllerForPod(Pod pod) {
        ReplicationControllerList replicationControllers;
        List<ReplicationController> items;
        Map<String, String> labels;
        if (pod != null && (labels = pod.getLabels()) != null && labels.size() > 0 && (items = (replicationControllers = this.getReplicationControllers()).getItems()) != null) {
            List nonZeroReplicas;
            int size;
            ArrayList<ReplicationController> matched = new ArrayList<ReplicationController>();
            for (ReplicationController item : items) {
                if (!KubernetesHelper.filterLabels(labels, item.getLabels())) continue;
                matched.add(item);
            }
            int matchedSize = matched.size();
            if (matchedSize > 1 && (size = (nonZeroReplicas = Filters.filter(matched, (Filter)new Filter<ReplicationController>(){

                public boolean matches(ReplicationController replicationController) {
                    Integer replicas;
                    ReplicationControllerState currentState;
                    Integer desiredReplicas;
                    ReplicationControllerState desiredState = replicationController.getDesiredState();
                    return desiredState != null && (desiredReplicas = desiredState.getReplicas()) != null && desiredReplicas > 0 && (currentState = replicationController.getCurrentState()) != null && (replicas = currentState.getReplicas()) != null && replicas > 0;
                }
            })).size()) > 0) {
                return (ReplicationController)nonZeroReplicas.get(0);
            }
            if (matchedSize >= 1) {
                return (ReplicationController)matched.get(0);
            }
        }
        return null;
    }

    public List<Pod> getPodsForReplicationController(ReplicationController service) {
        return KubernetesHelper.getPodsForReplicationController(service, this.getPodList());
    }

    public List<Pod> getPodsForReplicationController(String replicationControllerId) {
        ReplicationController replicationController = this.getReplicationController(replicationControllerId);
        if (replicationController == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getPodsForReplicationController(replicationController);
    }

    public List<Pod> getPodsForService(Service service) {
        return KubernetesHelper.getPodsForService(service, this.getPodList());
    }

    public List<Pod> getPodsForService(String serviceId) {
        Service service = this.getService(serviceId);
        if (service == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getPodsForService(service);
    }

    public void triggerBuild(@NotNull String name, String namespace) {
        String secret;
        String type;
        BuildConfig buildConfig = this.getBuildConfig(name, namespace);
        if (buildConfig != null) {
            String aType;
            WebHookTrigger hook;
            List<BuildTriggerPolicy> triggers = buildConfig.getTriggers();
            type = null;
            secret = null;
            for (BuildTriggerPolicy trigger : triggers) {
                hook = trigger.getGeneric();
                if (hook == null) continue;
                secret = hook.getSecret();
                aType = trigger.getType();
                if (!Strings.isNotBlank((String)secret) || !Strings.isNotBlank((String)aType)) continue;
                type = aType;
            }
            if (Strings.isNullOrBlank(secret) || Strings.isNullOrBlank(type)) {
                for (BuildTriggerPolicy trigger : triggers) {
                    hook = trigger.getGithub();
                    if (hook == null) continue;
                    secret = hook.getSecret();
                    aType = trigger.getType();
                    if (!Strings.isNotBlank((String)secret) || !Strings.isNotBlank((String)aType)) continue;
                    type = aType;
                }
            }
            if (Strings.isNullOrBlank(type)) {
                throw new IllegalArgumentException("BuildConfig does not have a generic or github trigger for build: " + name + " namespace: " + namespace);
            }
            if (Strings.isNullOrBlank(secret)) {
                throw new IllegalArgumentException("BuildConfig does not have secret for build: " + name + " namespace: " + namespace);
            }
        } else {
            throw new IllegalArgumentException("No BuildConfig for build: " + name + " namespace: " + namespace);
        }
        LOG.info("Triggering build " + name + " namespace: " + namespace + " type: " + type);
        this.getKubernetesExtensions().triggerBuild(name, namespace, secret, type, null);
    }

    protected Kubernetes getWriteableKubernetes() {
        return this.getKubernetes(true);
    }

    protected Collection<Pod> getPodList() {
        return KubernetesHelper.getPodMap(this, this.namespace).values();
    }
}

