/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.mbeans;

import io.fabric8.kubernetes.api.model.ControllerDesiredState;
import io.fabric8.kubernetes.api.model.ReplicationControllerSchema;
import java.util.Map;

public class AppReplicationControllerSummaryDTO {
    private final String id;
    private final String namespace;
    private final Map<String, String> labels;
    private Integer replicas;
    private Map<String, String> replicaSelector;

    public AppReplicationControllerSummaryDTO(ReplicationControllerSchema controller) {
        this.id = controller.getId();
        this.namespace = controller.getNamespace();
        this.labels = controller.getLabels();
        ControllerDesiredState desiredState = controller.getDesiredState();
        if (desiredState != null) {
            this.replicas = desiredState.getReplicas();
            this.replicaSelector = desiredState.getReplicaSelector();
        }
    }

    public String toString() {
        return "AppReplicationControllerSummaryDTO{id='" + this.id + '\'' + ", namespace='" + this.namespace + '\'' + '}';
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public Map<String, String> getReplicaSelector() {
        return this.replicaSelector;
    }
}

