/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest.junit;

import io.fabric8.kubeapitest.KubeAPIServer;
import io.fabric8.kubeapitest.KubeAPITestException;
import io.fabric8.kubeapitest.junit.ClientInjectionHandler;
import io.fabric8.kubeapitest.junit.KubeConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubeConfigInjectionHandler
implements ClientInjectionHandler {
    @Override
    public boolean isTargetFieldAvailable(ExtensionContext extensionContext, boolean staticField) {
        return this.getFieldForKubeConfigInjection(extensionContext, staticField).isPresent();
    }

    @Override
    public void inject(ExtensionContext extensionContext, boolean staticField, KubeAPIServer kubeApiServer) {
        Field field = this.getFieldForKubeConfigInjection(extensionContext, staticField).orElseThrow(IllegalStateException::new);
        this.setKubeConfigYamlToField(extensionContext, field, kubeApiServer);
    }

    private void setKubeConfigYamlToField(ExtensionContext extensionContext, Field kubeConfigField, KubeAPIServer kubeApiServer) {
        try {
            Object target = extensionContext.getTestInstance().orElseGet(() -> extensionContext.getTestClass().orElseThrow(IllegalStateException::new));
            kubeConfigField.setAccessible(true);
            kubeConfigField.set(target, kubeApiServer.getKubeConfigYaml());
        }
        catch (IllegalAccessException e) {
            throw new KubeAPITestException(e);
        }
    }

    public Optional<Field> getFieldForKubeConfigInjection(ExtensionContext extensionContext, boolean staticField) {
        Class clazz = (Class)extensionContext.getTestClass().orElseThrow(IllegalStateException::new);
        List<Field> kubeConfigFields = KubeConfigInjectionHandler.getAllFieldsIncludingAllParents(clazz, f -> ((KubeConfig[])f.getAnnotationsByType(KubeConfig.class)).length > 0);
        if (kubeConfigFields.isEmpty()) {
            return Optional.empty();
        }
        if (kubeConfigFields.size() > 1) {
            throw new KubeAPITestException("More fields annotation with @" + KubeConfig.class.getSimpleName() + " annotation");
        }
        Field field = kubeConfigFields.get(0);
        if (!field.getType().equals(String.class)) {
            throw new KubeAPITestException("Field annotated with @" + KubeConfig.class.getSimpleName() + " is not a String");
        }
        if (Modifier.isStatic(field.getModifiers()) != staticField) {
            return Optional.empty();
        }
        return Optional.of(field);
    }

    public static List<Field> getAllFieldsIncludingAllParents(Class<?> clazz, Predicate<Field> predicate) {
        ArrayList<Field> staticFields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Arrays.stream(declaredFields).filter(predicate).forEach(staticFields::add);
        }
        return staticFields;
    }
}

