/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest.process;

import io.fabric8.kubeapitest.KubeAPITestException;
import io.fabric8.kubeapitest.Utils;
import io.fabric8.kubeapitest.binary.BinaryManager;
import io.fabric8.kubeapitest.process.ProcessReadinessChecker;
import io.fabric8.kubeapitest.process.UnexpectedProcessStopHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdProcess {
    private static final Logger log = LoggerFactory.getLogger(EtcdProcess.class);
    private static final Logger etcdLog = LoggerFactory.getLogger((String)(EtcdProcess.class.getName() + ".EtcdProcessLogs"));
    private final BinaryManager binaryManager;
    private volatile Process etcdProcess;
    private volatile boolean stopped = false;
    private final UnexpectedProcessStopHandler processStopHandler;
    private final boolean waitForHealthCheck;
    private final int startupTimeout;
    private File tempWalDir;
    private File tempDataDir;

    public EtcdProcess(BinaryManager binaryManager, UnexpectedProcessStopHandler processStopHandler, boolean waitForHealthCheck, int startupTimeout) {
        this.binaryManager = binaryManager;
        this.processStopHandler = processStopHandler;
        this.waitForHealthCheck = waitForHealthCheck;
        this.startupTimeout = startupTimeout;
    }

    public int startEtcd() {
        try {
            File etcdBinary = this.binaryManager.binaries().getEtcd();
            this.tempWalDir = Files.createTempDirectory("etcdwal", new FileAttribute[0]).toFile();
            this.tempDataDir = Files.createTempDirectory("etcddata", new FileAttribute[0]).toFile();
            log.trace("Using temp wal dir: {} and temp data dir: {}", (Object)this.tempWalDir.getPath(), (Object)this.tempDataDir.getPath());
            int port = Utils.findFreePort();
            int peerPort = Utils.findFreePort();
            if (!etcdBinary.exists()) {
                throw new KubeAPITestException("Missing binary for etcd on path: " + etcdBinary.getAbsolutePath());
            }
            this.etcdProcess = new ProcessBuilder(etcdBinary.getAbsolutePath(), "-data-dir", this.tempDataDir.getPath(), "-wal-dir", this.tempWalDir.getPath(), "--listen-client-urls", "http://0.0.0.0:" + port, "--advertise-client-urls", "http://0.0.0.0:" + port, "--initial-cluster", "default=http://localhost:" + peerPort, "--initial-advertise-peer-urls", "http://localhost:" + peerPort, "--listen-peer-urls", "http://localhost:" + peerPort).start();
            Utils.redirectProcessOutputToLogger(this.etcdProcess.getInputStream(), etcdLog);
            Utils.redirectProcessOutputToLogger(this.etcdProcess.getErrorStream(), etcdLog);
            this.etcdProcess.onExit().thenApply(p -> {
                if (!this.stopped) {
                    this.stopped = true;
                    log.error("etcd process stopped unexpectedly");
                    this.processStopHandler.processStopped((Process)p);
                }
                return null;
            });
            log.debug("etcd started on port: {}", (Object)port);
            if (this.waitForHealthCheck) {
                this.waitUntilEtcdHealthy(port);
            }
            return port;
        }
        catch (IOException e) {
            throw new KubeAPITestException(e);
        }
    }

    private void waitUntilEtcdHealthy(int port) {
        new ProcessReadinessChecker().waitUntilReady(port, "health", "etcd", false, this.startupTimeout);
    }

    public void cleanEtcdData() {
        try {
            Utils.deleteDirectory(this.tempDataDir);
            Utils.deleteDirectory(this.tempWalDir);
        }
        catch (IOException e) {
            throw new KubeAPITestException(e);
        }
    }

    public void stopEtcd() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.etcdProcess != null) {
            try {
                this.etcdProcess.destroyForcibly();
                this.etcdProcess.waitFor();
            }
            catch (InterruptedException e) {
                throw new KubeAPITestException(e);
            }
        }
        log.debug("etcd stopped");
    }
}

