/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sources.v1;

import io.fabric8.knative.duck.v1.CloudEventOverrides;
import io.fabric8.knative.duck.v1.CloudEventOverridesBuilder;
import io.fabric8.knative.duck.v1.CloudEventOverridesFluent;
import io.fabric8.knative.duck.v1.Destination;
import io.fabric8.knative.duck.v1.DestinationBuilder;
import io.fabric8.knative.duck.v1.DestinationFluent;
import io.fabric8.knative.sources.v1.ContainerSourceSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContainerSourceSpecFluent<A extends ContainerSourceSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private CloudEventOverridesBuilder ceOverrides;
    private DestinationBuilder sink;
    private PodTemplateSpecBuilder template;

    public ContainerSourceSpecFluent() {
    }

    public ContainerSourceSpecFluent(ContainerSourceSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides != null ? this.ceOverrides.build() : null;
    }

    public Destination buildSink() {
        return this.sink != null ? this.sink.build() : null;
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    protected void copyInstance(ContainerSourceSpec instance) {
        ContainerSourceSpec containerSourceSpec = instance = instance != null ? instance : new ContainerSourceSpec();
        if (instance != null) {
            this.withCeOverrides(instance.getCeOverrides());
            this.withSink(instance.getSink());
            this.withTemplate(instance.getTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CeOverridesNested<A> editCeOverrides() {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(null));
    }

    public CeOverridesNested<A> editOrNewCeOverrides() {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(new CloudEventOverridesBuilder().build()));
    }

    public CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(item));
    }

    public SinkNested<A> editOrNewSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(new DestinationBuilder().build()));
    }

    public SinkNested<A> editOrNewSinkLike(Destination item) {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(item));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public SinkNested<A> editSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(null));
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerSourceSpecFluent that = (ContainerSourceSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.ceOverrides, (Object)that.ceOverrides)) {
            return false;
        }
        if (!Objects.equals((Object)this.sink, (Object)that.sink)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public boolean hasSink() {
        return this.sink != null;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ceOverrides, this.sink, this.template, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ceOverrides != null) {
            sb.append("ceOverrides:");
            sb.append((Object)this.ceOverrides);
            sb.append(",");
        }
        if (this.sink != null) {
            sb.append("sink:");
            sb.append((Object)this.sink);
            sb.append(",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        this._visitables.remove((Object)"ceOverrides");
        if (ceOverrides != null) {
            this.ceOverrides = new CloudEventOverridesBuilder(ceOverrides);
            this._visitables.get((Object)"ceOverrides").add(this.ceOverrides);
        } else {
            this.ceOverrides = null;
            this._visitables.get((Object)"ceOverrides").remove((Object)this.ceOverrides);
        }
        return (A)((Object)this);
    }

    public CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNested(null);
    }

    public CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNested(item);
    }

    public SinkNested<A> withNewSink() {
        return new SinkNested(null);
    }

    public SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNested(item);
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public A withSink(Destination sink) {
        this._visitables.remove((Object)"sink");
        if (sink != null) {
            this.sink = new DestinationBuilder(sink);
            this._visitables.get((Object)"sink").add(this.sink);
        } else {
            this.sink = null;
            this._visitables.get((Object)"sink").remove((Object)this.sink);
        }
        return (A)((Object)this);
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)((Object)this);
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        public N and() {
            return (N)ContainerSourceSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class SinkNested<N>
    extends DestinationFluent<SinkNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        SinkNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)ContainerSourceSpecFluent.this.withSink(this.builder.build());
        }

        public N endSink() {
            return this.and();
        }
    }

    public class CeOverridesNested<N>
    extends CloudEventOverridesFluent<CeOverridesNested<N>>
    implements Nested<N> {
        CloudEventOverridesBuilder builder;

        CeOverridesNested(CloudEventOverrides item) {
            this.builder = new CloudEventOverridesBuilder(this, item);
        }

        public N and() {
            return (N)ContainerSourceSpecFluent.this.withCeOverrides(this.builder.build());
        }

        public N endCeOverrides() {
            return this.and();
        }
    }
}

