/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.duck.v1;

import io.fabric8.knative.duck.v1.Status;
import io.fabric8.knative.pkg.apis.Condition;
import io.fabric8.knative.pkg.apis.ConditionBuilder;
import io.fabric8.knative.pkg.apis.ConditionFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StatusFluent<A extends StatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private Long observedGeneration;
    private Map<String, Object> additionalProperties;

    public StatusFluent() {
    }

    public StatusFluent(Status instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Status instance) {
        Status status = instance = instance != null ? instance : new Status();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? StatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusFluent that = (StatusFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.conditions, this.observedGeneration, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)StatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

