/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sources.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.sources.v1.APIVersionKind;
import io.fabric8.knative.sources.v1.APIVersionKindBuilder;
import io.fabric8.knative.sources.v1.APIVersionKindFluent;
import io.fabric8.knative.sources.v1.APIVersionKindSelector;
import io.fabric8.knative.sources.v1.APIVersionKindSelectorBuilder;
import io.fabric8.knative.sources.v1.APIVersionKindSelectorFluent;
import io.fabric8.knative.sources.v1.ApiServerSourceSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ApiServerSourceSpecFluent<A extends ApiServerSourceSpecFluent<A>>
extends BaseFluent<A> {
    private CloudEventOverridesBuilder ceOverrides;
    private String mode;
    private LabelSelectorBuilder namespaceSelector;
    private APIVersionKindBuilder owner;
    private ArrayList<APIVersionKindSelectorBuilder> resources = new ArrayList();
    private String serviceAccountName;
    private DestinationBuilder sink;

    public ApiServerSourceSpecFluent() {
    }

    public ApiServerSourceSpecFluent(ApiServerSourceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ApiServerSourceSpec instance) {
        ApiServerSourceSpec apiServerSourceSpec = instance = instance != null ? instance : new ApiServerSourceSpec();
        if (instance != null) {
            this.withCeOverrides(instance.getCeOverrides());
            this.withMode(instance.getMode());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withOwner(instance.getOwner());
            this.withResources(instance.getResources());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSink(instance.getSink());
            this.withCeOverrides(instance.getCeOverrides());
            this.withMode(instance.getMode());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withOwner(instance.getOwner());
            this.withResources(instance.getResources());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSink(instance.getSink());
        }
    }

    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides != null ? this.ceOverrides.build() : null;
    }

    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        this._visitables.remove((Object)this.ceOverrides);
        if (ceOverrides != null) {
            this.ceOverrides = new CloudEventOverridesBuilder(ceOverrides);
            this._visitables.get((Object)"ceOverrides").add(this.ceOverrides);
        } else {
            this.ceOverrides = null;
            this._visitables.get((Object)"ceOverrides").remove((Object)this.ceOverrides);
        }
        return (A)((Object)this);
    }

    public boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNested(null);
    }

    public CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNested(item);
    }

    public CeOverridesNested<A> editCeOverrides() {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(null));
    }

    public CeOverridesNested<A> editOrNewCeOverrides() {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(new CloudEventOverridesBuilder().build()));
    }

    public CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(item));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.remove((Object)this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get((Object)"namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get((Object)"namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public APIVersionKind buildOwner() {
        return this.owner != null ? this.owner.build() : null;
    }

    public A withOwner(APIVersionKind owner) {
        this._visitables.remove((Object)this.owner);
        if (owner != null) {
            this.owner = new APIVersionKindBuilder(owner);
            this._visitables.get((Object)"owner").add(this.owner);
        } else {
            this.owner = null;
            this._visitables.get((Object)"owner").remove((Object)this.owner);
        }
        return (A)((Object)this);
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public A withNewOwner(String apiVersion, String kind) {
        return this.withOwner(new APIVersionKind(apiVersion, kind));
    }

    public OwnerNested<A> withNewOwner() {
        return new OwnerNested(null);
    }

    public OwnerNested<A> withNewOwnerLike(APIVersionKind item) {
        return new OwnerNested(item);
    }

    public OwnerNested<A> editOwner() {
        return this.withNewOwnerLike(Optional.ofNullable(this.buildOwner()).orElse(null));
    }

    public OwnerNested<A> editOrNewOwner() {
        return this.withNewOwnerLike(Optional.ofNullable(this.buildOwner()).orElse(new APIVersionKindBuilder().build()));
    }

    public OwnerNested<A> editOrNewOwnerLike(APIVersionKind item) {
        return this.withNewOwnerLike(Optional.ofNullable(this.buildOwner()).orElse(item));
    }

    public A addToResources(int index, APIVersionKindSelector item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get((Object)"resources").add(index, builder);
            this.resources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResources(int index, APIVersionKindSelector item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get((Object)"resources").set(index, builder);
            this.resources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResources(APIVersionKindSelector ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (APIVersionKindSelector item : items) {
            APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResources(Collection<APIVersionKindSelector> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (APIVersionKindSelector item : items) {
            APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResources(APIVersionKindSelector ... items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (APIVersionKindSelector item : items) {
            APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
            this._visitables.get((Object)"resources").remove((Object)builder);
            this.resources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResources(Collection<APIVersionKindSelector> items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (APIVersionKindSelector item : items) {
            APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
            this._visitables.get((Object)"resources").remove((Object)builder);
            this.resources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResources(Predicate<APIVersionKindSelectorBuilder> predicate) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        Iterator<APIVersionKindSelectorBuilder> each = this.resources.iterator();
        List visitables = this._visitables.get((Object)"resources");
        while (each.hasNext()) {
            APIVersionKindSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<APIVersionKindSelector> buildResources() {
        return this.resources != null ? ApiServerSourceSpecFluent.build(this.resources) : null;
    }

    public APIVersionKindSelector buildResource(int index) {
        return this.resources.get(index).build();
    }

    public APIVersionKindSelector buildFirstResource() {
        return this.resources.get(0).build();
    }

    public APIVersionKindSelector buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    public APIVersionKindSelector buildMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
        for (APIVersionKindSelectorBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
        for (APIVersionKindSelectorBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<APIVersionKindSelector> resources) {
        if (this.resources != null) {
            this._visitables.get((Object)"resources").clear();
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (APIVersionKindSelector item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)((Object)this);
    }

    public A withResources(APIVersionKindSelector ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove((Object)"resources");
        }
        if (resources != null) {
            for (APIVersionKindSelector item : resources) {
                this.addToResources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public ResourcesNested<A> addNewResource() {
        return new ResourcesNested(-1, null);
    }

    public ResourcesNested<A> addNewResourceLike(APIVersionKindSelector item) {
        return new ResourcesNested(-1, item);
    }

    public ResourcesNested<A> setNewResourceLike(int index, APIVersionKindSelector item) {
        return new ResourcesNested(index, item);
    }

    public ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    public ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)((Object)this);
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public Destination buildSink() {
        return this.sink != null ? this.sink.build() : null;
    }

    public A withSink(Destination sink) {
        this._visitables.remove((Object)this.sink);
        if (sink != null) {
            this.sink = new DestinationBuilder(sink);
            this._visitables.get((Object)"sink").add(this.sink);
        } else {
            this.sink = null;
            this._visitables.get((Object)"sink").remove((Object)this.sink);
        }
        return (A)((Object)this);
    }

    public boolean hasSink() {
        return this.sink != null;
    }

    public SinkNested<A> withNewSink() {
        return new SinkNested(null);
    }

    public SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNested(item);
    }

    public SinkNested<A> editSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(null));
    }

    public SinkNested<A> editOrNewSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(new DestinationBuilder().build()));
    }

    public SinkNested<A> editOrNewSinkLike(Destination item) {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApiServerSourceSpecFluent that = (ApiServerSourceSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.ceOverrides, (Object)that.ceOverrides)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals((Object)this.owner, (Object)that.owner)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        return Objects.equals((Object)this.sink, (Object)that.sink);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ceOverrides, this.mode, this.namespaceSelector, this.owner, this.resources, this.serviceAccountName, this.sink, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ceOverrides != null) {
            sb.append("ceOverrides:");
            sb.append((Object)((Object)this.ceOverrides) + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.owner != null) {
            sb.append("owner:");
            sb.append((Object)((Object)this.owner) + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.sink != null) {
            sb.append("sink:");
            sb.append((Object)this.sink);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SinkNested<N>
    extends DestinationFluent<SinkNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        SinkNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)ApiServerSourceSpecFluent.this.withSink(this.builder.build());
        }

        public N endSink() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends APIVersionKindSelectorFluent<ResourcesNested<N>>
    implements Nested<N> {
        APIVersionKindSelectorBuilder builder;
        int index;

        ResourcesNested(int index, APIVersionKindSelector item) {
            this.index = index;
            this.builder = new APIVersionKindSelectorBuilder(this, item);
        }

        public N and() {
            return (N)ApiServerSourceSpecFluent.this.setToResources(this.index, this.builder.build());
        }

        public N endResource() {
            return this.and();
        }
    }

    public class OwnerNested<N>
    extends APIVersionKindFluent<OwnerNested<N>>
    implements Nested<N> {
        APIVersionKindBuilder builder;

        OwnerNested(APIVersionKind item) {
            this.builder = new APIVersionKindBuilder(this, item);
        }

        public N and() {
            return (N)ApiServerSourceSpecFluent.this.withOwner(this.builder.build());
        }

        public N endOwner() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)ApiServerSourceSpecFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class CeOverridesNested<N>
    extends CloudEventOverridesFluent<CeOverridesNested<N>>
    implements Nested<N> {
        CloudEventOverridesBuilder builder;

        CeOverridesNested(CloudEventOverrides item) {
            this.builder = new CloudEventOverridesBuilder(this, item);
        }

        public N and() {
            return (N)ApiServerSourceSpecFluent.this.withCeOverrides(this.builder.build());
        }

        public N endCeOverrides() {
            return this.and();
        }
    }
}

