/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.flows.v1;

import io.fabric8.knative.flows.v1.SequenceSpec;
import io.fabric8.knative.flows.v1.SequenceStep;
import io.fabric8.knative.flows.v1.SequenceStepBuilder;
import io.fabric8.knative.flows.v1.SequenceStepFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SequenceSpecFluent<A extends SequenceSpecFluent<A>>
extends BaseFluent<A> {
    private ChannelTemplateSpecBuilder channelTemplate;
    private DestinationBuilder reply;
    private ArrayList<SequenceStepBuilder> steps = new ArrayList();

    public SequenceSpecFluent() {
    }

    public SequenceSpecFluent(SequenceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SequenceSpec instance) {
        SequenceSpec sequenceSpec = instance = instance != null ? instance : new SequenceSpec();
        if (instance != null) {
            this.withChannelTemplate(instance.getChannelTemplate());
            this.withReply(instance.getReply());
            this.withSteps(instance.getSteps());
            this.withChannelTemplate(instance.getChannelTemplate());
            this.withReply(instance.getReply());
            this.withSteps(instance.getSteps());
        }
    }

    public ChannelTemplateSpec buildChannelTemplate() {
        return this.channelTemplate != null ? this.channelTemplate.build() : null;
    }

    public A withChannelTemplate(ChannelTemplateSpec channelTemplate) {
        this._visitables.remove((Object)this.channelTemplate);
        if (channelTemplate != null) {
            this.channelTemplate = new ChannelTemplateSpecBuilder(channelTemplate);
            this._visitables.get((Object)"channelTemplate").add(this.channelTemplate);
        } else {
            this.channelTemplate = null;
            this._visitables.get((Object)"channelTemplate").remove((Object)this.channelTemplate);
        }
        return (A)((Object)this);
    }

    public boolean hasChannelTemplate() {
        return this.channelTemplate != null;
    }

    public ChannelTemplateNested<A> withNewChannelTemplate() {
        return new ChannelTemplateNested(null);
    }

    public ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item) {
        return new ChannelTemplateNested(item);
    }

    public ChannelTemplateNested<A> editChannelTemplate() {
        return this.withNewChannelTemplateLike(Optional.ofNullable(this.buildChannelTemplate()).orElse(null));
    }

    public ChannelTemplateNested<A> editOrNewChannelTemplate() {
        return this.withNewChannelTemplateLike(Optional.ofNullable(this.buildChannelTemplate()).orElse(new ChannelTemplateSpecBuilder().build()));
    }

    public ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item) {
        return this.withNewChannelTemplateLike(Optional.ofNullable(this.buildChannelTemplate()).orElse(item));
    }

    public Destination buildReply() {
        return this.reply != null ? this.reply.build() : null;
    }

    public A withReply(Destination reply) {
        this._visitables.remove((Object)this.reply);
        if (reply != null) {
            this.reply = new DestinationBuilder(reply);
            this._visitables.get((Object)"reply").add(this.reply);
        } else {
            this.reply = null;
            this._visitables.get((Object)"reply").remove((Object)this.reply);
        }
        return (A)((Object)this);
    }

    public boolean hasReply() {
        return this.reply != null;
    }

    public ReplyNested<A> withNewReply() {
        return new ReplyNested(null);
    }

    public ReplyNested<A> withNewReplyLike(Destination item) {
        return new ReplyNested(item);
    }

    public ReplyNested<A> editReply() {
        return this.withNewReplyLike(Optional.ofNullable(this.buildReply()).orElse(null));
    }

    public ReplyNested<A> editOrNewReply() {
        return this.withNewReplyLike(Optional.ofNullable(this.buildReply()).orElse(new DestinationBuilder().build()));
    }

    public ReplyNested<A> editOrNewReplyLike(Destination item) {
        return this.withNewReplyLike(Optional.ofNullable(this.buildReply()).orElse(item));
    }

    public A addToSteps(int index, SequenceStep item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        SequenceStepBuilder builder = new SequenceStepBuilder(item);
        if (index < 0 || index >= this.steps.size()) {
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        } else {
            this._visitables.get((Object)"steps").add(index, builder);
            this.steps.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSteps(int index, SequenceStep item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        SequenceStepBuilder builder = new SequenceStepBuilder(item);
        if (index < 0 || index >= this.steps.size()) {
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        } else {
            this._visitables.get((Object)"steps").set(index, builder);
            this.steps.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSteps(SequenceStep ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (SequenceStep item : items) {
            SequenceStepBuilder builder = new SequenceStepBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSteps(Collection<SequenceStep> items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (SequenceStep item : items) {
            SequenceStepBuilder builder = new SequenceStepBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSteps(SequenceStep ... items) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        for (SequenceStep item : items) {
            SequenceStepBuilder builder = new SequenceStepBuilder(item);
            this._visitables.get((Object)"steps").remove((Object)builder);
            this.steps.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSteps(Collection<SequenceStep> items) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        for (SequenceStep item : items) {
            SequenceStepBuilder builder = new SequenceStepBuilder(item);
            this._visitables.get((Object)"steps").remove((Object)builder);
            this.steps.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSteps(Predicate<SequenceStepBuilder> predicate) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        Iterator<SequenceStepBuilder> each = this.steps.iterator();
        List visitables = this._visitables.get((Object)"steps");
        while (each.hasNext()) {
            SequenceStepBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SequenceStep> buildSteps() {
        return this.steps != null ? SequenceSpecFluent.build(this.steps) : null;
    }

    public SequenceStep buildStep(int index) {
        return this.steps.get(index).build();
    }

    public SequenceStep buildFirstStep() {
        return this.steps.get(0).build();
    }

    public SequenceStep buildLastStep() {
        return this.steps.get(this.steps.size() - 1).build();
    }

    public SequenceStep buildMatchingStep(Predicate<SequenceStepBuilder> predicate) {
        for (SequenceStepBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingStep(Predicate<SequenceStepBuilder> predicate) {
        for (SequenceStepBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSteps(List<SequenceStep> steps) {
        if (this.steps != null) {
            this._visitables.get((Object)"steps").clear();
        }
        if (steps != null) {
            this.steps = new ArrayList();
            for (SequenceStep item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)((Object)this);
    }

    public A withSteps(SequenceStep ... steps) {
        if (this.steps != null) {
            this.steps.clear();
            this._visitables.remove((Object)"steps");
        }
        if (steps != null) {
            for (SequenceStep item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    public StepsNested<A> addNewStep() {
        return new StepsNested(-1, null);
    }

    public StepsNested<A> addNewStepLike(SequenceStep item) {
        return new StepsNested(-1, item);
    }

    public StepsNested<A> setNewStepLike(int index, SequenceStep item) {
        return new StepsNested(index, item);
    }

    public StepsNested<A> editStep(int index) {
        if (this.steps.size() <= index) {
            throw new RuntimeException("Can't edit steps. Index exceeds size.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public StepsNested<A> editFirstStep() {
        if (this.steps.size() == 0) {
            throw new RuntimeException("Can't edit first steps. The list is empty.");
        }
        return this.setNewStepLike(0, this.buildStep(0));
    }

    public StepsNested<A> editLastStep() {
        int index = this.steps.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last steps. The list is empty.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public StepsNested<A> editMatchingStep(Predicate<SequenceStepBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!predicate.test(this.steps.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching steps. No match found.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SequenceSpecFluent that = (SequenceSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.channelTemplate, (Object)that.channelTemplate)) {
            return false;
        }
        if (!Objects.equals((Object)this.reply, (Object)that.reply)) {
            return false;
        }
        return Objects.equals(this.steps, that.steps);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channelTemplate, this.reply, this.steps, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.channelTemplate != null) {
            sb.append("channelTemplate:");
            sb.append((Object)((Object)this.channelTemplate) + ",");
        }
        if (this.reply != null) {
            sb.append("reply:");
            sb.append((Object)((Object)this.reply) + ",");
        }
        if (this.steps != null && !this.steps.isEmpty()) {
            sb.append("steps:");
            sb.append(this.steps);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StepsNested<N>
    extends SequenceStepFluent<StepsNested<N>>
    implements Nested<N> {
        SequenceStepBuilder builder;
        int index;

        StepsNested(int index, SequenceStep item) {
            this.index = index;
            this.builder = new SequenceStepBuilder(this, item);
        }

        public N and() {
            return (N)SequenceSpecFluent.this.setToSteps(this.index, this.builder.build());
        }

        public N endStep() {
            return this.and();
        }
    }

    public class ReplyNested<N>
    extends DestinationFluent<ReplyNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        ReplyNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)SequenceSpecFluent.this.withReply(this.builder.build());
        }

        public N endReply() {
            return this.and();
        }
    }

    public class ChannelTemplateNested<N>
    extends ChannelTemplateSpecFluent<ChannelTemplateNested<N>>
    implements Nested<N> {
        ChannelTemplateSpecBuilder builder;

        ChannelTemplateNested(ChannelTemplateSpec item) {
            this.builder = new ChannelTemplateSpecBuilder(this, item);
        }

        public N and() {
            return (N)SequenceSpecFluent.this.withChannelTemplate(this.builder.build());
        }

        public N endChannelTemplate() {
            return this.and();
        }
    }
}

