/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.internal.pkg.apis.duck.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressStatus;
import io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.Addressable;
import io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AddressStatusFluent<A extends AddressStatusFluent<A>>
extends BaseFluent<A> {
    private AddressableBuilder address;
    private ArrayList<AddressableBuilder> addresses = new ArrayList();

    public AddressStatusFluent() {
    }

    public AddressStatusFluent(AddressStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AddressStatus instance) {
        AddressStatus addressStatus = instance = instance != null ? instance : new AddressStatus();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withAddresses(instance.getAddresses());
            this.withAddress(instance.getAddress());
            this.withAddresses(instance.getAddresses());
        }
    }

    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    public A withAddress(Addressable address) {
        this._visitables.get((Object)"address").remove((Object)this.address);
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        } else {
            this.address = null;
            this._visitables.get((Object)"address").remove((Object)this.address);
        }
        return (A)((Object)this);
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(String cACerts, String hostname, String name, String url) {
        return this.withAddress(new Addressable(cACerts, hostname, name, url));
    }

    public AddressNested<A> withNewAddress() {
        return new AddressNested(null);
    }

    public AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNested(item);
    }

    public AddressNested<A> editAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(null));
    }

    public AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(new AddressableBuilder().build()));
    }

    public AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(item));
    }

    public A addToAddresses(int index, Addressable item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        AddressableBuilder builder = new AddressableBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(index, builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAddresses(int index, Addressable item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        AddressableBuilder builder = new AddressableBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").set(index, builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(Addressable ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAddresses(Collection<Addressable> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(Addressable ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddresses(Collection<Addressable> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<AddressableBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<AddressableBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            AddressableBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Addressable> buildAddresses() {
        return this.addresses != null ? AddressStatusFluent.build(this.addresses) : null;
    }

    public Addressable buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public Addressable buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public Addressable buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public Addressable buildMatchingAddress(Predicate<AddressableBuilder> predicate) {
        for (AddressableBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<AddressableBuilder> predicate) {
        for (AddressableBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<Addressable> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (Addressable item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(Addressable ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (Addressable item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addNewAddress(String cACerts, String hostname, String name, String url) {
        return this.addToAddresses(new Addressable(cACerts, hostname, name, url));
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(Addressable item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, Addressable item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<AddressableBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddressStatusFluent that = (AddressStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.address, (Object)that.address)) {
            return false;
        }
        return Objects.equals(this.addresses, that.addresses);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.addresses, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append((Object)((Object)this.address) + ",");
        }
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AddressesNested<N>
    extends AddressableFluent<AddressesNested<N>>
    implements Nested<N> {
        AddressableBuilder builder;
        int index;

        AddressesNested(int index, Addressable item) {
            this.index = index;
            this.builder = new AddressableBuilder(this, item);
        }

        public N and() {
            return (N)AddressStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }

    public class AddressNested<N>
    extends AddressableFluent<AddressNested<N>>
    implements Nested<N> {
        AddressableBuilder builder;

        AddressNested(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        public N and() {
            return (N)AddressStatusFluent.this.withAddress(this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

