/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class DestinationFluent<A extends DestinationFluent<A>>
extends BaseFluent<A> {
    private String cACerts;
    private KReferenceBuilder ref;
    private String uri;

    public DestinationFluent() {
    }

    public DestinationFluent(Destination instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Destination instance) {
        Destination destination = instance = instance != null ? instance : new Destination();
        if (instance != null) {
            this.withCACerts(instance.getCACerts());
            this.withRef(instance.getRef());
            this.withUri(instance.getUri());
            this.withCACerts(instance.getCACerts());
            this.withRef(instance.getRef());
            this.withUri(instance.getUri());
        }
    }

    public String getCACerts() {
        return this.cACerts;
    }

    public A withCACerts(String cACerts) {
        this.cACerts = cACerts;
        return (A)((Object)this);
    }

    public boolean hasCACerts() {
        return this.cACerts != null;
    }

    public KReference buildRef() {
        return this.ref != null ? this.ref.build() : null;
    }

    public A withRef(KReference ref) {
        this._visitables.get((Object)"ref").remove((Object)this.ref);
        if (ref != null) {
            this.ref = new KReferenceBuilder(ref);
            this._visitables.get((Object)"ref").add(this.ref);
        } else {
            this.ref = null;
            this._visitables.get((Object)"ref").remove((Object)this.ref);
        }
        return (A)((Object)this);
    }

    public boolean hasRef() {
        return this.ref != null;
    }

    public RefNested<A> withNewRef() {
        return new RefNested(null);
    }

    public RefNested<A> withNewRefLike(KReference item) {
        return new RefNested(item);
    }

    public RefNested<A> editRef() {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(null));
    }

    public RefNested<A> editOrNewRef() {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(new KReferenceBuilder().build()));
    }

    public RefNested<A> editOrNewRefLike(KReference item) {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(item));
    }

    public String getUri() {
        return this.uri;
    }

    public A withUri(String uri) {
        this.uri = uri;
        return (A)((Object)this);
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DestinationFluent that = (DestinationFluent)((Object)o);
        if (!Objects.equals(this.cACerts, that.cACerts)) {
            return false;
        }
        if (!Objects.equals((Object)this.ref, (Object)that.ref)) {
            return false;
        }
        return Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cACerts, this.ref, this.uri, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cACerts != null) {
            sb.append("cACerts:");
            sb.append(this.cACerts + ",");
        }
        if (this.ref != null) {
            sb.append("ref:");
            sb.append((Object)((Object)this.ref) + ",");
        }
        if (this.uri != null) {
            sb.append("uri:");
            sb.append(this.uri);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RefNested<N>
    extends KReferenceFluent<RefNested<N>>
    implements Nested<N> {
        KReferenceBuilder builder;

        RefNested(KReference item) {
            this.builder = new KReferenceBuilder(this, item);
        }

        public N and() {
            return (N)DestinationFluent.this.withRef(this.builder.build());
        }

        public N endRef() {
            return this.and();
        }
    }
}

