/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpec;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecBuilder;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaSourceSpecFluent<A extends KafkaSourceSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> bootstrapServers = new ArrayList<String>();
    private CloudEventOverridesBuilder ceOverrides;
    private String consumerGroup;
    private Integer consumers;
    private DeliverySpecBuilder delivery;
    private String initialOffset;
    private KafkaNetSpecBuilder net;
    private DestinationBuilder sink;
    private List<String> topics = new ArrayList<String>();

    public KafkaSourceSpecFluent() {
    }

    public KafkaSourceSpecFluent(KafkaSourceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaSourceSpec instance) {
        KafkaSourceSpec kafkaSourceSpec = instance = instance != null ? instance : new KafkaSourceSpec();
        if (instance != null) {
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withCeOverrides(instance.getCeOverrides());
            this.withConsumerGroup(instance.getConsumerGroup());
            this.withConsumers(instance.getConsumers());
            this.withDelivery(instance.getDelivery());
            this.withInitialOffset(instance.getInitialOffset());
            this.withNet(instance.getNet());
            this.withSink(instance.getSink());
            this.withTopics(instance.getTopics());
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withCeOverrides(instance.getCeOverrides());
            this.withConsumerGroup(instance.getConsumerGroup());
            this.withConsumers(instance.getConsumers());
            this.withDelivery(instance.getDelivery());
            this.withInitialOffset(instance.getInitialOffset());
            this.withNet(instance.getNet());
            this.withSink(instance.getSink());
            this.withTopics(instance.getTopics());
        }
    }

    public A addToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.add(index, item);
        return (A)((Object)this);
    }

    public A setToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.set(index, item);
        return (A)((Object)this);
    }

    public A addToBootstrapServers(String ... items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBootstrapServers(String ... items) {
        if (this.bootstrapServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bootstrapServers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bootstrapServers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getBootstrapServer(int index) {
        return this.bootstrapServers.get(index);
    }

    public String getFirstBootstrapServer() {
        return this.bootstrapServers.get(0);
    }

    public String getLastBootstrapServer() {
        return this.bootstrapServers.get(this.bootstrapServers.size() - 1);
    }

    public String getMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBootstrapServers(List<String> bootstrapServers) {
        if (bootstrapServers != null) {
            this.bootstrapServers = new ArrayList<String>();
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        } else {
            this.bootstrapServers = null;
        }
        return (A)((Object)this);
    }

    public A withBootstrapServers(String ... bootstrapServers) {
        if (this.bootstrapServers != null) {
            this.bootstrapServers.clear();
            this._visitables.remove((Object)"bootstrapServers");
        }
        if (bootstrapServers != null) {
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBootstrapServers() {
        return this.bootstrapServers != null && !this.bootstrapServers.isEmpty();
    }

    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides != null ? this.ceOverrides.build() : null;
    }

    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        this._visitables.get((Object)"ceOverrides").remove((Object)this.ceOverrides);
        if (ceOverrides != null) {
            this.ceOverrides = new CloudEventOverridesBuilder(ceOverrides);
            this._visitables.get((Object)"ceOverrides").add(this.ceOverrides);
        } else {
            this.ceOverrides = null;
            this._visitables.get((Object)"ceOverrides").remove((Object)this.ceOverrides);
        }
        return (A)((Object)this);
    }

    public boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNested(null);
    }

    public CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNested(item);
    }

    public CeOverridesNested<A> editCeOverrides() {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(null));
    }

    public CeOverridesNested<A> editOrNewCeOverrides() {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(new CloudEventOverridesBuilder().build()));
    }

    public CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(item));
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public A withConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return (A)((Object)this);
    }

    public boolean hasConsumerGroup() {
        return this.consumerGroup != null;
    }

    public Integer getConsumers() {
        return this.consumers;
    }

    public A withConsumers(Integer consumers) {
        this.consumers = consumers;
        return (A)((Object)this);
    }

    public boolean hasConsumers() {
        return this.consumers != null;
    }

    public DeliverySpec buildDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    public A withDelivery(DeliverySpec delivery) {
        this._visitables.get((Object)"delivery").remove((Object)this.delivery);
        if (delivery != null) {
            this.delivery = new DeliverySpecBuilder(delivery);
            this._visitables.get((Object)"delivery").add(this.delivery);
        } else {
            this.delivery = null;
            this._visitables.get((Object)"delivery").remove((Object)this.delivery);
        }
        return (A)((Object)this);
    }

    public boolean hasDelivery() {
        return this.delivery != null;
    }

    public DeliveryNested<A> withNewDelivery() {
        return new DeliveryNested(null);
    }

    public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNested(item);
    }

    public DeliveryNested<A> editDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(null));
    }

    public DeliveryNested<A> editOrNewDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(new DeliverySpecBuilder().build()));
    }

    public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(item));
    }

    public String getInitialOffset() {
        return this.initialOffset;
    }

    public A withInitialOffset(String initialOffset) {
        this.initialOffset = initialOffset;
        return (A)((Object)this);
    }

    public boolean hasInitialOffset() {
        return this.initialOffset != null;
    }

    public KafkaNetSpec buildNet() {
        return this.net != null ? this.net.build() : null;
    }

    public A withNet(KafkaNetSpec net) {
        this._visitables.get((Object)"net").remove((Object)this.net);
        if (net != null) {
            this.net = new KafkaNetSpecBuilder(net);
            this._visitables.get((Object)"net").add(this.net);
        } else {
            this.net = null;
            this._visitables.get((Object)"net").remove((Object)this.net);
        }
        return (A)((Object)this);
    }

    public boolean hasNet() {
        return this.net != null;
    }

    public NetNested<A> withNewNet() {
        return new NetNested(null);
    }

    public NetNested<A> withNewNetLike(KafkaNetSpec item) {
        return new NetNested(item);
    }

    public NetNested<A> editNet() {
        return this.withNewNetLike(Optional.ofNullable(this.buildNet()).orElse(null));
    }

    public NetNested<A> editOrNewNet() {
        return this.withNewNetLike(Optional.ofNullable(this.buildNet()).orElse(new KafkaNetSpecBuilder().build()));
    }

    public NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
        return this.withNewNetLike(Optional.ofNullable(this.buildNet()).orElse(item));
    }

    public Destination buildSink() {
        return this.sink != null ? this.sink.build() : null;
    }

    public A withSink(Destination sink) {
        this._visitables.get((Object)"sink").remove((Object)this.sink);
        if (sink != null) {
            this.sink = new DestinationBuilder(sink);
            this._visitables.get((Object)"sink").add(this.sink);
        } else {
            this.sink = null;
            this._visitables.get((Object)"sink").remove((Object)this.sink);
        }
        return (A)((Object)this);
    }

    public boolean hasSink() {
        return this.sink != null;
    }

    public SinkNested<A> withNewSink() {
        return new SinkNested(null);
    }

    public SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNested(item);
    }

    public SinkNested<A> editSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(null));
    }

    public SinkNested<A> editOrNewSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(new DestinationBuilder().build()));
    }

    public SinkNested<A> editOrNewSinkLike(Destination item) {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(item));
    }

    public A addToTopics(int index, String item) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        this.topics.add(index, item);
        return (A)((Object)this);
    }

    public A setToTopics(int index, String item) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        this.topics.set(index, item);
        return (A)((Object)this);
    }

    public A addToTopics(String ... items) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        for (String item : items) {
            this.topics.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTopics(Collection<String> items) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        for (String item : items) {
            this.topics.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTopics(String ... items) {
        if (this.topics == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.topics.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTopics(Collection<String> items) {
        if (this.topics == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.topics.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public String getTopic(int index) {
        return this.topics.get(index);
    }

    public String getFirstTopic() {
        return this.topics.get(0);
    }

    public String getLastTopic() {
        return this.topics.get(this.topics.size() - 1);
    }

    public String getMatchingTopic(Predicate<String> predicate) {
        for (String item : this.topics) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTopic(Predicate<String> predicate) {
        for (String item : this.topics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTopics(List<String> topics) {
        if (topics != null) {
            this.topics = new ArrayList<String>();
            for (String item : topics) {
                this.addToTopics(item);
            }
        } else {
            this.topics = null;
        }
        return (A)((Object)this);
    }

    public A withTopics(String ... topics) {
        if (this.topics != null) {
            this.topics.clear();
            this._visitables.remove((Object)"topics");
        }
        if (topics != null) {
            for (String item : topics) {
                this.addToTopics(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTopics() {
        return this.topics != null && !this.topics.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaSourceSpecFluent that = (KafkaSourceSpecFluent)((Object)o);
        if (!Objects.equals(this.bootstrapServers, that.bootstrapServers)) {
            return false;
        }
        if (!Objects.equals((Object)this.ceOverrides, (Object)that.ceOverrides)) {
            return false;
        }
        if (!Objects.equals(this.consumerGroup, that.consumerGroup)) {
            return false;
        }
        if (!Objects.equals(this.consumers, that.consumers)) {
            return false;
        }
        if (!Objects.equals((Object)this.delivery, (Object)that.delivery)) {
            return false;
        }
        if (!Objects.equals(this.initialOffset, that.initialOffset)) {
            return false;
        }
        if (!Objects.equals((Object)this.net, (Object)that.net)) {
            return false;
        }
        if (!Objects.equals((Object)this.sink, (Object)that.sink)) {
            return false;
        }
        return Objects.equals(this.topics, that.topics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bootstrapServers, this.ceOverrides, this.consumerGroup, this.consumers, this.delivery, this.initialOffset, this.net, this.sink, this.topics, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootstrapServers != null && !this.bootstrapServers.isEmpty()) {
            sb.append("bootstrapServers:");
            sb.append(this.bootstrapServers + ",");
        }
        if (this.ceOverrides != null) {
            sb.append("ceOverrides:");
            sb.append((Object)((Object)this.ceOverrides) + ",");
        }
        if (this.consumerGroup != null) {
            sb.append("consumerGroup:");
            sb.append(this.consumerGroup + ",");
        }
        if (this.consumers != null) {
            sb.append("consumers:");
            sb.append(this.consumers + ",");
        }
        if (this.delivery != null) {
            sb.append("delivery:");
            sb.append((Object)((Object)this.delivery) + ",");
        }
        if (this.initialOffset != null) {
            sb.append("initialOffset:");
            sb.append(this.initialOffset + ",");
        }
        if (this.net != null) {
            sb.append("net:");
            sb.append((Object)((Object)this.net) + ",");
        }
        if (this.sink != null) {
            sb.append("sink:");
            sb.append((Object)((Object)this.sink) + ",");
        }
        if (this.topics != null && !this.topics.isEmpty()) {
            sb.append("topics:");
            sb.append(this.topics);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SinkNested<N>
    extends DestinationFluent<SinkNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        SinkNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSourceSpecFluent.this.withSink(this.builder.build());
        }

        public N endSink() {
            return this.and();
        }
    }

    public class NetNested<N>
    extends KafkaNetSpecFluent<NetNested<N>>
    implements Nested<N> {
        KafkaNetSpecBuilder builder;

        NetNested(KafkaNetSpec item) {
            this.builder = new KafkaNetSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSourceSpecFluent.this.withNet(this.builder.build());
        }

        public N endNet() {
            return this.and();
        }
    }

    public class DeliveryNested<N>
    extends DeliverySpecFluent<DeliveryNested<N>>
    implements Nested<N> {
        DeliverySpecBuilder builder;

        DeliveryNested(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSourceSpecFluent.this.withDelivery(this.builder.build());
        }

        public N endDelivery() {
            return this.and();
        }
    }

    public class CeOverridesNested<N>
    extends CloudEventOverridesFluent<CeOverridesNested<N>>
    implements Nested<N> {
        CloudEventOverridesBuilder builder;

        CeOverridesNested(CloudEventOverrides item) {
            this.builder = new CloudEventOverridesBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSourceSpecFluent.this.withCeOverrides(this.builder.build());
        }

        public N endCeOverrides() {
            return this.and();
        }
    }
}

