/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingSpec;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpec;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecBuilder;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluent;
import io.fabric8.knative.internal.pkg.tracker.Reference;
import io.fabric8.knative.internal.pkg.tracker.ReferenceBuilder;
import io.fabric8.knative.internal.pkg.tracker.ReferenceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaBindingSpecFluent<A extends KafkaBindingSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> bootstrapServers = new ArrayList<String>();
    private KafkaNetSpecBuilder net;
    private ReferenceBuilder subject;

    public KafkaBindingSpecFluent() {
    }

    public KafkaBindingSpecFluent(KafkaBindingSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaBindingSpec instance) {
        KafkaBindingSpec kafkaBindingSpec = instance = instance != null ? instance : new KafkaBindingSpec();
        if (instance != null) {
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withNet(instance.getNet());
            this.withSubject(instance.getSubject());
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withNet(instance.getNet());
            this.withSubject(instance.getSubject());
        }
    }

    public A addToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.add(index, item);
        return (A)((Object)this);
    }

    public A setToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.set(index, item);
        return (A)((Object)this);
    }

    public A addToBootstrapServers(String ... items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBootstrapServers(String ... items) {
        if (this.bootstrapServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bootstrapServers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bootstrapServers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getBootstrapServer(int index) {
        return this.bootstrapServers.get(index);
    }

    public String getFirstBootstrapServer() {
        return this.bootstrapServers.get(0);
    }

    public String getLastBootstrapServer() {
        return this.bootstrapServers.get(this.bootstrapServers.size() - 1);
    }

    public String getMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBootstrapServers(List<String> bootstrapServers) {
        if (bootstrapServers != null) {
            this.bootstrapServers = new ArrayList<String>();
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        } else {
            this.bootstrapServers = null;
        }
        return (A)((Object)this);
    }

    public A withBootstrapServers(String ... bootstrapServers) {
        if (this.bootstrapServers != null) {
            this.bootstrapServers.clear();
            this._visitables.remove((Object)"bootstrapServers");
        }
        if (bootstrapServers != null) {
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBootstrapServers() {
        return this.bootstrapServers != null && !this.bootstrapServers.isEmpty();
    }

    public KafkaNetSpec buildNet() {
        return this.net != null ? this.net.build() : null;
    }

    public A withNet(KafkaNetSpec net) {
        this._visitables.get((Object)"net").remove((Object)this.net);
        if (net != null) {
            this.net = new KafkaNetSpecBuilder(net);
            this._visitables.get((Object)"net").add(this.net);
        } else {
            this.net = null;
            this._visitables.get((Object)"net").remove((Object)this.net);
        }
        return (A)((Object)this);
    }

    public boolean hasNet() {
        return this.net != null;
    }

    public NetNested<A> withNewNet() {
        return new NetNested(null);
    }

    public NetNested<A> withNewNetLike(KafkaNetSpec item) {
        return new NetNested(item);
    }

    public NetNested<A> editNet() {
        return this.withNewNetLike(Optional.ofNullable(this.buildNet()).orElse(null));
    }

    public NetNested<A> editOrNewNet() {
        return this.withNewNetLike(Optional.ofNullable(this.buildNet()).orElse(new KafkaNetSpecBuilder().build()));
    }

    public NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
        return this.withNewNetLike(Optional.ofNullable(this.buildNet()).orElse(item));
    }

    public Reference buildSubject() {
        return this.subject != null ? this.subject.build() : null;
    }

    public A withSubject(Reference subject) {
        this._visitables.get((Object)"subject").remove((Object)this.subject);
        if (subject != null) {
            this.subject = new ReferenceBuilder(subject);
            this._visitables.get((Object)"subject").add(this.subject);
        } else {
            this.subject = null;
            this._visitables.get((Object)"subject").remove((Object)this.subject);
        }
        return (A)((Object)this);
    }

    public boolean hasSubject() {
        return this.subject != null;
    }

    public SubjectNested<A> withNewSubject() {
        return new SubjectNested(null);
    }

    public SubjectNested<A> withNewSubjectLike(Reference item) {
        return new SubjectNested(item);
    }

    public SubjectNested<A> editSubject() {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(null));
    }

    public SubjectNested<A> editOrNewSubject() {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(new ReferenceBuilder().build()));
    }

    public SubjectNested<A> editOrNewSubjectLike(Reference item) {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaBindingSpecFluent that = (KafkaBindingSpecFluent)((Object)o);
        if (!Objects.equals(this.bootstrapServers, that.bootstrapServers)) {
            return false;
        }
        if (!Objects.equals((Object)this.net, (Object)that.net)) {
            return false;
        }
        return Objects.equals((Object)this.subject, (Object)that.subject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bootstrapServers, this.net, this.subject, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootstrapServers != null && !this.bootstrapServers.isEmpty()) {
            sb.append("bootstrapServers:");
            sb.append(this.bootstrapServers + ",");
        }
        if (this.net != null) {
            sb.append("net:");
            sb.append((Object)((Object)this.net) + ",");
        }
        if (this.subject != null) {
            sb.append("subject:");
            sb.append((Object)this.subject);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubjectNested<N>
    extends ReferenceFluent<SubjectNested<N>>
    implements Nested<N> {
        ReferenceBuilder builder;

        SubjectNested(Reference item) {
            this.builder = new ReferenceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBindingSpecFluent.this.withSubject(this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }

    public class NetNested<N>
    extends KafkaNetSpecFluent<NetNested<N>>
    implements Nested<N> {
        KafkaNetSpecBuilder builder;

        NetNested(KafkaNetSpec item) {
            this.builder = new KafkaNetSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBindingSpecFluent.this.withNet(this.builder.build());
        }

        public N endNet() {
            return this.and();
        }
    }
}

