/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.knative.internal.networking.v1alpha1.LoadBalancerIngressStatus;
import io.fabric8.knative.internal.networking.v1alpha1.LoadBalancerIngressStatusBuilder;
import io.fabric8.knative.internal.networking.v1alpha1.LoadBalancerIngressStatusFluent;
import io.fabric8.knative.internal.networking.v1alpha1.LoadBalancerStatus;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class LoadBalancerStatusFluent<A extends LoadBalancerStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<LoadBalancerIngressStatusBuilder> ingress = new ArrayList();

    public LoadBalancerStatusFluent() {
    }

    public LoadBalancerStatusFluent(LoadBalancerStatus instance) {
        LoadBalancerStatus loadBalancerStatus = instance = instance != null ? instance : new LoadBalancerStatus();
        if (instance != null) {
            this.withIngress(instance.getIngress());
            this.withIngress(instance.getIngress());
        }
    }

    public A addToIngress(int index, LoadBalancerIngressStatus item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get((Object)"ingress").add(index, builder);
            this.ingress.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToIngress(int index, LoadBalancerIngressStatus item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get((Object)"ingress").set(index, builder);
            this.ingress.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToIngress(LoadBalancerIngressStatus ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (LoadBalancerIngressStatus item : items) {
            LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIngress(Collection<LoadBalancerIngressStatus> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (LoadBalancerIngressStatus item : items) {
            LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromIngress(LoadBalancerIngressStatus ... items) {
        if (this.ingress == null) {
            return (A)((Object)this);
        }
        for (LoadBalancerIngressStatus item : items) {
            LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);
            this._visitables.get((Object)"ingress").remove((Object)builder);
            this.ingress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIngress(Collection<LoadBalancerIngressStatus> items) {
        if (this.ingress == null) {
            return (A)((Object)this);
        }
        for (LoadBalancerIngressStatus item : items) {
            LoadBalancerIngressStatusBuilder builder = new LoadBalancerIngressStatusBuilder(item);
            this._visitables.get((Object)"ingress").remove((Object)builder);
            this.ingress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIngress(Predicate<LoadBalancerIngressStatusBuilder> predicate) {
        if (this.ingress == null) {
            return (A)((Object)this);
        }
        Iterator<LoadBalancerIngressStatusBuilder> each = this.ingress.iterator();
        List visitables = this._visitables.get((Object)"ingress");
        while (each.hasNext()) {
            LoadBalancerIngressStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LoadBalancerIngressStatus> buildIngress() {
        return this.ingress != null ? LoadBalancerStatusFluent.build(this.ingress) : null;
    }

    public LoadBalancerIngressStatus buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    public LoadBalancerIngressStatus buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    public LoadBalancerIngressStatus buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    public LoadBalancerIngressStatus buildMatchingIngress(Predicate<LoadBalancerIngressStatusBuilder> predicate) {
        for (LoadBalancerIngressStatusBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIngress(Predicate<LoadBalancerIngressStatusBuilder> predicate) {
        for (LoadBalancerIngressStatusBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngress(List<LoadBalancerIngressStatus> ingress) {
        if (this.ingress != null) {
            this._visitables.get((Object)"ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (LoadBalancerIngressStatus item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)((Object)this);
    }

    public A withIngress(LoadBalancerIngressStatus ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove((Object)"ingress");
        }
        if (ingress != null) {
            for (LoadBalancerIngressStatus item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    public A addNewIngress(String domain, String domainInternal, String ip, Boolean meshOnly) {
        return this.addToIngress(new LoadBalancerIngressStatus(domain, domainInternal, ip, meshOnly));
    }

    public IngressNested<A> addNewIngress() {
        return new IngressNested(-1, null);
    }

    public IngressNested<A> addNewIngressLike(LoadBalancerIngressStatus item) {
        return new IngressNested(-1, item);
    }

    public IngressNested<A> setNewIngressLike(int index, LoadBalancerIngressStatus item) {
        return new IngressNested(index, item);
    }

    public IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    public IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editMatchingIngress(Predicate<LoadBalancerIngressStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerStatusFluent that = (LoadBalancerStatusFluent)((Object)o);
        return Objects.equals(this.ingress, that.ingress);
    }

    public int hashCode() {
        return Objects.hash(this.ingress, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ingress != null && !this.ingress.isEmpty()) {
            sb.append("ingress:");
            sb.append(this.ingress);
        }
        sb.append("}");
        return sb.toString();
    }

    public class IngressNested<N>
    extends LoadBalancerIngressStatusFluent<IngressNested<N>>
    implements Nested<N> {
        LoadBalancerIngressStatusBuilder builder;
        int index;

        IngressNested(int index, LoadBalancerIngressStatus item) {
            this.index = index;
            this.builder = new LoadBalancerIngressStatusBuilder(this, item);
        }

        public N and() {
            return (N)LoadBalancerStatusFluent.this.setToIngress(this.index, this.builder.build());
        }

        public N endIngress() {
            return this.and();
        }
    }
}

