/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.internal.pkg.apis.duck.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1beta1.Source;
import io.fabric8.knative.internal.pkg.apis.duck.v1beta1.SourceBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1beta1.SourceFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1beta1.SourceList;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class SourceListFluent<A extends SourceListFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<SourceBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public SourceListFluent() {
    }

    public SourceListFluent(SourceList instance) {
        SourceList sourceList = instance = instance != null ? instance : new SourceList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToItems(int index, Source item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        SourceBuilder builder = new SourceBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToItems(int index, Source item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        SourceBuilder builder = new SourceBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToItems(Source ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Source item : items) {
            SourceBuilder builder = new SourceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToItems(Collection<Source> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Source item : items) {
            SourceBuilder builder = new SourceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromItems(Source ... items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (Source item : items) {
            SourceBuilder builder = new SourceBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromItems(Collection<Source> items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (Source item : items) {
            SourceBuilder builder = new SourceBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromItems(Predicate<SourceBuilder> predicate) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        Iterator<SourceBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            SourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Source> buildItems() {
        return this.items != null ? SourceListFluent.build(this.items) : null;
    }

    public Source buildItem(int index) {
        return this.items.get(index).build();
    }

    public Source buildFirstItem() {
        return this.items.get(0).build();
    }

    public Source buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public Source buildMatchingItem(Predicate<SourceBuilder> predicate) {
        for (SourceBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<SourceBuilder> predicate) {
        for (SourceBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withItems(List<Source> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (Source item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)((Object)this);
    }

    public A withItems(Source ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (Source item : items) {
                this.addToItems(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(Source item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, Source item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<SourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ListMeta getMetadata() {
        return this.metadata;
    }

    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceListFluent that = (SourceListFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ItemsNested<N>
    extends SourceFluent<ItemsNested<N>>
    implements Nested<N> {
        SourceBuilder builder;
        int index;

        ItemsNested(int index, Source item) {
            this.index = index;
            this.builder = new SourceBuilder(this, item);
        }

        public N and() {
            return (N)SourceListFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

