/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingSpec;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingSpecFluent;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpec;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecBuilder;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluentImpl;
import io.fabric8.knative.internal.pkg.tracker.Reference;
import io.fabric8.knative.internal.pkg.tracker.ReferenceBuilder;
import io.fabric8.knative.internal.pkg.tracker.ReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaBindingSpecFluentImpl<A extends KafkaBindingSpecFluent<A>>
extends BaseFluent<A>
implements KafkaBindingSpecFluent<A> {
    private List<String> bootstrapServers = new ArrayList<String>();
    private KafkaNetSpecBuilder net;
    private ReferenceBuilder subject;

    public KafkaBindingSpecFluentImpl() {
    }

    public KafkaBindingSpecFluentImpl(KafkaBindingSpec instance) {
        if (instance != null) {
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withNet(instance.getNet());
            this.withSubject(instance.getSubject());
        }
    }

    @Override
    public A addToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToBootstrapServers(String ... items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromBootstrapServers(String ... items) {
        for (String item : items) {
            if (this.bootstrapServers == null) continue;
            this.bootstrapServers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBootstrapServers(Collection<String> items) {
        for (String item : items) {
            if (this.bootstrapServers == null) continue;
            this.bootstrapServers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    public String getBootstrapServer(int index) {
        return this.bootstrapServers.get(index);
    }

    @Override
    public String getFirstBootstrapServer() {
        return this.bootstrapServers.get(0);
    }

    @Override
    public String getLastBootstrapServer() {
        return this.bootstrapServers.get(this.bootstrapServers.size() - 1);
    }

    @Override
    public String getMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBootstrapServers(List<String> bootstrapServers) {
        if (bootstrapServers != null) {
            this.bootstrapServers = new ArrayList<String>();
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        } else {
            this.bootstrapServers = null;
        }
        return (A)this;
    }

    @Override
    public A withBootstrapServers(String ... bootstrapServers) {
        if (this.bootstrapServers != null) {
            this.bootstrapServers.clear();
            this._visitables.remove((Object)"bootstrapServers");
        }
        if (bootstrapServers != null) {
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBootstrapServers() {
        return this.bootstrapServers != null && !this.bootstrapServers.isEmpty();
    }

    @Override
    @Deprecated
    public KafkaNetSpec getNet() {
        return this.net != null ? this.net.build() : null;
    }

    @Override
    public KafkaNetSpec buildNet() {
        return this.net != null ? this.net.build() : null;
    }

    @Override
    public A withNet(KafkaNetSpec net) {
        this._visitables.get((Object)"net").remove(this.net);
        if (net != null) {
            this.net = new KafkaNetSpecBuilder(net);
            this._visitables.get((Object)"net").add(this.net);
        } else {
            this.net = null;
            this._visitables.get((Object)"net").remove(this.net);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNet() {
        return this.net != null;
    }

    @Override
    public KafkaBindingSpecFluent.NetNested<A> withNewNet() {
        return new NetNestedImpl();
    }

    @Override
    public KafkaBindingSpecFluent.NetNested<A> withNewNetLike(KafkaNetSpec item) {
        return new NetNestedImpl(item);
    }

    @Override
    public KafkaBindingSpecFluent.NetNested<A> editNet() {
        return this.withNewNetLike(this.getNet());
    }

    @Override
    public KafkaBindingSpecFluent.NetNested<A> editOrNewNet() {
        return this.withNewNetLike(this.getNet() != null ? this.getNet() : new KafkaNetSpecBuilder().build());
    }

    @Override
    public KafkaBindingSpecFluent.NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
        return this.withNewNetLike(this.getNet() != null ? this.getNet() : item);
    }

    @Override
    @Deprecated
    public Reference getSubject() {
        return this.subject != null ? this.subject.build() : null;
    }

    @Override
    public Reference buildSubject() {
        return this.subject != null ? this.subject.build() : null;
    }

    @Override
    public A withSubject(Reference subject) {
        this._visitables.get((Object)"subject").remove(this.subject);
        if (subject != null) {
            this.subject = new ReferenceBuilder(subject);
            this._visitables.get((Object)"subject").add(this.subject);
        } else {
            this.subject = null;
            this._visitables.get((Object)"subject").remove(this.subject);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubject() {
        return this.subject != null;
    }

    @Override
    public KafkaBindingSpecFluent.SubjectNested<A> withNewSubject() {
        return new SubjectNestedImpl();
    }

    @Override
    public KafkaBindingSpecFluent.SubjectNested<A> withNewSubjectLike(Reference item) {
        return new SubjectNestedImpl(item);
    }

    @Override
    public KafkaBindingSpecFluent.SubjectNested<A> editSubject() {
        return this.withNewSubjectLike(this.getSubject());
    }

    @Override
    public KafkaBindingSpecFluent.SubjectNested<A> editOrNewSubject() {
        return this.withNewSubjectLike(this.getSubject() != null ? this.getSubject() : new ReferenceBuilder().build());
    }

    @Override
    public KafkaBindingSpecFluent.SubjectNested<A> editOrNewSubjectLike(Reference item) {
        return this.withNewSubjectLike(this.getSubject() != null ? this.getSubject() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaBindingSpecFluentImpl that = (KafkaBindingSpecFluentImpl)o;
        if (!Objects.equals(this.bootstrapServers, that.bootstrapServers)) {
            return false;
        }
        if (!Objects.equals(this.net, that.net)) {
            return false;
        }
        return Objects.equals(this.subject, that.subject);
    }

    public int hashCode() {
        return Objects.hash(this.bootstrapServers, this.net, this.subject, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootstrapServers != null && !this.bootstrapServers.isEmpty()) {
            sb.append("bootstrapServers:");
            sb.append(this.bootstrapServers + ",");
        }
        if (this.net != null) {
            sb.append("net:");
            sb.append(this.net + ",");
        }
        if (this.subject != null) {
            sb.append("subject:");
            sb.append(this.subject);
        }
        sb.append("}");
        return sb.toString();
    }

    class SubjectNestedImpl<N>
    extends ReferenceFluentImpl<KafkaBindingSpecFluent.SubjectNested<N>>
    implements KafkaBindingSpecFluent.SubjectNested<N>,
    Nested<N> {
        ReferenceBuilder builder;

        SubjectNestedImpl(Reference item) {
            this.builder = new ReferenceBuilder(this, item);
        }

        SubjectNestedImpl() {
            this.builder = new ReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBindingSpecFluentImpl.this.withSubject(this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    class NetNestedImpl<N>
    extends KafkaNetSpecFluentImpl<KafkaBindingSpecFluent.NetNested<N>>
    implements KafkaBindingSpecFluent.NetNested<N>,
    Nested<N> {
        KafkaNetSpecBuilder builder;

        NetNestedImpl(KafkaNetSpec item) {
            this.builder = new KafkaNetSpecBuilder(this, item);
        }

        NetNestedImpl() {
            this.builder = new KafkaNetSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBindingSpecFluentImpl.this.withNet(this.builder.build());
        }

        @Override
        public N endNet() {
            return this.and();
        }
    }
}

