/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.flows.v1;

import io.fabric8.knative.flows.v1.SequenceChannelStatus;
import io.fabric8.knative.flows.v1.SequenceChannelStatusBuilder;
import io.fabric8.knative.flows.v1.SequenceChannelStatusFluent;
import io.fabric8.knative.flows.v1.SequenceStatus;
import io.fabric8.knative.flows.v1.SequenceSubscriptionStatus;
import io.fabric8.knative.flows.v1.SequenceSubscriptionStatusBuilder;
import io.fabric8.knative.flows.v1.SequenceSubscriptionStatusFluent;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AuthStatus;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AuthStatusBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AuthStatusFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SequenceStatusFluent<A extends SequenceStatusFluent<A>>
extends BaseFluent<A> {
    private AddressableBuilder address;
    private Map<String, String> annotations;
    private AuthStatusBuilder auth;
    private ArrayList<SequenceChannelStatusBuilder> channelStatuses = new ArrayList();
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private Long observedGeneration;
    private ArrayList<SequenceSubscriptionStatusBuilder> subscriptionStatuses = new ArrayList();
    private Map<String, Object> additionalProperties;

    public SequenceStatusFluent() {
    }

    public SequenceStatusFluent(SequenceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SequenceStatus instance) {
        SequenceStatus sequenceStatus = instance = instance != null ? instance : new SequenceStatus();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withAnnotations(instance.getAnnotations());
            this.withAuth(instance.getAuth());
            this.withChannelStatuses(instance.getChannelStatuses());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withSubscriptionStatuses(instance.getSubscriptionStatuses());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    public A withAddress(Addressable address) {
        this._visitables.remove((Object)"address");
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        } else {
            this.address = null;
            this._visitables.get((Object)"address").remove((Object)this.address);
        }
        return (A)((Object)this);
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(String cACerts, String audience, String name, String url) {
        return this.withAddress(new Addressable(cACerts, audience, name, url));
    }

    public AddressNested<A> withNewAddress() {
        return new AddressNested(null);
    }

    public AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNested(item);
    }

    public AddressNested<A> editAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(null));
    }

    public AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(new AddressableBuilder().build()));
    }

    public AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(item));
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public AuthStatus buildAuth() {
        return this.auth != null ? this.auth.build() : null;
    }

    public A withAuth(AuthStatus auth) {
        this._visitables.remove((Object)"auth");
        if (auth != null) {
            this.auth = new AuthStatusBuilder(auth);
            this._visitables.get((Object)"auth").add(this.auth);
        } else {
            this.auth = null;
            this._visitables.get((Object)"auth").remove((Object)this.auth);
        }
        return (A)((Object)this);
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public A withNewAuth(String serviceAccountName) {
        return this.withAuth(new AuthStatus(serviceAccountName));
    }

    public AuthNested<A> withNewAuth() {
        return new AuthNested(null);
    }

    public AuthNested<A> withNewAuthLike(AuthStatus item) {
        return new AuthNested(item);
    }

    public AuthNested<A> editAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(null));
    }

    public AuthNested<A> editOrNewAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(new AuthStatusBuilder().build()));
    }

    public AuthNested<A> editOrNewAuthLike(AuthStatus item) {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(item));
    }

    public A addToChannelStatuses(int index, SequenceChannelStatus item) {
        if (this.channelStatuses == null) {
            this.channelStatuses = new ArrayList();
        }
        SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);
        if (index < 0 || index >= this.channelStatuses.size()) {
            this._visitables.get((Object)"channelStatuses").add(builder);
            this.channelStatuses.add(builder);
        } else {
            this._visitables.get((Object)"channelStatuses").add(index, builder);
            this.channelStatuses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToChannelStatuses(int index, SequenceChannelStatus item) {
        if (this.channelStatuses == null) {
            this.channelStatuses = new ArrayList();
        }
        SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);
        if (index < 0 || index >= this.channelStatuses.size()) {
            this._visitables.get((Object)"channelStatuses").add(builder);
            this.channelStatuses.add(builder);
        } else {
            this._visitables.get((Object)"channelStatuses").set(index, builder);
            this.channelStatuses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToChannelStatuses(SequenceChannelStatus ... items) {
        if (this.channelStatuses == null) {
            this.channelStatuses = new ArrayList();
        }
        for (SequenceChannelStatus item : items) {
            SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);
            this._visitables.get((Object)"channelStatuses").add(builder);
            this.channelStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToChannelStatuses(Collection<SequenceChannelStatus> items) {
        if (this.channelStatuses == null) {
            this.channelStatuses = new ArrayList();
        }
        for (SequenceChannelStatus item : items) {
            SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);
            this._visitables.get((Object)"channelStatuses").add(builder);
            this.channelStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromChannelStatuses(SequenceChannelStatus ... items) {
        if (this.channelStatuses == null) {
            return (A)((Object)this);
        }
        for (SequenceChannelStatus item : items) {
            SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);
            this._visitables.get((Object)"channelStatuses").remove((Object)builder);
            this.channelStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromChannelStatuses(Collection<SequenceChannelStatus> items) {
        if (this.channelStatuses == null) {
            return (A)((Object)this);
        }
        for (SequenceChannelStatus item : items) {
            SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);
            this._visitables.get((Object)"channelStatuses").remove((Object)builder);
            this.channelStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromChannelStatuses(Predicate<SequenceChannelStatusBuilder> predicate) {
        if (this.channelStatuses == null) {
            return (A)((Object)this);
        }
        Iterator<SequenceChannelStatusBuilder> each = this.channelStatuses.iterator();
        List visitables = this._visitables.get((Object)"channelStatuses");
        while (each.hasNext()) {
            SequenceChannelStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SequenceChannelStatus> buildChannelStatuses() {
        return this.channelStatuses != null ? SequenceStatusFluent.build(this.channelStatuses) : null;
    }

    public SequenceChannelStatus buildChannelStatus(int index) {
        return this.channelStatuses.get(index).build();
    }

    public SequenceChannelStatus buildFirstChannelStatus() {
        return this.channelStatuses.get(0).build();
    }

    public SequenceChannelStatus buildLastChannelStatus() {
        return this.channelStatuses.get(this.channelStatuses.size() - 1).build();
    }

    public SequenceChannelStatus buildMatchingChannelStatus(Predicate<SequenceChannelStatusBuilder> predicate) {
        for (SequenceChannelStatusBuilder item : this.channelStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingChannelStatus(Predicate<SequenceChannelStatusBuilder> predicate) {
        for (SequenceChannelStatusBuilder item : this.channelStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withChannelStatuses(List<SequenceChannelStatus> channelStatuses) {
        if (this.channelStatuses != null) {
            this._visitables.get((Object)"channelStatuses").clear();
        }
        if (channelStatuses != null) {
            this.channelStatuses = new ArrayList();
            for (SequenceChannelStatus item : channelStatuses) {
                this.addToChannelStatuses(item);
            }
        } else {
            this.channelStatuses = null;
        }
        return (A)((Object)this);
    }

    public A withChannelStatuses(SequenceChannelStatus ... channelStatuses) {
        if (this.channelStatuses != null) {
            this.channelStatuses.clear();
            this._visitables.remove((Object)"channelStatuses");
        }
        if (channelStatuses != null) {
            for (SequenceChannelStatus item : channelStatuses) {
                this.addToChannelStatuses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasChannelStatuses() {
        return this.channelStatuses != null && !this.channelStatuses.isEmpty();
    }

    public ChannelStatusesNested<A> addNewChannelStatus() {
        return new ChannelStatusesNested(-1, null);
    }

    public ChannelStatusesNested<A> addNewChannelStatusLike(SequenceChannelStatus item) {
        return new ChannelStatusesNested(-1, item);
    }

    public ChannelStatusesNested<A> setNewChannelStatusLike(int index, SequenceChannelStatus item) {
        return new ChannelStatusesNested(index, item);
    }

    public ChannelStatusesNested<A> editChannelStatus(int index) {
        if (this.channelStatuses.size() <= index) {
            throw new RuntimeException("Can't edit channelStatuses. Index exceeds size.");
        }
        return this.setNewChannelStatusLike(index, this.buildChannelStatus(index));
    }

    public ChannelStatusesNested<A> editFirstChannelStatus() {
        if (this.channelStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first channelStatuses. The list is empty.");
        }
        return this.setNewChannelStatusLike(0, this.buildChannelStatus(0));
    }

    public ChannelStatusesNested<A> editLastChannelStatus() {
        int index = this.channelStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last channelStatuses. The list is empty.");
        }
        return this.setNewChannelStatusLike(index, this.buildChannelStatus(index));
    }

    public ChannelStatusesNested<A> editMatchingChannelStatus(Predicate<SequenceChannelStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.channelStatuses.size(); ++i) {
            if (!predicate.test(this.channelStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching channelStatuses. No match found.");
        }
        return this.setNewChannelStatusLike(index, this.buildChannelStatus(index));
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? SequenceStatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToSubscriptionStatuses(int index, SequenceSubscriptionStatus item) {
        if (this.subscriptionStatuses == null) {
            this.subscriptionStatuses = new ArrayList();
        }
        SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);
        if (index < 0 || index >= this.subscriptionStatuses.size()) {
            this._visitables.get((Object)"subscriptionStatuses").add(builder);
            this.subscriptionStatuses.add(builder);
        } else {
            this._visitables.get((Object)"subscriptionStatuses").add(index, builder);
            this.subscriptionStatuses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSubscriptionStatuses(int index, SequenceSubscriptionStatus item) {
        if (this.subscriptionStatuses == null) {
            this.subscriptionStatuses = new ArrayList();
        }
        SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);
        if (index < 0 || index >= this.subscriptionStatuses.size()) {
            this._visitables.get((Object)"subscriptionStatuses").add(builder);
            this.subscriptionStatuses.add(builder);
        } else {
            this._visitables.get((Object)"subscriptionStatuses").set(index, builder);
            this.subscriptionStatuses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSubscriptionStatuses(SequenceSubscriptionStatus ... items) {
        if (this.subscriptionStatuses == null) {
            this.subscriptionStatuses = new ArrayList();
        }
        for (SequenceSubscriptionStatus item : items) {
            SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);
            this._visitables.get((Object)"subscriptionStatuses").add(builder);
            this.subscriptionStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSubscriptionStatuses(Collection<SequenceSubscriptionStatus> items) {
        if (this.subscriptionStatuses == null) {
            this.subscriptionStatuses = new ArrayList();
        }
        for (SequenceSubscriptionStatus item : items) {
            SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);
            this._visitables.get((Object)"subscriptionStatuses").add(builder);
            this.subscriptionStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSubscriptionStatuses(SequenceSubscriptionStatus ... items) {
        if (this.subscriptionStatuses == null) {
            return (A)((Object)this);
        }
        for (SequenceSubscriptionStatus item : items) {
            SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);
            this._visitables.get((Object)"subscriptionStatuses").remove((Object)builder);
            this.subscriptionStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubscriptionStatuses(Collection<SequenceSubscriptionStatus> items) {
        if (this.subscriptionStatuses == null) {
            return (A)((Object)this);
        }
        for (SequenceSubscriptionStatus item : items) {
            SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);
            this._visitables.get((Object)"subscriptionStatuses").remove((Object)builder);
            this.subscriptionStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSubscriptionStatuses(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
        if (this.subscriptionStatuses == null) {
            return (A)((Object)this);
        }
        Iterator<SequenceSubscriptionStatusBuilder> each = this.subscriptionStatuses.iterator();
        List visitables = this._visitables.get((Object)"subscriptionStatuses");
        while (each.hasNext()) {
            SequenceSubscriptionStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SequenceSubscriptionStatus> buildSubscriptionStatuses() {
        return this.subscriptionStatuses != null ? SequenceStatusFluent.build(this.subscriptionStatuses) : null;
    }

    public SequenceSubscriptionStatus buildSubscriptionStatus(int index) {
        return this.subscriptionStatuses.get(index).build();
    }

    public SequenceSubscriptionStatus buildFirstSubscriptionStatus() {
        return this.subscriptionStatuses.get(0).build();
    }

    public SequenceSubscriptionStatus buildLastSubscriptionStatus() {
        return this.subscriptionStatuses.get(this.subscriptionStatuses.size() - 1).build();
    }

    public SequenceSubscriptionStatus buildMatchingSubscriptionStatus(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
        for (SequenceSubscriptionStatusBuilder item : this.subscriptionStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubscriptionStatus(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
        for (SequenceSubscriptionStatusBuilder item : this.subscriptionStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubscriptionStatuses(List<SequenceSubscriptionStatus> subscriptionStatuses) {
        if (this.subscriptionStatuses != null) {
            this._visitables.get((Object)"subscriptionStatuses").clear();
        }
        if (subscriptionStatuses != null) {
            this.subscriptionStatuses = new ArrayList();
            for (SequenceSubscriptionStatus item : subscriptionStatuses) {
                this.addToSubscriptionStatuses(item);
            }
        } else {
            this.subscriptionStatuses = null;
        }
        return (A)((Object)this);
    }

    public A withSubscriptionStatuses(SequenceSubscriptionStatus ... subscriptionStatuses) {
        if (this.subscriptionStatuses != null) {
            this.subscriptionStatuses.clear();
            this._visitables.remove((Object)"subscriptionStatuses");
        }
        if (subscriptionStatuses != null) {
            for (SequenceSubscriptionStatus item : subscriptionStatuses) {
                this.addToSubscriptionStatuses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSubscriptionStatuses() {
        return this.subscriptionStatuses != null && !this.subscriptionStatuses.isEmpty();
    }

    public SubscriptionStatusesNested<A> addNewSubscriptionStatus() {
        return new SubscriptionStatusesNested(-1, null);
    }

    public SubscriptionStatusesNested<A> addNewSubscriptionStatusLike(SequenceSubscriptionStatus item) {
        return new SubscriptionStatusesNested(-1, item);
    }

    public SubscriptionStatusesNested<A> setNewSubscriptionStatusLike(int index, SequenceSubscriptionStatus item) {
        return new SubscriptionStatusesNested(index, item);
    }

    public SubscriptionStatusesNested<A> editSubscriptionStatus(int index) {
        if (this.subscriptionStatuses.size() <= index) {
            throw new RuntimeException("Can't edit subscriptionStatuses. Index exceeds size.");
        }
        return this.setNewSubscriptionStatusLike(index, this.buildSubscriptionStatus(index));
    }

    public SubscriptionStatusesNested<A> editFirstSubscriptionStatus() {
        if (this.subscriptionStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first subscriptionStatuses. The list is empty.");
        }
        return this.setNewSubscriptionStatusLike(0, this.buildSubscriptionStatus(0));
    }

    public SubscriptionStatusesNested<A> editLastSubscriptionStatus() {
        int index = this.subscriptionStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subscriptionStatuses. The list is empty.");
        }
        return this.setNewSubscriptionStatusLike(index, this.buildSubscriptionStatus(index));
    }

    public SubscriptionStatusesNested<A> editMatchingSubscriptionStatus(Predicate<SequenceSubscriptionStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subscriptionStatuses.size(); ++i) {
            if (!predicate.test(this.subscriptionStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subscriptionStatuses. No match found.");
        }
        return this.setNewSubscriptionStatusLike(index, this.buildSubscriptionStatus(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SequenceStatusFluent that = (SequenceStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.address, (Object)that.address)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals((Object)this.auth, (Object)that.auth)) {
            return false;
        }
        if (!Objects.equals(this.channelStatuses, that.channelStatuses)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.subscriptionStatuses, that.subscriptionStatuses)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.annotations, this.auth, this.channelStatuses, this.conditions, this.observedGeneration, this.subscriptionStatuses, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append((Object)((Object)this.address) + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.auth != null) {
            sb.append("auth:");
            sb.append((Object)((Object)this.auth) + ",");
        }
        if (this.channelStatuses != null && !this.channelStatuses.isEmpty()) {
            sb.append("channelStatuses:");
            sb.append(this.channelStatuses + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.subscriptionStatuses != null && !this.subscriptionStatuses.isEmpty()) {
            sb.append("subscriptionStatuses:");
            sb.append(this.subscriptionStatuses + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubscriptionStatusesNested<N>
    extends SequenceSubscriptionStatusFluent<SubscriptionStatusesNested<N>>
    implements Nested<N> {
        SequenceSubscriptionStatusBuilder builder;
        int index;

        SubscriptionStatusesNested(int index, SequenceSubscriptionStatus item) {
            this.index = index;
            this.builder = new SequenceSubscriptionStatusBuilder(this, item);
        }

        public N and() {
            return (N)SequenceStatusFluent.this.setToSubscriptionStatuses(this.index, this.builder.build());
        }

        public N endSubscriptionStatus() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)SequenceStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class ChannelStatusesNested<N>
    extends SequenceChannelStatusFluent<ChannelStatusesNested<N>>
    implements Nested<N> {
        SequenceChannelStatusBuilder builder;
        int index;

        ChannelStatusesNested(int index, SequenceChannelStatus item) {
            this.index = index;
            this.builder = new SequenceChannelStatusBuilder(this, item);
        }

        public N and() {
            return (N)SequenceStatusFluent.this.setToChannelStatuses(this.index, this.builder.build());
        }

        public N endChannelStatus() {
            return this.and();
        }
    }

    public class AuthNested<N>
    extends AuthStatusFluent<AuthNested<N>>
    implements Nested<N> {
        AuthStatusBuilder builder;

        AuthNested(AuthStatus item) {
            this.builder = new AuthStatusBuilder(this, item);
        }

        public N and() {
            return (N)SequenceStatusFluent.this.withAuth(this.builder.build());
        }

        public N endAuth() {
            return this.and();
        }
    }

    public class AddressNested<N>
    extends AddressableFluent<AddressNested<N>>
    implements Nested<N> {
        AddressableBuilder builder;

        AddressNested(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        public N and() {
            return (N)SequenceStatusFluent.this.withAddress(this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

