/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.flows.v1;

import io.fabric8.knative.flows.v1.ParallelBranchStatus;
import io.fabric8.knative.flows.v1.ParallelBranchStatusBuilder;
import io.fabric8.knative.flows.v1.ParallelBranchStatusFluentImpl;
import io.fabric8.knative.flows.v1.ParallelChannelStatus;
import io.fabric8.knative.flows.v1.ParallelChannelStatusBuilder;
import io.fabric8.knative.flows.v1.ParallelChannelStatusFluentImpl;
import io.fabric8.knative.flows.v1.ParallelStatus;
import io.fabric8.knative.flows.v1.ParallelStatusFluent;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ParallelStatusFluentImpl<A extends ParallelStatusFluent<A>>
extends BaseFluent<A>
implements ParallelStatusFluent<A> {
    private AddressableBuilder address;
    private Map<String, String> annotations;
    private ArrayList<ParallelBranchStatusBuilder> branchStatuses = new ArrayList();
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private ParallelChannelStatusBuilder ingressChannelStatus;
    private Long observedGeneration;

    public ParallelStatusFluentImpl() {
    }

    public ParallelStatusFluentImpl(ParallelStatus instance) {
        this.withAddress(instance.getAddress());
        this.withAnnotations(instance.getAnnotations());
        this.withBranchStatuses(instance.getBranchStatuses());
        this.withConditions(instance.getConditions());
        this.withIngressChannelStatus(instance.getIngressChannelStatus());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    @Deprecated
    public Addressable getAddress() {
        return this.address != null ? this.address.build() : null;
    }

    @Override
    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    @Override
    public A withAddress(Addressable address) {
        this._visitables.get((Object)"address").remove(this.address);
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public A withNewAddress(String url) {
        return this.withAddress(new Addressable(url));
    }

    @Override
    public ParallelStatusFluent.AddressNested<A> withNewAddress() {
        return new AddressNestedImpl();
    }

    @Override
    public ParallelStatusFluent.AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNestedImpl(item);
    }

    @Override
    public ParallelStatusFluent.AddressNested<A> editAddress() {
        return this.withNewAddressLike(this.getAddress());
    }

    @Override
    public ParallelStatusFluent.AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(this.getAddress() != null ? this.getAddress() : new AddressableBuilder().build());
    }

    @Override
    public ParallelStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(this.getAddress() != null ? this.getAddress() : item);
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public A addToBranchStatuses(Integer index, ParallelBranchStatus item) {
        if (this.branchStatuses == null) {
            this.branchStatuses = new ArrayList();
        }
        ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
        this._visitables.get((Object)"branchStatuses").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"branchStatuses").size(), builder);
        this.branchStatuses.add(index >= 0 ? index.intValue() : this.branchStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToBranchStatuses(Integer index, ParallelBranchStatus item) {
        if (this.branchStatuses == null) {
            this.branchStatuses = new ArrayList();
        }
        ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"branchStatuses").size()) {
            this._visitables.get((Object)"branchStatuses").add(builder);
        } else {
            this._visitables.get((Object)"branchStatuses").set(index, builder);
        }
        if (index < 0 || index >= this.branchStatuses.size()) {
            this.branchStatuses.add(builder);
        } else {
            this.branchStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToBranchStatuses(ParallelBranchStatus ... items) {
        if (this.branchStatuses == null) {
            this.branchStatuses = new ArrayList();
        }
        for (ParallelBranchStatus item : items) {
            ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
            this._visitables.get((Object)"branchStatuses").add(builder);
            this.branchStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToBranchStatuses(Collection<ParallelBranchStatus> items) {
        if (this.branchStatuses == null) {
            this.branchStatuses = new ArrayList();
        }
        for (ParallelBranchStatus item : items) {
            ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
            this._visitables.get((Object)"branchStatuses").add(builder);
            this.branchStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromBranchStatuses(ParallelBranchStatus ... items) {
        for (ParallelBranchStatus item : items) {
            ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
            this._visitables.get((Object)"branchStatuses").remove(builder);
            if (this.branchStatuses == null) continue;
            this.branchStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBranchStatuses(Collection<ParallelBranchStatus> items) {
        for (ParallelBranchStatus item : items) {
            ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
            this._visitables.get((Object)"branchStatuses").remove(builder);
            if (this.branchStatuses == null) continue;
            this.branchStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromBranchStatuses(Predicate<ParallelBranchStatusBuilder> predicate) {
        if (this.branchStatuses == null) {
            return (A)this;
        }
        Iterator<ParallelBranchStatusBuilder> each = this.branchStatuses.iterator();
        List visitables = this._visitables.get((Object)"branchStatuses");
        while (each.hasNext()) {
            ParallelBranchStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ParallelBranchStatus> getBranchStatuses() {
        return this.branchStatuses != null ? ParallelStatusFluentImpl.build(this.branchStatuses) : null;
    }

    @Override
    public List<ParallelBranchStatus> buildBranchStatuses() {
        return this.branchStatuses != null ? ParallelStatusFluentImpl.build(this.branchStatuses) : null;
    }

    @Override
    public ParallelBranchStatus buildBranchStatus(Integer index) {
        return this.branchStatuses.get(index).build();
    }

    @Override
    public ParallelBranchStatus buildFirstBranchStatus() {
        return this.branchStatuses.get(0).build();
    }

    @Override
    public ParallelBranchStatus buildLastBranchStatus() {
        return this.branchStatuses.get(this.branchStatuses.size() - 1).build();
    }

    @Override
    public ParallelBranchStatus buildMatchingBranchStatus(Predicate<ParallelBranchStatusBuilder> predicate) {
        for (ParallelBranchStatusBuilder item : this.branchStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBranchStatus(Predicate<ParallelBranchStatusBuilder> predicate) {
        for (ParallelBranchStatusBuilder item : this.branchStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBranchStatuses(List<ParallelBranchStatus> branchStatuses) {
        if (this.branchStatuses != null) {
            this._visitables.get((Object)"branchStatuses").removeAll(this.branchStatuses);
        }
        if (branchStatuses != null) {
            this.branchStatuses = new ArrayList();
            for (ParallelBranchStatus item : branchStatuses) {
                this.addToBranchStatuses(item);
            }
        } else {
            this.branchStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withBranchStatuses(ParallelBranchStatus ... branchStatuses) {
        if (this.branchStatuses != null) {
            this.branchStatuses.clear();
        }
        if (branchStatuses != null) {
            for (ParallelBranchStatus item : branchStatuses) {
                this.addToBranchStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBranchStatuses() {
        return this.branchStatuses != null && !this.branchStatuses.isEmpty();
    }

    @Override
    public ParallelStatusFluent.BranchStatusesNested<A> addNewBranchStatus() {
        return new BranchStatusesNestedImpl();
    }

    @Override
    public ParallelStatusFluent.BranchStatusesNested<A> addNewBranchStatusLike(ParallelBranchStatus item) {
        return new BranchStatusesNestedImpl(-1, item);
    }

    @Override
    public ParallelStatusFluent.BranchStatusesNested<A> setNewBranchStatusLike(Integer index, ParallelBranchStatus item) {
        return new BranchStatusesNestedImpl(index, item);
    }

    @Override
    public ParallelStatusFluent.BranchStatusesNested<A> editBranchStatus(Integer index) {
        if (this.branchStatuses.size() <= index) {
            throw new RuntimeException("Can't edit branchStatuses. Index exceeds size.");
        }
        return this.setNewBranchStatusLike(index, this.buildBranchStatus(index));
    }

    @Override
    public ParallelStatusFluent.BranchStatusesNested<A> editFirstBranchStatus() {
        if (this.branchStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first branchStatuses. The list is empty.");
        }
        return this.setNewBranchStatusLike(0, this.buildBranchStatus(0));
    }

    @Override
    public ParallelStatusFluent.BranchStatusesNested<A> editLastBranchStatus() {
        int index = this.branchStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last branchStatuses. The list is empty.");
        }
        return this.setNewBranchStatusLike(index, this.buildBranchStatus(index));
    }

    @Override
    public ParallelStatusFluent.BranchStatusesNested<A> editMatchingBranchStatus(Predicate<ParallelBranchStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.branchStatuses.size(); ++i) {
            if (!predicate.test(this.branchStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching branchStatuses. No match found.");
        }
        return this.setNewBranchStatusLike(index, this.buildBranchStatus(index));
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        this._visitables.get((Object)"conditions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"conditions").size()) {
            this._visitables.get((Object)"conditions").add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Condition> getConditions() {
        return this.conditions != null ? ParallelStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<Condition> buildConditions() {
        return this.conditions != null ? ParallelStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public Condition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public ParallelStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ParallelStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ParallelStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ParallelStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ParallelStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ParallelStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ParallelStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public ParallelChannelStatus getIngressChannelStatus() {
        return this.ingressChannelStatus != null ? this.ingressChannelStatus.build() : null;
    }

    @Override
    public ParallelChannelStatus buildIngressChannelStatus() {
        return this.ingressChannelStatus != null ? this.ingressChannelStatus.build() : null;
    }

    @Override
    public A withIngressChannelStatus(ParallelChannelStatus ingressChannelStatus) {
        this._visitables.get((Object)"ingressChannelStatus").remove(this.ingressChannelStatus);
        if (ingressChannelStatus != null) {
            this.ingressChannelStatus = new ParallelChannelStatusBuilder(ingressChannelStatus);
            this._visitables.get((Object)"ingressChannelStatus").add(this.ingressChannelStatus);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngressChannelStatus() {
        return this.ingressChannelStatus != null;
    }

    @Override
    public ParallelStatusFluent.IngressChannelStatusNested<A> withNewIngressChannelStatus() {
        return new IngressChannelStatusNestedImpl();
    }

    @Override
    public ParallelStatusFluent.IngressChannelStatusNested<A> withNewIngressChannelStatusLike(ParallelChannelStatus item) {
        return new IngressChannelStatusNestedImpl(item);
    }

    @Override
    public ParallelStatusFluent.IngressChannelStatusNested<A> editIngressChannelStatus() {
        return this.withNewIngressChannelStatusLike(this.getIngressChannelStatus());
    }

    @Override
    public ParallelStatusFluent.IngressChannelStatusNested<A> editOrNewIngressChannelStatus() {
        return this.withNewIngressChannelStatusLike(this.getIngressChannelStatus() != null ? this.getIngressChannelStatus() : new ParallelChannelStatusBuilder().build());
    }

    @Override
    public ParallelStatusFluent.IngressChannelStatusNested<A> editOrNewIngressChannelStatusLike(ParallelChannelStatus item) {
        return this.withNewIngressChannelStatusLike(this.getIngressChannelStatus() != null ? this.getIngressChannelStatus() : item);
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParallelStatusFluentImpl that = (ParallelStatusFluentImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.branchStatuses != null ? !this.branchStatuses.equals(that.branchStatuses) : that.branchStatuses != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.ingressChannelStatus != null ? !this.ingressChannelStatus.equals(that.ingressChannelStatus) : that.ingressChannelStatus != null) {
            return false;
        }
        return !(this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.annotations, this.branchStatuses, this.conditions, this.ingressChannelStatus, this.observedGeneration, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.branchStatuses != null && !this.branchStatuses.isEmpty()) {
            sb.append("branchStatuses:");
            sb.append(this.branchStatuses + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.ingressChannelStatus != null) {
            sb.append("ingressChannelStatus:");
            sb.append(this.ingressChannelStatus + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
        }
        sb.append("}");
        return sb.toString();
    }

    class IngressChannelStatusNestedImpl<N>
    extends ParallelChannelStatusFluentImpl<ParallelStatusFluent.IngressChannelStatusNested<N>>
    implements ParallelStatusFluent.IngressChannelStatusNested<N>,
    Nested<N> {
        ParallelChannelStatusBuilder builder;

        IngressChannelStatusNestedImpl(ParallelChannelStatus item) {
            this.builder = new ParallelChannelStatusBuilder(this, item);
        }

        IngressChannelStatusNestedImpl() {
            this.builder = new ParallelChannelStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ParallelStatusFluentImpl.this.withIngressChannelStatus(this.builder.build());
        }

        @Override
        public N endIngressChannelStatus() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends ConditionFluentImpl<ParallelStatusFluent.ConditionsNested<N>>
    implements ParallelStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ParallelStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    class BranchStatusesNestedImpl<N>
    extends ParallelBranchStatusFluentImpl<ParallelStatusFluent.BranchStatusesNested<N>>
    implements ParallelStatusFluent.BranchStatusesNested<N>,
    Nested<N> {
        ParallelBranchStatusBuilder builder;
        Integer index;

        BranchStatusesNestedImpl(Integer index, ParallelBranchStatus item) {
            this.index = index;
            this.builder = new ParallelBranchStatusBuilder(this, item);
        }

        BranchStatusesNestedImpl() {
            this.index = -1;
            this.builder = new ParallelBranchStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ParallelStatusFluentImpl.this.setToBranchStatuses(this.index, this.builder.build());
        }

        @Override
        public N endBranchStatus() {
            return this.and();
        }
    }

    class AddressNestedImpl<N>
    extends AddressableFluentImpl<ParallelStatusFluent.AddressNested<N>>
    implements ParallelStatusFluent.AddressNested<N>,
    Nested<N> {
        AddressableBuilder builder;

        AddressNestedImpl(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        AddressNestedImpl() {
            this.builder = new AddressableBuilder(this);
        }

        @Override
        public N and() {
            return (N)ParallelStatusFluentImpl.this.withAddress(this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

