/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.serving.v1.ContainerStatus;
import io.fabric8.knative.serving.v1.ContainerStatusFluent;
import io.fabric8.knative.serving.v1.ContainerStatusFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class ContainerStatusBuilder
extends ContainerStatusFluentImpl<ContainerStatusBuilder>
implements VisitableBuilder<ContainerStatus, ContainerStatusBuilder> {
    ContainerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStatusBuilder() {
        this(false);
    }

    public ContainerStatusBuilder(Boolean validationEnabled) {
        this(new ContainerStatus(), validationEnabled);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerStatus(), validationEnabled);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, ContainerStatus instance) {
        this(fluent, instance, false);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, ContainerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImageDigest(instance.getImageDigest());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public ContainerStatusBuilder(ContainerStatus instance) {
        this(instance, (Boolean)false);
    }

    public ContainerStatusBuilder(ContainerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImageDigest(instance.getImageDigest());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public ContainerStatus build() {
        ContainerStatus buildable = new ContainerStatus(this.fluent.getImageDigest(), this.fluent.getName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStatusBuilder that = (ContainerStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

