/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1beta1;

import io.fabric8.knative.serving.v1beta1.RevisionSpec;
import io.fabric8.knative.serving.v1beta1.RevisionSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RevisionSpecFluentImpl<A extends RevisionSpecFluent<A>>
extends BaseFluent<A>
implements RevisionSpecFluent<A> {
    private Long containerConcurrency;
    private List<Container> containers;
    private String serviceAccountName;
    private Long timeoutSeconds;
    private List<Volume> volumes;

    public RevisionSpecFluentImpl() {
    }

    public RevisionSpecFluentImpl(RevisionSpec instance) {
        this.withContainerConcurrency(instance.getContainerConcurrency());
        this.withContainers(instance.getContainers());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Long getContainerConcurrency() {
        return this.containerConcurrency;
    }

    @Override
    public A withContainerConcurrency(Long containerConcurrency) {
        this.containerConcurrency = containerConcurrency;
        return (A)this;
    }

    @Override
    public Boolean hasContainerConcurrency() {
        return this.containerConcurrency != null;
    }

    @Override
    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        this.containers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        this.containers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.containers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.containers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            if (this.containers == null) continue;
            this.containers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {
            if (this.containers == null) continue;
            this.containers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Container> getContainers() {
        return this.containers;
    }

    @Override
    public Container getContainer(int index) {
        return this.containers.get(index);
    }

    @Override
    public Container getFirstContainer() {
        return this.containers.get(0);
    }

    @Override
    public Container getLastContainer() {
        return this.containers.get(this.containers.size() - 1);
    }

    @Override
    public Container getMatchingContainer(Predicate<Container> predicate) {
        for (Container item : this.containers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<Container> predicate) {
        for (Container item : this.containers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get((Object)"containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList<Container>();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = new ArrayList<Container>();
        }
        return (A)this;
    }

    @Override
    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    public A withNewServiceAccountName(String arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public A withNewServiceAccountName(StringBuilder arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public A withNewServiceAccountName(StringBuffer arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public Long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public A withTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Volume> getVolumes() {
        return this.volumes;
    }

    @Override
    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public Volume getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public Volume getMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<Volume>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = new ArrayList<Volume>();
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RevisionSpecFluentImpl that = (RevisionSpecFluentImpl)o;
        if (this.containerConcurrency != null ? !this.containerConcurrency.equals(that.containerConcurrency) : that.containerConcurrency != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.timeoutSeconds != null ? !this.timeoutSeconds.equals(that.timeoutSeconds) : that.timeoutSeconds != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }
}

