/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.serving.v1.RevisionTemplateSpec;
import io.fabric8.knative.serving.v1.RevisionTemplateSpecBuilder;
import io.fabric8.knative.serving.v1.RevisionTemplateSpecFluentImpl;
import io.fabric8.knative.serving.v1.ServiceSpec;
import io.fabric8.knative.serving.v1.ServiceSpecFluent;
import io.fabric8.knative.serving.v1.TrafficTarget;
import io.fabric8.knative.serving.v1.TrafficTargetBuilder;
import io.fabric8.knative.serving.v1.TrafficTargetFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ServiceSpecFluentImpl<A extends ServiceSpecFluent<A>>
extends BaseFluent<A>
implements ServiceSpecFluent<A> {
    private RevisionTemplateSpecBuilder template;
    private List<TrafficTargetBuilder> traffic;

    public ServiceSpecFluentImpl() {
    }

    public ServiceSpecFluentImpl(ServiceSpec instance) {
        this.withTemplate(instance.getTemplate());
        this.withTraffic(instance.getTraffic());
    }

    @Override
    @Deprecated
    public RevisionTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public RevisionTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(RevisionTemplateSpec template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new RevisionTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public ServiceSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public ServiceSpecFluent.TemplateNested<A> withNewTemplateLike(RevisionTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public ServiceSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public ServiceSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new RevisionTemplateSpecBuilder().build());
    }

    @Override
    public ServiceSpecFluent.TemplateNested<A> editOrNewTemplateLike(RevisionTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public A addToTraffic(int index, TrafficTarget item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList<TrafficTargetBuilder>();
        }
        TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
        this._visitables.get((Object)"traffic").add(index >= 0 ? index : this._visitables.get((Object)"traffic").size(), builder);
        this.traffic.add(index >= 0 ? index : this.traffic.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTraffic(int index, TrafficTarget item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList<TrafficTargetBuilder>();
        }
        TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"traffic").size()) {
            this._visitables.get((Object)"traffic").add(builder);
        } else {
            this._visitables.get((Object)"traffic").set(index, builder);
        }
        if (index < 0 || index >= this.traffic.size()) {
            this.traffic.add(builder);
        } else {
            this.traffic.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTraffic(TrafficTarget ... items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList<TrafficTargetBuilder>();
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTraffic(Collection<TrafficTarget> items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList<TrafficTargetBuilder>();
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTraffic(TrafficTarget ... items) {
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").remove(builder);
            if (this.traffic == null) continue;
            this.traffic.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTraffic(Collection<TrafficTarget> items) {
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").remove(builder);
            if (this.traffic == null) continue;
            this.traffic.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTraffic(Predicate<TrafficTargetBuilder> predicate) {
        if (this.traffic == null) {
            return (A)this;
        }
        Iterator<TrafficTargetBuilder> each = this.traffic.iterator();
        List visitables = this._visitables.get((Object)"traffic");
        while (each.hasNext()) {
            TrafficTargetBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TrafficTarget> getTraffic() {
        return ServiceSpecFluentImpl.build(this.traffic);
    }

    @Override
    public List<TrafficTarget> buildTraffic() {
        return ServiceSpecFluentImpl.build(this.traffic);
    }

    @Override
    public TrafficTarget buildTraffic(int index) {
        return this.traffic.get(index).build();
    }

    @Override
    public TrafficTarget buildFirstTraffic() {
        return this.traffic.get(0).build();
    }

    @Override
    public TrafficTarget buildLastTraffic() {
        return this.traffic.get(this.traffic.size() - 1).build();
    }

    @Override
    public TrafficTarget buildMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        for (TrafficTargetBuilder item : this.traffic) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        for (TrafficTargetBuilder item : this.traffic) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTraffic(List<TrafficTarget> traffic) {
        if (this.traffic != null) {
            this._visitables.get((Object)"traffic").removeAll(this.traffic);
        }
        if (traffic != null) {
            this.traffic = new ArrayList<TrafficTargetBuilder>();
            for (TrafficTarget item : traffic) {
                this.addToTraffic(item);
            }
        } else {
            this.traffic = null;
        }
        return (A)this;
    }

    @Override
    public A withTraffic(TrafficTarget ... traffic) {
        if (this.traffic != null) {
            this.traffic.clear();
        }
        if (traffic != null) {
            for (TrafficTarget item : traffic) {
                this.addToTraffic(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTraffic() {
        return this.traffic != null && !this.traffic.isEmpty();
    }

    @Override
    public ServiceSpecFluent.TrafficNested<A> addNewTraffic() {
        return new TrafficNestedImpl();
    }

    @Override
    public ServiceSpecFluent.TrafficNested<A> addNewTrafficLike(TrafficTarget item) {
        return new TrafficNestedImpl(-1, item);
    }

    @Override
    public ServiceSpecFluent.TrafficNested<A> setNewTrafficLike(int index, TrafficTarget item) {
        return new TrafficNestedImpl(index, item);
    }

    @Override
    public ServiceSpecFluent.TrafficNested<A> editTraffic(int index) {
        if (this.traffic.size() <= index) {
            throw new RuntimeException("Can't edit traffic. Index exceeds size.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    @Override
    public ServiceSpecFluent.TrafficNested<A> editFirstTraffic() {
        if (this.traffic.size() == 0) {
            throw new RuntimeException("Can't edit first traffic. The list is empty.");
        }
        return this.setNewTrafficLike(0, this.buildTraffic(0));
    }

    @Override
    public ServiceSpecFluent.TrafficNested<A> editLastTraffic() {
        int index = this.traffic.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last traffic. The list is empty.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    @Override
    public ServiceSpecFluent.TrafficNested<A> editMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.traffic.size(); ++i) {
            if (!predicate.apply((Object)this.traffic.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching traffic. No match found.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecFluentImpl that = (ServiceSpecFluentImpl)o;
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return !(this.traffic != null ? !this.traffic.equals(that.traffic) : that.traffic != null);
    }

    public class TemplateNestedImpl<N>
    extends RevisionTemplateSpecFluentImpl<ServiceSpecFluent.TemplateNested<N>>
    implements ServiceSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final RevisionTemplateSpecBuilder builder;

        TemplateNestedImpl(RevisionTemplateSpec item) {
            this.builder = new RevisionTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new RevisionTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class TrafficNestedImpl<N>
    extends TrafficTargetFluentImpl<ServiceSpecFluent.TrafficNested<N>>
    implements ServiceSpecFluent.TrafficNested<N>,
    Nested<N> {
        private final TrafficTargetBuilder builder;
        private final int index;

        TrafficNestedImpl(int index, TrafficTarget item) {
            this.index = index;
            this.builder = new TrafficTargetBuilder(this, item);
        }

        TrafficNestedImpl() {
            this.index = -1;
            this.builder = new TrafficTargetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluentImpl.this.setToTraffic(this.index, this.builder.build());
        }

        @Override
        public N endTraffic() {
            return this.and();
        }
    }
}

