/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.client;

import io.fabric8.knative.client.DefaultKnativeClient;
import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import okhttp3.OkHttpClient;

public class KnativeExtensionAdapter
implements ExtensionAdapter<KnativeClient> {
    static final ConcurrentMap<URL, Boolean> IS_TEKTON = new ConcurrentHashMap<URL, Boolean>();
    static final ConcurrentMap<URL, Boolean> USES_TEKTON_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();

    public Class<KnativeClient> getExtensionType() {
        return KnativeClient.class;
    }

    public Boolean isAdaptable(Client client) {
        return this.isKnativeAvailable(client);
    }

    public KnativeClient adapt(Client client) {
        return new DefaultKnativeClient((OkHttpClient)client.adapt(OkHttpClient.class), client.getConfiguration());
    }

    private boolean isKnativeAvailable(Client client) {
        List paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_TEKTON.containsKey(masterUrl)) {
            return (Boolean)IS_TEKTON.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.endsWith("knative.dev") && !path.contains("knative.dev/")) continue;
                USES_TEKTON_APIGROUPS.putIfAbsent(masterUrl, true);
                IS_TEKTON.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_TEKTON.putIfAbsent(masterUrl, false);
        return false;
    }
}

