/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Array;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JolokiaHelpers {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static Object convertJolokiaToJavaType(Class<?> clazz, Object value) throws IOException {
        if (clazz.isArray()) {
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                Object[] javaArray = (Object[])Array.newInstance(clazz.getComponentType(), jsonArray.size());
                int idx = 0;
                for (Object element : jsonArray) {
                    Array.set(javaArray, idx++, JolokiaHelpers.convertJolokiaToJavaType(clazz.getComponentType(), element));
                }
                return javaArray;
            }
            return null;
        }
        if (String.class.equals(clazz)) {
            return value != null ? value.toString() : null;
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            Number number = JolokiaHelpers.asNumber(value);
            return number != null ? Byte.valueOf(number.byteValue()) : null;
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            Number number = JolokiaHelpers.asNumber(value);
            return number != null ? Short.valueOf(number.shortValue()) : null;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            Number number = JolokiaHelpers.asNumber(value);
            return number != null ? Integer.valueOf(number.intValue()) : null;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            Number number = JolokiaHelpers.asNumber(value);
            return number != null ? Long.valueOf(number.longValue()) : null;
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            Number number = JolokiaHelpers.asNumber(value);
            return number != null ? Float.valueOf(number.floatValue()) : null;
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            Number number = JolokiaHelpers.asNumber(value);
            return number != null ? Double.valueOf(number.doubleValue()) : null;
        }
        if (value instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)value;
            if (!JSONObject.class.isAssignableFrom(clazz)) {
                String json = jsonObject.toJSONString();
                return JolokiaHelpers.getObjectMapper().reader(clazz).readValue(json);
            }
        }
        return value;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        JolokiaHelpers.objectMapper = objectMapper;
    }

    protected static Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        return null;
    }
}

