/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.assertions;

import io.fabric8.jolokia.assertions.Assertions;
import io.fabric8.jolokia.assertions.JSONArrayAssert;
import io.fabric8.jolokia.assertions.JSONObjectAssert;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.BigDecimalAssert;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.ByteAssert;
import org.assertj.core.api.CharacterAssert;
import org.assertj.core.api.DateAssert;
import org.assertj.core.api.DoubleAssert;
import org.assertj.core.api.FloatAssert;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ShortAssert;
import org.assertj.core.api.StringAssert;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pResponse;

public class JolokiaAssert
extends AbstractAssert<JolokiaAssert, J4pClient> {
    private final J4pClient client;

    public JolokiaAssert(J4pClient client) {
        super((Object)client, JolokiaAssert.class);
        this.client = client;
    }

    public <T> ObjectAssert<T> attribute(String mbean, String attribute, Class<T> clazz) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return (ObjectAssert)((AbstractObjectAssert)org.assertj.core.api.Assertions.assertThat((Object)value).isNotNull()).isInstanceOf(clazz);
    }

    public ObjectAssert<?> attribute(String mbean, String attribute) throws J4pException, MalformedObjectNameException {
        Object value = this.attributeValue(mbean, attribute);
        return (ObjectAssert)org.assertj.core.api.Assertions.assertThat((Object)value);
    }

    public BigDecimalAssert bigDecimalAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertBigDecimal(value);
    }

    public BooleanAssert booleanAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertBoolean(value);
    }

    public ByteAssert byteAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertByte(value);
    }

    public CharacterAssert characterAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertCharacter(value);
    }

    public DateAssert dateAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertDate(value);
    }

    public DoubleAssert doubleAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertDouble(value);
    }

    public FloatAssert floatAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertFloat(value);
    }

    public IntegerAssert integerAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertInteger(value);
    }

    public JSONArrayAssert jsonArrayAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertJSONArray(value);
    }

    public JSONObjectAssert jsonObjectAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertJSONObject(value);
    }

    public ListAssert listAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertList(value);
    }

    public LongAssert longAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertLong(value);
    }

    public MapAssert mapAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertMap(value);
    }

    public ShortAssert shortAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertShort(value);
    }

    public StringAssert stringAttribute(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        Object value = this.attributeValue(mbean, attribute);
        return Assertions.assertString(value);
    }

    public Object attributeValue(String mbean, String attribute) throws MalformedObjectNameException, J4pException {
        ObjectName objectName = new ObjectName(mbean);
        J4pResponse results = this.client.execute((J4pRequest)new J4pReadRequest(objectName, new String[]{attribute}));
        return results.getValue();
    }

    public BigDecimalAssert bigDecimalOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertBigDecimal(value);
    }

    public BooleanAssert booleanOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertBoolean(value);
    }

    public ByteAssert byteOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertByte(value);
    }

    public CharacterAssert characterOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertCharacter(value);
    }

    public DateAssert dateOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertDate(value);
    }

    public DoubleAssert doubleOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertDouble(value);
    }

    public FloatAssert floatOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertFloat(value);
    }

    public IntegerAssert integerOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertInteger(value);
    }

    public JSONArrayAssert jsonArrayOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertJSONArray(value);
    }

    public JSONObjectAssert jsonObjectOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertJSONObject(value);
    }

    public ListAssert listOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertList(value);
    }

    public LongAssert longOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertLong(value);
    }

    public MapAssert mapOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertMap(value);
    }

    public ShortAssert shortOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertShort(value);
    }

    public StringAssert stringOperation(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        Object value = this.operationResult(mbean, operation, arguments);
        return Assertions.assertString(value);
    }

    public ObjectAssert<?> operation(String mbean, String operation, Object ... arguments) throws J4pException, MalformedObjectNameException {
        Object value = this.operationResult(mbean, operation, arguments);
        return (ObjectAssert)org.assertj.core.api.Assertions.assertThat((Object)value);
    }

    protected Object operationResult(String mbean, String operation, Object ... arguments) throws MalformedObjectNameException, J4pException {
        ObjectName objectName = new ObjectName(mbean);
        J4pResponse results = this.client.execute((J4pRequest)new J4pExecRequest(objectName, operation, arguments));
        return results.getValue();
    }
}

