/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.autoscaling.v2.CrossVersionObjectReference;
import io.fabric8.kubernetes.api.model.autoscaling.v2.CrossVersionObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.CrossVersionObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerBehavior;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerBehaviorBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerBehaviorFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricSpec;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricSpecBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class HorizontalPodAutoscalerSpecFluent<A extends HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private HorizontalPodAutoscalerBehaviorBuilder behavior;
    private Integer maxReplicas;
    private ArrayList<MetricSpecBuilder> metrics = new ArrayList();
    private Integer minReplicas;
    private CrossVersionObjectReferenceBuilder scaleTargetRef;
    private Map<String, Object> additionalProperties;

    public HorizontalPodAutoscalerSpecFluent() {
    }

    public HorizontalPodAutoscalerSpecFluent(HorizontalPodAutoscalerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HorizontalPodAutoscalerSpec instance) {
        HorizontalPodAutoscalerSpec horizontalPodAutoscalerSpec = instance = instance != null ? instance : new HorizontalPodAutoscalerSpec();
        if (instance != null) {
            this.withBehavior(instance.getBehavior());
            this.withMaxReplicas(instance.getMaxReplicas());
            this.withMetrics(instance.getMetrics());
            this.withMinReplicas(instance.getMinReplicas());
            this.withScaleTargetRef(instance.getScaleTargetRef());
            this.withBehavior(instance.getBehavior());
            this.withMaxReplicas(instance.getMaxReplicas());
            this.withMetrics(instance.getMetrics());
            this.withMinReplicas(instance.getMinReplicas());
            this.withScaleTargetRef(instance.getScaleTargetRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HorizontalPodAutoscalerBehavior buildBehavior() {
        return this.behavior != null ? this.behavior.build() : null;
    }

    public A withBehavior(HorizontalPodAutoscalerBehavior behavior) {
        this._visitables.remove(this.behavior);
        if (behavior != null) {
            this.behavior = new HorizontalPodAutoscalerBehaviorBuilder(behavior);
            this._visitables.get("behavior").add(this.behavior);
        } else {
            this.behavior = null;
            this._visitables.get("behavior").remove(this.behavior);
        }
        return (A)this;
    }

    public boolean hasBehavior() {
        return this.behavior != null;
    }

    public BehaviorNested<A> withNewBehavior() {
        return new BehaviorNested(null);
    }

    public BehaviorNested<A> withNewBehaviorLike(HorizontalPodAutoscalerBehavior item) {
        return new BehaviorNested(item);
    }

    public BehaviorNested<A> editBehavior() {
        return this.withNewBehaviorLike(Optional.ofNullable(this.buildBehavior()).orElse(null));
    }

    public BehaviorNested<A> editOrNewBehavior() {
        return this.withNewBehaviorLike(Optional.ofNullable(this.buildBehavior()).orElse(new HorizontalPodAutoscalerBehaviorBuilder().build()));
    }

    public BehaviorNested<A> editOrNewBehaviorLike(HorizontalPodAutoscalerBehavior item) {
        return this.withNewBehaviorLike(Optional.ofNullable(this.buildBehavior()).orElse(item));
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    public boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    public A addToMetrics(int index, MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        MetricSpecBuilder builder = new MetricSpecBuilder(item);
        if (index < 0 || index >= this.metrics.size()) {
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        } else {
            this._visitables.get("metrics").add(index, builder);
            this.metrics.add(index, builder);
        }
        return (A)this;
    }

    public A setToMetrics(int index, MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        MetricSpecBuilder builder = new MetricSpecBuilder(item);
        if (index < 0 || index >= this.metrics.size()) {
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        } else {
            this._visitables.get("metrics").set(index, builder);
            this.metrics.set(index, builder);
        }
        return (A)this;
    }

    public A addToMetrics(MetricSpec ... items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    public A addAllToMetrics(Collection<MetricSpec> items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    public A removeFromMetrics(MetricSpec ... items) {
        if (this.metrics == null) {
            return (A)this;
        }
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMetrics(Collection<MetricSpec> items) {
        if (this.metrics == null) {
            return (A)this;
        }
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMetrics(Predicate<MetricSpecBuilder> predicate) {
        if (this.metrics == null) {
            return (A)this;
        }
        Iterator<MetricSpecBuilder> each = this.metrics.iterator();
        Object visitables = this._visitables.get("metrics");
        while (each.hasNext()) {
            MetricSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<MetricSpec> buildMetrics() {
        return this.metrics != null ? HorizontalPodAutoscalerSpecFluent.build(this.metrics) : null;
    }

    public MetricSpec buildMetric(int index) {
        return this.metrics.get(index).build();
    }

    public MetricSpec buildFirstMetric() {
        return this.metrics.get(0).build();
    }

    public MetricSpec buildLastMetric() {
        return this.metrics.get(this.metrics.size() - 1).build();
    }

    public MetricSpec buildMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        for (MetricSpecBuilder item : this.metrics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        for (MetricSpecBuilder item : this.metrics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMetrics(List<MetricSpec> metrics) {
        if (this.metrics != null) {
            this._visitables.get("metrics").clear();
        }
        if (metrics != null) {
            this.metrics = new ArrayList();
            for (MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        } else {
            this.metrics = null;
        }
        return (A)this;
    }

    public A withMetrics(MetricSpec ... metrics) {
        if (this.metrics != null) {
            this.metrics.clear();
            this._visitables.remove("metrics");
        }
        if (metrics != null) {
            for (MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        }
        return (A)this;
    }

    public boolean hasMetrics() {
        return this.metrics != null && !this.metrics.isEmpty();
    }

    public MetricsNested<A> addNewMetric() {
        return new MetricsNested(-1, null);
    }

    public MetricsNested<A> addNewMetricLike(MetricSpec item) {
        return new MetricsNested(-1, item);
    }

    public MetricsNested<A> setNewMetricLike(int index, MetricSpec item) {
        return new MetricsNested(index, item);
    }

    public MetricsNested<A> editMetric(int index) {
        if (this.metrics.size() <= index) {
            throw new RuntimeException("Can't edit metrics. Index exceeds size.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    public MetricsNested<A> editFirstMetric() {
        if (this.metrics.size() == 0) {
            throw new RuntimeException("Can't edit first metrics. The list is empty.");
        }
        return this.setNewMetricLike(0, this.buildMetric(0));
    }

    public MetricsNested<A> editLastMetric() {
        int index = this.metrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metrics. The list is empty.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    public MetricsNested<A> editMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metrics.size(); ++i) {
            if (!predicate.test(this.metrics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metrics. No match found.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    public boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    public CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
        this._visitables.remove(this.scaleTargetRef);
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
        } else {
            this.scaleTargetRef = null;
            this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        }
        return (A)this;
    }

    public boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    public A withNewScaleTargetRef(String apiVersion, String kind, String name) {
        return this.withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNested(null);
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return new ScaleTargetRefNested(item);
    }

    public ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(null));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(new CrossVersionObjectReferenceBuilder().build()));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerSpecFluent that = (HorizontalPodAutoscalerSpecFluent)o;
        if (!Objects.equals(this.behavior, that.behavior)) {
            return false;
        }
        if (!Objects.equals(this.maxReplicas, that.maxReplicas)) {
            return false;
        }
        if (!Objects.equals(this.metrics, that.metrics)) {
            return false;
        }
        if (!Objects.equals(this.minReplicas, that.minReplicas)) {
            return false;
        }
        if (!Objects.equals(this.scaleTargetRef, that.scaleTargetRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.behavior, this.maxReplicas, this.metrics, this.minReplicas, this.scaleTargetRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.behavior != null) {
            sb.append("behavior:");
            sb.append(this.behavior + ",");
        }
        if (this.maxReplicas != null) {
            sb.append("maxReplicas:");
            sb.append(this.maxReplicas + ",");
        }
        if (this.metrics != null && !this.metrics.isEmpty()) {
            sb.append("metrics:");
            sb.append(this.metrics + ",");
        }
        if (this.minReplicas != null) {
            sb.append("minReplicas:");
            sb.append(this.minReplicas + ",");
        }
        if (this.scaleTargetRef != null) {
            sb.append("scaleTargetRef:");
            sb.append(this.scaleTargetRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ScaleTargetRefNested<N>
    extends CrossVersionObjectReferenceFluent<ScaleTargetRefNested<N>>
    implements Nested<N> {
        CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNested(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluent.this.withScaleTargetRef(this.builder.build());
        }

        public N endScaleTargetRef() {
            return this.and();
        }
    }

    public class MetricsNested<N>
    extends MetricSpecFluent<MetricsNested<N>>
    implements Nested<N> {
        MetricSpecBuilder builder;
        int index;

        MetricsNested(int index, MetricSpec item) {
            this.index = index;
            this.builder = new MetricSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluent.this.setToMetrics(this.index, this.builder.build());
        }

        public N endMetric() {
            return this.and();
        }
    }

    public class BehaviorNested<N>
    extends HorizontalPodAutoscalerBehaviorFluent<BehaviorNested<N>>
    implements Nested<N> {
        HorizontalPodAutoscalerBehaviorBuilder builder;

        BehaviorNested(HorizontalPodAutoscalerBehavior item) {
            this.builder = new HorizontalPodAutoscalerBehaviorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluent.this.withBehavior(this.builder.build());
        }

        public N endBehavior() {
            return this.and();
        }
    }
}

