/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPPathModifier;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPPathModifierBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPPathModifierFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPURLRewriteFilter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HTTPURLRewriteFilterFluent<A extends HTTPURLRewriteFilterFluent<A>>
extends BaseFluent<A> {
    private String hostname;
    private HTTPPathModifierBuilder path;
    private Map<String, Object> additionalProperties;

    public HTTPURLRewriteFilterFluent() {
    }

    public HTTPURLRewriteFilterFluent(HTTPURLRewriteFilter instance) {
        HTTPURLRewriteFilter hTTPURLRewriteFilter = instance = instance != null ? instance : new HTTPURLRewriteFilter();
        if (instance != null) {
            this.withHostname(instance.getHostname());
            this.withPath(instance.getPath());
            this.withHostname(instance.getHostname());
            this.withPath(instance.getPath());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public HTTPPathModifier buildPath() {
        return this.path != null ? this.path.build() : null;
    }

    public A withPath(HTTPPathModifier path) {
        this._visitables.get("path").remove(this.path);
        if (path != null) {
            this.path = new HTTPPathModifierBuilder(path);
            this._visitables.get("path").add(this.path);
        } else {
            this.path = null;
            this._visitables.get("path").remove(this.path);
        }
        return (A)this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(String replaceFullPath, String replacePrefixMatch, String type) {
        return this.withPath(new HTTPPathModifier(replaceFullPath, replacePrefixMatch, type));
    }

    public PathNested<A> withNewPath() {
        return new PathNested(null);
    }

    public PathNested<A> withNewPathLike(HTTPPathModifier item) {
        return new PathNested(item);
    }

    public PathNested<A> editPath() {
        return this.withNewPathLike(Optional.ofNullable(this.buildPath()).orElse(null));
    }

    public PathNested<A> editOrNewPath() {
        return this.withNewPathLike(Optional.ofNullable(this.buildPath()).orElse(new HTTPPathModifierBuilder().build()));
    }

    public PathNested<A> editOrNewPathLike(HTTPPathModifier item) {
        return this.withNewPathLike(Optional.ofNullable(this.buildPath()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPURLRewriteFilterFluent that = (HTTPURLRewriteFilterFluent)o;
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostname, this.path, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PathNested<N>
    extends HTTPPathModifierFluent<PathNested<N>>
    implements Nested<N> {
        HTTPPathModifierBuilder builder;

        PathNested(HTTPPathModifier item) {
            this.builder = new HTTPPathModifierBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPURLRewriteFilterFluent.this.withPath(this.builder.build());
        }

        public N endPath() {
            return this.and();
        }
    }
}

