/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriver;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriverBuilder;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriverFluent;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CSINodeSpecFluent<A extends CSINodeSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<CSINodeDriverBuilder> drivers = new ArrayList();
    private Map<String, Object> additionalProperties;

    public CSINodeSpecFluent() {
    }

    public CSINodeSpecFluent(CSINodeSpec instance) {
        CSINodeSpec cSINodeSpec = instance = instance != null ? instance : new CSINodeSpec();
        if (instance != null) {
            this.withDrivers(instance.getDrivers());
            this.withDrivers(instance.getDrivers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDrivers(int index, CSINodeDriver item) {
        if (this.drivers == null) {
            this.drivers = new ArrayList();
        }
        CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
        if (index < 0 || index >= this.drivers.size()) {
            this._visitables.get("drivers").add(builder);
            this.drivers.add(builder);
        } else {
            this._visitables.get("drivers").add(index, builder);
            this.drivers.add(index, builder);
        }
        return (A)this;
    }

    public A setToDrivers(int index, CSINodeDriver item) {
        if (this.drivers == null) {
            this.drivers = new ArrayList();
        }
        CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
        if (index < 0 || index >= this.drivers.size()) {
            this._visitables.get("drivers").add(builder);
            this.drivers.add(builder);
        } else {
            this._visitables.get("drivers").set(index, builder);
            this.drivers.set(index, builder);
        }
        return (A)this;
    }

    public A addToDrivers(CSINodeDriver ... items) {
        if (this.drivers == null) {
            this.drivers = new ArrayList();
        }
        for (CSINodeDriver item : items) {
            CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
            this._visitables.get("drivers").add(builder);
            this.drivers.add(builder);
        }
        return (A)this;
    }

    public A addAllToDrivers(Collection<CSINodeDriver> items) {
        if (this.drivers == null) {
            this.drivers = new ArrayList();
        }
        for (CSINodeDriver item : items) {
            CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
            this._visitables.get("drivers").add(builder);
            this.drivers.add(builder);
        }
        return (A)this;
    }

    public A removeFromDrivers(CSINodeDriver ... items) {
        if (this.drivers == null) {
            return (A)this;
        }
        for (CSINodeDriver item : items) {
            CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
            this._visitables.get("drivers").remove(builder);
            this.drivers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDrivers(Collection<CSINodeDriver> items) {
        if (this.drivers == null) {
            return (A)this;
        }
        for (CSINodeDriver item : items) {
            CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
            this._visitables.get("drivers").remove(builder);
            this.drivers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDrivers(Predicate<CSINodeDriverBuilder> predicate) {
        if (this.drivers == null) {
            return (A)this;
        }
        Iterator<CSINodeDriverBuilder> each = this.drivers.iterator();
        Object visitables = this._visitables.get("drivers");
        while (each.hasNext()) {
            CSINodeDriverBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<CSINodeDriver> buildDrivers() {
        return this.drivers != null ? CSINodeSpecFluent.build(this.drivers) : null;
    }

    public CSINodeDriver buildDriver(int index) {
        return this.drivers.get(index).build();
    }

    public CSINodeDriver buildFirstDriver() {
        return this.drivers.get(0).build();
    }

    public CSINodeDriver buildLastDriver() {
        return this.drivers.get(this.drivers.size() - 1).build();
    }

    public CSINodeDriver buildMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
        for (CSINodeDriverBuilder item : this.drivers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
        for (CSINodeDriverBuilder item : this.drivers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDrivers(List<CSINodeDriver> drivers) {
        if (this.drivers != null) {
            this._visitables.get("drivers").clear();
        }
        if (drivers != null) {
            this.drivers = new ArrayList();
            for (CSINodeDriver item : drivers) {
                this.addToDrivers(item);
            }
        } else {
            this.drivers = null;
        }
        return (A)this;
    }

    public A withDrivers(CSINodeDriver ... drivers) {
        if (this.drivers != null) {
            this.drivers.clear();
            this._visitables.remove("drivers");
        }
        if (drivers != null) {
            for (CSINodeDriver item : drivers) {
                this.addToDrivers(item);
            }
        }
        return (A)this;
    }

    public boolean hasDrivers() {
        return this.drivers != null && !this.drivers.isEmpty();
    }

    public DriversNested<A> addNewDriver() {
        return new DriversNested(-1, null);
    }

    public DriversNested<A> addNewDriverLike(CSINodeDriver item) {
        return new DriversNested(-1, item);
    }

    public DriversNested<A> setNewDriverLike(int index, CSINodeDriver item) {
        return new DriversNested(index, item);
    }

    public DriversNested<A> editDriver(int index) {
        if (this.drivers.size() <= index) {
            throw new RuntimeException("Can't edit drivers. Index exceeds size.");
        }
        return this.setNewDriverLike(index, this.buildDriver(index));
    }

    public DriversNested<A> editFirstDriver() {
        if (this.drivers.size() == 0) {
            throw new RuntimeException("Can't edit first drivers. The list is empty.");
        }
        return this.setNewDriverLike(0, this.buildDriver(0));
    }

    public DriversNested<A> editLastDriver() {
        int index = this.drivers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last drivers. The list is empty.");
        }
        return this.setNewDriverLike(index, this.buildDriver(index));
    }

    public DriversNested<A> editMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.drivers.size(); ++i) {
            if (!predicate.test(this.drivers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching drivers. No match found.");
        }
        return this.setNewDriverLike(index, this.buildDriver(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSINodeSpecFluent that = (CSINodeSpecFluent)o;
        if (!Objects.equals(this.drivers, that.drivers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.drivers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.drivers != null && !this.drivers.isEmpty()) {
            sb.append("drivers:");
            sb.append(this.drivers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DriversNested<N>
    extends CSINodeDriverFluent<DriversNested<N>>
    implements Nested<N> {
        CSINodeDriverBuilder builder;
        int index;

        DriversNested(int index, CSINodeDriver item) {
            this.index = index;
            this.builder = new CSINodeDriverBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSINodeSpecFluent.this.setToDrivers(this.index, this.builder.build());
        }

        public N endDriver() {
            return this.and();
        }
    }
}

