/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator;

import io.fabric8.java.generator.CRGeneratorRunner;
import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.JavaGenerator;
import io.fabric8.java.generator.WritableCRCompilationUnit;
import io.fabric8.java.generator.exceptions.JavaGeneratorException;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileJavaGenerator
implements JavaGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileJavaGenerator.class);
    private final File source;
    private final CRGeneratorRunner crGeneratorRunner;

    public FileJavaGenerator(Config config, File source) {
        this.crGeneratorRunner = new CRGeneratorRunner(config);
        this.source = source;
    }

    @Override
    public void run(File outputDirectory) {
        block15: {
            if (this.source.isDirectory()) {
                try (Stream<Path> walk = Files.walk(this.source.toPath(), FileVisitOption.FOLLOW_LINKS);){
                    walk.map(Path::toFile).filter(f -> !f.getAbsolutePath().equals(this.source.getAbsolutePath()) && f.isFile()).forEach(f -> this.runOnSingleSource((File)f, outputDirectory));
                    break block15;
                }
                catch (IOException e) {
                    throw new JavaGeneratorException("Error visiting the folder " + this.source.getAbsolutePath(), e);
                }
            }
            this.runOnSingleSource(this.source, outputDirectory);
        }
    }

    private void runOnSingleSource(File source, File basePath) {
        try (FileInputStream fis = new FileInputStream(source);){
            ArrayList<Object> resources = new ArrayList<Object>();
            Object deserialized = Serialization.unmarshal(fis);
            if (deserialized instanceof List) {
                resources.addAll((List)deserialized);
            } else {
                resources.add(deserialized);
            }
            this.writeCRCompilationUnits(basePath, this.generateWritableCRCompilationUnits(resources));
        }
        catch (FileNotFoundException e) {
            throw new JavaGeneratorException("File " + source.getAbsolutePath() + " not found", e);
        }
        catch (IOException e) {
            throw new JavaGeneratorException("Exception reading " + source.getAbsolutePath(), e);
        }
    }

    private List<WritableCRCompilationUnit> generateWritableCRCompilationUnits(List<Object> resources) {
        return resources.parallelStream().flatMap(rawResource -> {
            if (rawResource != null && rawResource instanceof HasMetadata) {
                HasMetadata resource = (HasMetadata)rawResource;
                if (resource != null && resource.getKind().toLowerCase(Locale.ROOT).equals("customresourcedefinition")) {
                    CustomResourceDefinition crd = (CustomResourceDefinition)resource;
                    String basePackage = CRGeneratorRunner.groupToPackage(crd.getSpec().getGroup());
                    return this.crGeneratorRunner.generate(crd, basePackage).stream();
                }
                LOGGER.warn("Not generating nothing for resource of kind: {}", (Object)resource.getKind());
            } else {
                LOGGER.warn("Not generating nothing for unrecognized resource: {}", (Object)Serialization.asYaml(rawResource));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private void writeCRCompilationUnits(File basePath, List<WritableCRCompilationUnit> wCUs) {
        int size = wCUs.size();
        CompletableFuture[] futures = new CompletableFuture[size];
        for (int i = 0; i < size; ++i) {
            WritableCRCompilationUnit w = wCUs.get(i);
            futures[i] = CompletableFuture.runAsync(() -> w.writeAllJavaClasses(basePath));
        }
        for (int j = 0; j < size; ++j) {
            futures[j].join();
        }
    }
}

