/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.WatcherWebSocketListener;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchConnectionManager<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends AbstractWatchManager<T> {
    public static final int BACKOFF_MAX_EXPONENT = 5;
    private static final Logger logger = LoggerFactory.getLogger(WatchConnectionManager.class);
    protected WatcherWebSocketListener<T> listener;
    private volatile CompletableFuture<WebSocket> websocketFuture;
    private volatile boolean ready;

    static void closeWebSocket(WebSocket webSocket) {
        if (webSocket != null) {
            logger.debug("Closing websocket {}", (Object)webSocket);
            try {
                if (!webSocket.sendClose(1000, null)) {
                    logger.debug("Websocket already closed {}", (Object)webSocket);
                }
            }
            catch (IllegalStateException e) {
                logger.error("invalid code for websocket: {} {}", (Object)e.getClass(), (Object)e.getMessage());
            }
        }
    }

    public WatchConnectionManager(HttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long websocketTimeout) throws MalformedURLException {
        super(watcher, baseOperation, listOptions, reconnectLimit, reconnectInterval, () -> client.newBuilder().readTimeout(websocketTimeout, TimeUnit.MILLISECONDS).build());
    }

    @Override
    protected void closeCurrentRequest() {
        Optional.ofNullable(this.websocketFuture).ifPresent(theFuture -> {
            this.websocketFuture = null;
            theFuture.whenComplete((w, t) -> {
                if (w != null) {
                    WatchConnectionManager.closeWebSocket(w);
                }
            });
        });
    }

    public CompletableFuture<WebSocket> getWebsocketFuture() {
        return this.websocketFuture;
    }

    @Override
    protected void start(URL url, Map<String, String> headers, AbstractWatchManager.WatchRequestState state) {
        this.listener = new WatcherWebSocketListener(this, state);
        WebSocket.Builder builder = this.client.newWebSocketBuilder();
        headers.forEach(builder::header);
        builder.uri(URI.create(url.toString()));
        this.websocketFuture = builder.buildAsync(this.listener).handle((w, t) -> {
            if (t != null) {
                if (t instanceof WebSocketHandshakeException) {
                    WebSocketHandshakeException wshe = (WebSocketHandshakeException)t;
                    WebSocketUpgradeResponse response = wshe.getResponse();
                    int code = response.code();
                    Status status = OperationSupport.createStatus(response);
                    if (200 == code || 503 == code) {
                        throw OperationSupport.requestFailure(this.client.newHttpRequestBuilder().url(url).build(), status, "Received " + code + " on websocket");
                    }
                    logger.warn("Exec Failure: HTTP {}, Status: {} - {}", code, status.getCode(), status.getMessage());
                    t = OperationSupport.requestFailure(this.client.newHttpRequestBuilder().url(url).build(), status);
                }
                if (this.ready) {
                    this.listener.onError((WebSocket)w, (Throwable)t, true);
                }
                throw KubernetesClientException.launderThrowable(t);
            }
            if (w != null) {
                this.ready = true;
            }
            return w;
        });
    }
}

