/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.kubernetes.api.model.SecretReferenceFluent;
import io.fabric8.kubernetes.api.model.SecretReferenceFluentImpl;

public class SecretReferenceBuilder
extends SecretReferenceFluentImpl<SecretReferenceBuilder>
implements VisitableBuilder<SecretReference, SecretReferenceBuilder> {
    SecretReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public SecretReferenceBuilder() {
        this(false);
    }

    public SecretReferenceBuilder(Boolean validationEnabled) {
        this(new SecretReference(), validationEnabled);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecretReference(), validationEnabled);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent, SecretReference instance) {
        this(fluent, instance, false);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent, SecretReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public SecretReferenceBuilder(SecretReference instance) {
        this(instance, (Boolean)false);
    }

    public SecretReferenceBuilder(SecretReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SecretReference build() {
        SecretReference buildable = new SecretReference(this.fluent.getName(), this.fluent.getNamespace());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

