/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.cli;

import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.FileJavaGenerator;
import io.fabric8.java.generator.JavaGenerator;
import io.fabric8.java.generator.URLJavaGenerator;
import io.fabric8.java.generator.cli.KubernetesClientVersionProvider;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import picocli.CommandLine;

@CommandLine.Command(name="java-gen", mixinStandardHelpOptions=true, helpCommand=true, versionProvider=KubernetesClientVersionProvider.class)
public class GenerateJavaSources
implements Runnable {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-s", "--source"}, description={"The source(file or folder) with the CustomResourceDefinition(s) to use"})
    File source;
    @CommandLine.Option(names={"-u", "--urls"}, description={"The source urls with the CustomResourceDefinition(s) to use"})
    String[] urls;
    @CommandLine.Option(names={"-dt", "--download-target"}, description={"The folder to be used as a target for the downloaded crds"})
    File downloadTarget;
    @CommandLine.Option(names={"-t", "--target"}, description={"The folder to write the generated sources"}, required=true)
    File target;
    @CommandLine.Option(names={"-enum-uppercase", "--enum-uppercase"}, description={"Uppercase the enum values"}, required=false)
    Boolean uppercaseEnum = null;
    @Deprecated
    @CommandLine.Option(names={"-prefix-strategy", "--prefix-strategy"}, description={"The prefix strategy to be used"}, required=false, hidden=true)
    String prefixStrategy = null;
    @Deprecated
    @CommandLine.Option(names={"-suffix-strategy", "--suffix-strategy"}, description={"The suffix strategy to be used"}, required=false, hidden=true)
    String suffixStrategy = null;
    @Deprecated
    @CommandLine.Option(names={"-always-preserve-unknown", "--always-preserve-unknown"}, description={"Always preserve unknown fields in the generated classes"}, required=false, hidden=true)
    Boolean alwaysPreserveUnkownFields = null;
    @CommandLine.Option(names={"-add-extra-annotations", "--add-extra-annotations"}, description={"Add extra lombok and sundrio annotation to the generated classes"}, required=false)
    Boolean addExtraAnnotations = null;
    @Deprecated
    @CommandLine.Option(names={"-code-structure", "--code-structure"}, description={"Generate classes using a specific layout"}, required=false, hidden=true)
    String codeStructure = null;
    @CommandLine.Option(names={"-skip-generated-annotations", "--skip-generated-annotations"}, description={"Skip emitting the @javax.annotation.processing.Generated annotation on the generated sources"}, required=false, hidden=true)
    Boolean skipGeneratedAnnotations = null;
    @CommandLine.Option(names={"-package-overrides", "--package-overrides"}, description={"Apply the overrides to the package names"}, required=false)
    Map<String, String> packageOverrides = null;

    @Override
    public void run() {
        Config.Prefix pSt = this.prefixStrategy != null ? Config.Prefix.valueOf(this.prefixStrategy) : null;
        Config.Suffix sSt = this.suffixStrategy != null ? Config.Suffix.valueOf(this.suffixStrategy) : null;
        Config.CodeStructure structure = this.codeStructure != null ? Config.CodeStructure.valueOf(this.codeStructure) : null;
        Boolean noGeneratedAnnotations = this.skipGeneratedAnnotations != null ? this.skipGeneratedAnnotations : false;
        Config config = new Config(this.uppercaseEnum, pSt, sSt, this.alwaysPreserveUnkownFields, this.addExtraAnnotations, structure, noGeneratedAnnotations == false, this.packageOverrides);
        ArrayList<JavaGenerator> runners = new ArrayList<JavaGenerator>();
        if (this.urls != null && this.urls.length > 0) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (String url : this.urls) {
                try {
                    urlList.add(new URL(url));
                }
                catch (MalformedURLException e) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "URL '" + url + "' is not valid", e);
                }
            }
            if (this.downloadTarget == null) {
                try {
                    this.downloadTarget = Files.createTempDirectory("java-gen", new FileAttribute[0]).toFile();
                }
                catch (IOException e) {
                    throw new CommandLine.ParameterException(this.spec.commandLine(), "Unable to create a temporary folder, please provide an explicit '--download-target' option", e);
                }
            }
            runners.add(new URLJavaGenerator(config, urlList, this.downloadTarget));
        }
        if (this.source != null) {
            runners.add(new FileJavaGenerator(config, this.source));
        }
        if (runners.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No source or urls specified");
        }
        runners.forEach(r -> r.run(this.target));
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine(new GenerateJavaSources()).execute(args);
        System.exit(exitCode);
    }
}

