/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.nodes;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.nodes.AbstractJSONSchema2Pojo;
import io.fabric8.java.generator.nodes.GeneratorResult;
import io.fabric8.java.generator.nodes.JObjectExtraAnnotations;
import java.util.Collections;

public class JCRObject
extends AbstractJSONSchema2Pojo
implements JObjectExtraAnnotations {
    private final String pkg;
    private final String type;
    private final String className;
    private final String group;
    private final String version;
    private final String scope;
    private final String specClassName;
    private final String statusClassName;
    private final boolean withSpec;
    private final boolean withStatus;
    private final String singular;
    private final String plural;
    private final boolean storage;
    private final boolean served;

    public JCRObject(String pkg, String type, String group, String version, String scope, String specClassName, String statusClassName, boolean withSpec, boolean withStatus, boolean storage, boolean served, String singular, String plural, Config config) {
        super(config, null, false, null, null);
        this.pkg = pkg == null ? "" : pkg.trim();
        this.type = this.pkg.isEmpty() ? type : pkg + "." + type;
        this.className = type;
        this.group = group;
        this.version = version;
        this.scope = scope;
        this.specClassName = specClassName;
        this.statusClassName = statusClassName;
        this.withSpec = withSpec;
        this.withStatus = withStatus;
        this.storage = storage;
        this.served = served;
        this.singular = singular;
        this.plural = plural;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public GeneratorResult generateJava() {
        CompilationUnit cu = new CompilationUnit();
        if (!this.pkg.isEmpty()) {
            cu.setPackageDeclaration(new PackageDeclaration(new Name(this.pkg)));
        }
        ClassOrInterfaceDeclaration clz = cu.addClass(this.className);
        clz.addAnnotation(new SingleMemberAnnotationExpr(new Name("io.fabric8.kubernetes.model.annotation.Version"), new NameExpr("value = \"" + this.version + "\" , storage = " + this.storage + " , served = " + this.served)));
        clz.addAnnotation(new SingleMemberAnnotationExpr(new Name("io.fabric8.kubernetes.model.annotation.Group"), new StringLiteralExpr(this.group)));
        if (this.singular != null) {
            clz.addAnnotation(new SingleMemberAnnotationExpr(new Name("io.fabric8.kubernetes.model.annotation.Singular"), new StringLiteralExpr(this.singular)));
        }
        if (this.plural != null) {
            clz.addAnnotation(new SingleMemberAnnotationExpr(new Name("io.fabric8.kubernetes.model.annotation.Plural"), new StringLiteralExpr(this.plural)));
        }
        ClassOrInterfaceType jlVoid = (ClassOrInterfaceType)new ClassOrInterfaceType().setName("java.lang.Void");
        ClassOrInterfaceType spec = this.withSpec ? (ClassOrInterfaceType)new ClassOrInterfaceType().setName(this.pkg + "." + this.specClassName) : jlVoid;
        ClassOrInterfaceType status = this.withStatus ? (ClassOrInterfaceType)new ClassOrInterfaceType().setName(this.pkg + "." + this.statusClassName) : jlVoid;
        ClassOrInterfaceType crType = (ClassOrInterfaceType)((ClassOrInterfaceType)new ClassOrInterfaceType().setName("io.fabric8.kubernetes.client.CustomResource")).setTypeArguments(spec, status);
        clz.addExtendedType(crType);
        if (this.scope.equals("Namespaced")) {
            clz.addImplementedType("io.fabric8.kubernetes.api.model.Namespaced");
        }
        if (this.config.isGeneratedAnnotations()) {
            clz.addAnnotation(JCRObject.newGeneratedAnnotation());
        }
        if (this.config.isObjectExtraAnnotations()) {
            this.addExtraAnnotations(clz);
        }
        return new GeneratorResult(Collections.singletonList(new GeneratorResult.ClassResult(this.className, cu)));
    }
}

