/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.utils.AsyncUtils;
import io.fabric8.kubernetes.client.utils.ExponentialBackoffIntervalCalculator;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardHttpClient<C extends HttpClient, F extends HttpClient.Factory, T extends StandardHttpClientBuilder<C, F, ?>>
implements HttpClient,
Interceptor.RequestTags {
    private static final long MAX_ADDITIONAL_REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final Logger LOG = LoggerFactory.getLogger(StandardHttpClient.class);
    protected StandardHttpClientBuilder<C, F, T> builder;
    protected AtomicBoolean closed;

    protected StandardHttpClient(StandardHttpClientBuilder<C, F, T> builder, AtomicBoolean closed) {
        this.builder = builder;
        this.closed = closed;
    }

    public abstract CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder var1, WebSocket.Listener var2);

    public abstract CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest var1, AsyncBody.Consumer<List<ByteBuffer>> var2);

    @Override
    public HttpClient.DerivedClientBuilder newBuilder() {
        return this.builder.copy(this);
    }

    public <V> CompletableFuture<HttpResponse<V>> sendAsync(HttpRequest request, Class<V> type) {
        CompletableFuture upstream = HttpResponse.SupportedResponses.from(type).sendAsync(request, this);
        CompletableFuture<HttpResponse<V>> result = new CompletableFuture<HttpResponse<V>>();
        upstream.whenComplete(StandardHttpClient.completeOrCancel(r -> {
            if (r.body() instanceof Closeable) {
                Utils.closeQuietly((Closeable)r.body());
            }
        }, result));
        return result;
    }

    @Override
    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytes(HttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        StandardHttpRequest standardHttpRequest = (StandardHttpRequest)request;
        return this.retryWithExponentialBackoff(standardHttpRequest, () -> this.consumeBytesOnce(standardHttpRequest, consumer), r -> ((AsyncBody)r.body()).cancel(), r -> r);
    }

    private CompletableFuture<HttpResponse<AsyncBody>> consumeBytesOnce(StandardHttpRequest standardHttpRequest, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        StandardHttpRequest.Builder copy = standardHttpRequest.newBuilder();
        for (Interceptor interceptor : this.builder.getInterceptors().values()) {
            interceptor.before(copy, standardHttpRequest, this);
            standardHttpRequest = copy.build();
        }
        StandardHttpRequest effectiveRequest = standardHttpRequest;
        for (Interceptor interceptor : this.builder.getInterceptors().values()) {
            consumer = interceptor.consumer(consumer, effectiveRequest);
        }
        AsyncBody.Consumer<List<ByteBuffer>> consumer2 = consumer;
        CompletionStage<HttpResponse<AsyncBody>> cf = this.consumeBytesDirect(effectiveRequest, consumer2);
        cf.thenAccept(response -> this.builder.getInterceptors().values().forEach(i -> i.after(effectiveRequest, (HttpResponse<?>)response, effectiveConsumer)));
        for (Interceptor interceptor : this.builder.getInterceptors().values()) {
            cf = cf.thenCompose(response -> {
                if (!HttpResponse.isSuccessful(response.code())) {
                    return interceptor.afterFailure(copy, (HttpResponse<?>)response, (Interceptor.RequestTags)this).thenCompose(b -> {
                        if (Boolean.TRUE.equals(b)) {
                            ((AsyncBody)response.body()).cancel();
                            CompletableFuture<HttpResponse<AsyncBody>> result = this.consumeBytesDirect(copy.build(), effectiveConsumer);
                            result.thenAccept(r -> this.builder.getInterceptors().values().forEach(i -> i.after(effectiveRequest, (HttpResponse<?>)r, effectiveConsumer)));
                            return result;
                        }
                        return CompletableFuture.completedFuture(response);
                    });
                }
                return CompletableFuture.completedFuture(response);
            });
        }
        return cf;
    }

    private static <V> BiConsumer<? super V, ? super Throwable> completeOrCancel(Consumer<V> cancel, CompletableFuture<V> result) {
        return (r, t) -> {
            if (t != null) {
                result.completeExceptionally((Throwable)t);
            } else if (!result.complete(r)) {
                cancel.accept(r);
            }
        };
    }

    private <V> CompletableFuture<V> retryWithExponentialBackoff(StandardHttpRequest request, Supplier<CompletableFuture<V>> action, Consumer<V> onCancel, Function<V, HttpResponse<?>> responseExtractor) {
        URI uri = request.uri();
        RequestConfig requestConfig = this.getTag((Class<V>)RequestConfig.class);
        ExponentialBackoffIntervalCalculator retryIntervalCalculator = ExponentialBackoffIntervalCalculator.from(requestConfig);
        Duration timeout = request.getTimeout() != null && !request.getTimeout().isNegative() && !request.getTimeout().isZero() ? request.getTimeout().plusMillis(Math.min(request.getTimeout().toMillis(), MAX_ADDITIONAL_REQUEST_TIMEOUT)) : null;
        return AsyncUtils.retryWithExponentialBackoff(action, onCancel, timeout, retryIntervalCalculator, (response, throwable, retryInterval) -> {
            if (response != null) {
                int code;
                HttpResponse httpResponse = (HttpResponse)responseExtractor.apply(response);
                if (httpResponse != null && ((code = httpResponse.code()) == 429 || code >= 500)) {
                    retryInterval = Math.max(StandardHttpClient.retryAfterMillis(httpResponse), retryInterval);
                    LOG.debug("HTTP operation on url: {} should be retried as the response code was {}, retrying after {} millis", uri, code, retryInterval);
                    return true;
                }
            } else {
                Throwable actualCause = StandardHttpClient.unwrapCompletionException(throwable);
                this.builder.interceptors.forEach((s, interceptor) -> interceptor.afterConnectionFailure(request, actualCause));
                if (actualCause instanceof IOException) {
                    LOG.debug(String.format("HTTP operation on url: %s should be retried after %d millis because of IOException", uri, retryInterval), actualCause);
                    return true;
                }
            }
            return false;
        });
    }

    static Throwable unwrapCompletionException(Throwable throwable) {
        Throwable actualCause = throwable instanceof CompletionException ? throwable.getCause() : throwable;
        return actualCause;
    }

    static long retryAfterMillis(HttpResponse<?> httpResponse) {
        String retryAfter = httpResponse.header("Retry-After");
        if (retryAfter != null) {
            try {
                return (long)Integer.parseInt(retryAfter) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    ZonedDateTime after = ZonedDateTime.parse(retryAfter, DateTimeFormatter.RFC_1123_DATE_TIME);
                    return after.toEpochSecond() * 1000L - System.currentTimeMillis();
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    @Override
    public WebSocket.Builder newWebSocketBuilder() {
        return new StandardWebSocketBuilder(this);
    }

    @Override
    public HttpRequest.Builder newHttpRequestBuilder() {
        return new StandardHttpRequest.Builder();
    }

    final CompletableFuture<WebSocket> buildWebSocket(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        CompletableFuture<WebSocketResponse> intermediate = this.retryWithExponentialBackoff(standardWebSocketBuilder.asHttpRequest(), () -> this.buildWebSocketOnce(standardWebSocketBuilder, listener), r -> Optional.ofNullable(r.webSocket).ifPresent(w -> w.sendClose(1000, null)), r -> r.webSocketUpgradeResponse);
        CompletableFuture<WebSocket> result = new CompletableFuture<WebSocket>();
        intermediate.whenComplete((r, t) -> {
            if (t != null) {
                result.completeExceptionally((Throwable)t);
            } else {
                StandardHttpClient.completeOrCancel(w -> w.sendClose(1000, null), result).accept(r.webSocket, r.throwable != null ? new WebSocketHandshakeException(r.webSocketUpgradeResponse).initCause(r.throwable) : null);
            }
        });
        return result;
    }

    private CompletableFuture<WebSocketResponse> buildWebSocketOnce(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        StandardWebSocketBuilder copy = standardWebSocketBuilder.newBuilder();
        this.builder.getInterceptors().values().forEach(i -> i.before(copy, copy.asHttpRequest(), this));
        CompletionStage<WebSocketResponse> cf = this.buildWebSocketDirect(copy, listener);
        cf.thenAccept(response -> this.builder.getInterceptors().values().forEach(i -> i.after(response.webSocketUpgradeResponse.request(), response.webSocketUpgradeResponse, null)));
        for (Interceptor interceptor : this.builder.getInterceptors().values()) {
            cf = cf.thenCompose(response -> {
                if (response.throwable != null) {
                    return interceptor.afterFailure(copy, response.webSocketUpgradeResponse, (Interceptor.RequestTags)this).thenCompose(b -> {
                        if (Boolean.TRUE.equals(b)) {
                            return this.buildWebSocketDirect(copy, listener);
                        }
                        CompletableFuture<WebSocketResponse> result = CompletableFuture.completedFuture(response);
                        result.thenAccept(r -> this.builder.getInterceptors().values().forEach(i -> i.after(r.webSocketUpgradeResponse.request(), r.webSocketUpgradeResponse, null)));
                        return result;
                    });
                }
                return CompletableFuture.completedFuture(response);
            });
        }
        return cf;
    }

    public <V> V getTag(Class<V> type) {
        return type.cast(this.builder.tags.get(type));
    }

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.doClose();
        }
    }

    protected abstract void doClose();

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    public AtomicBoolean getClosed() {
        return this.closed;
    }
}

