/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.api.networking.v1alpha3;

import io.fabric8.istio.api.api.analysis.v1alpha1.AnalysisMessageBase;
import io.fabric8.istio.api.api.analysis.v1alpha1.AnalysisMessageBaseBuilder;
import io.fabric8.istio.api.api.analysis.v1alpha1.AnalysisMessageBaseFluent;
import io.fabric8.istio.api.api.meta.v1alpha1.IstioCondition;
import io.fabric8.istio.api.api.meta.v1alpha1.IstioConditionBuilder;
import io.fabric8.istio.api.api.meta.v1alpha1.IstioConditionFluent;
import io.fabric8.istio.api.api.networking.v1alpha3.ServiceEntryAddress;
import io.fabric8.istio.api.api.networking.v1alpha3.ServiceEntryAddressBuilder;
import io.fabric8.istio.api.api.networking.v1alpha3.ServiceEntryAddressFluent;
import io.fabric8.istio.api.api.networking.v1alpha3.ServiceEntryStatus;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceEntryStatusFluent<A extends ServiceEntryStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ServiceEntryAddressBuilder> addresses = new ArrayList();
    private ArrayList<IstioConditionBuilder> conditions = new ArrayList();
    private Long observedGeneration;
    private ArrayList<AnalysisMessageBaseBuilder> validationMessages = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ServiceEntryStatusFluent() {
    }

    public ServiceEntryStatusFluent(ServiceEntryStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceEntryStatus instance) {
        ServiceEntryStatus serviceEntryStatus = instance = instance != null ? instance : new ServiceEntryStatus();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withValidationMessages(instance.getValidationMessages());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddresses(int index, ServiceEntryAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        ServiceEntryAddressBuilder builder = new ServiceEntryAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAddresses(int index, ServiceEntryAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        ServiceEntryAddressBuilder builder = new ServiceEntryAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(ServiceEntryAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (ServiceEntryAddress item : items) {
            ServiceEntryAddressBuilder builder = new ServiceEntryAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAddresses(Collection<ServiceEntryAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (ServiceEntryAddress item : items) {
            ServiceEntryAddressBuilder builder = new ServiceEntryAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(ServiceEntryAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (ServiceEntryAddress item : items) {
            ServiceEntryAddressBuilder builder = new ServiceEntryAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddresses(Collection<ServiceEntryAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (ServiceEntryAddress item : items) {
            ServiceEntryAddressBuilder builder = new ServiceEntryAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<ServiceEntryAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<ServiceEntryAddressBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            ServiceEntryAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ServiceEntryAddress> buildAddresses() {
        return this.addresses != null ? ServiceEntryStatusFluent.build(this.addresses) : null;
    }

    public ServiceEntryAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public ServiceEntryAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public ServiceEntryAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public ServiceEntryAddress buildMatchingAddress(Predicate<ServiceEntryAddressBuilder> predicate) {
        for (ServiceEntryAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<ServiceEntryAddressBuilder> predicate) {
        for (ServiceEntryAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<ServiceEntryAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (ServiceEntryAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(ServiceEntryAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (ServiceEntryAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addNewAddress(String host, String value) {
        return this.addToAddresses(new ServiceEntryAddress(host, value));
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(ServiceEntryAddress item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, ServiceEntryAddress item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<ServiceEntryAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public A addToConditions(int index, IstioCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        IstioConditionBuilder builder = new IstioConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, IstioCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        IstioConditionBuilder builder = new IstioConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(IstioCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (IstioCondition item : items) {
            IstioConditionBuilder builder = new IstioConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<IstioCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (IstioCondition item : items) {
            IstioConditionBuilder builder = new IstioConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(IstioCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (IstioCondition item : items) {
            IstioConditionBuilder builder = new IstioConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<IstioCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (IstioCondition item : items) {
            IstioConditionBuilder builder = new IstioConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<IstioConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<IstioConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            IstioConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<IstioCondition> buildConditions() {
        return this.conditions != null ? ServiceEntryStatusFluent.build(this.conditions) : null;
    }

    public IstioCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public IstioCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public IstioCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public IstioCondition buildMatchingCondition(Predicate<IstioConditionBuilder> predicate) {
        for (IstioConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<IstioConditionBuilder> predicate) {
        for (IstioConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<IstioCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (IstioCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(IstioCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (IstioCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(IstioCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, IstioCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<IstioConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToValidationMessages(int index, AnalysisMessageBase item) {
        if (this.validationMessages == null) {
            this.validationMessages = new ArrayList();
        }
        AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);
        if (index < 0 || index >= this.validationMessages.size()) {
            this._visitables.get((Object)"validationMessages").add(builder);
            this.validationMessages.add(builder);
        } else {
            this._visitables.get((Object)"validationMessages").add(builder);
            this.validationMessages.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToValidationMessages(int index, AnalysisMessageBase item) {
        if (this.validationMessages == null) {
            this.validationMessages = new ArrayList();
        }
        AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);
        if (index < 0 || index >= this.validationMessages.size()) {
            this._visitables.get((Object)"validationMessages").add(builder);
            this.validationMessages.add(builder);
        } else {
            this._visitables.get((Object)"validationMessages").add(builder);
            this.validationMessages.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToValidationMessages(AnalysisMessageBase ... items) {
        if (this.validationMessages == null) {
            this.validationMessages = new ArrayList();
        }
        for (AnalysisMessageBase item : items) {
            AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);
            this._visitables.get((Object)"validationMessages").add(builder);
            this.validationMessages.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToValidationMessages(Collection<AnalysisMessageBase> items) {
        if (this.validationMessages == null) {
            this.validationMessages = new ArrayList();
        }
        for (AnalysisMessageBase item : items) {
            AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);
            this._visitables.get((Object)"validationMessages").add(builder);
            this.validationMessages.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromValidationMessages(AnalysisMessageBase ... items) {
        if (this.validationMessages == null) {
            return (A)((Object)this);
        }
        for (AnalysisMessageBase item : items) {
            AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);
            this._visitables.get((Object)"validationMessages").remove((Object)builder);
            this.validationMessages.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromValidationMessages(Collection<AnalysisMessageBase> items) {
        if (this.validationMessages == null) {
            return (A)((Object)this);
        }
        for (AnalysisMessageBase item : items) {
            AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);
            this._visitables.get((Object)"validationMessages").remove((Object)builder);
            this.validationMessages.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromValidationMessages(Predicate<AnalysisMessageBaseBuilder> predicate) {
        if (this.validationMessages == null) {
            return (A)((Object)this);
        }
        Iterator<AnalysisMessageBaseBuilder> each = this.validationMessages.iterator();
        List visitables = this._visitables.get((Object)"validationMessages");
        while (each.hasNext()) {
            AnalysisMessageBaseBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AnalysisMessageBase> buildValidationMessages() {
        return this.validationMessages != null ? ServiceEntryStatusFluent.build(this.validationMessages) : null;
    }

    public AnalysisMessageBase buildValidationMessage(int index) {
        return this.validationMessages.get(index).build();
    }

    public AnalysisMessageBase buildFirstValidationMessage() {
        return this.validationMessages.get(0).build();
    }

    public AnalysisMessageBase buildLastValidationMessage() {
        return this.validationMessages.get(this.validationMessages.size() - 1).build();
    }

    public AnalysisMessageBase buildMatchingValidationMessage(Predicate<AnalysisMessageBaseBuilder> predicate) {
        for (AnalysisMessageBaseBuilder item : this.validationMessages) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingValidationMessage(Predicate<AnalysisMessageBaseBuilder> predicate) {
        for (AnalysisMessageBaseBuilder item : this.validationMessages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withValidationMessages(List<AnalysisMessageBase> validationMessages) {
        if (this.validationMessages != null) {
            this._visitables.get((Object)"validationMessages").clear();
        }
        if (validationMessages != null) {
            this.validationMessages = new ArrayList();
            for (AnalysisMessageBase item : validationMessages) {
                this.addToValidationMessages(item);
            }
        } else {
            this.validationMessages = null;
        }
        return (A)((Object)this);
    }

    public A withValidationMessages(AnalysisMessageBase ... validationMessages) {
        if (this.validationMessages != null) {
            this.validationMessages.clear();
            this._visitables.remove((Object)"validationMessages");
        }
        if (validationMessages != null) {
            for (AnalysisMessageBase item : validationMessages) {
                this.addToValidationMessages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasValidationMessages() {
        return this.validationMessages != null && !this.validationMessages.isEmpty();
    }

    public ValidationMessagesNested<A> addNewValidationMessage() {
        return new ValidationMessagesNested(-1, null);
    }

    public ValidationMessagesNested<A> addNewValidationMessageLike(AnalysisMessageBase item) {
        return new ValidationMessagesNested(-1, item);
    }

    public ValidationMessagesNested<A> setNewValidationMessageLike(int index, AnalysisMessageBase item) {
        return new ValidationMessagesNested(index, item);
    }

    public ValidationMessagesNested<A> editValidationMessage(int index) {
        if (this.validationMessages.size() <= index) {
            throw new RuntimeException("Can't edit validationMessages. Index exceeds size.");
        }
        return this.setNewValidationMessageLike(index, this.buildValidationMessage(index));
    }

    public ValidationMessagesNested<A> editFirstValidationMessage() {
        if (this.validationMessages.size() == 0) {
            throw new RuntimeException("Can't edit first validationMessages. The list is empty.");
        }
        return this.setNewValidationMessageLike(0, this.buildValidationMessage(0));
    }

    public ValidationMessagesNested<A> editLastValidationMessage() {
        int index = this.validationMessages.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last validationMessages. The list is empty.");
        }
        return this.setNewValidationMessageLike(index, this.buildValidationMessage(index));
    }

    public ValidationMessagesNested<A> editMatchingValidationMessage(Predicate<AnalysisMessageBaseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.validationMessages.size(); ++i) {
            if (!predicate.test(this.validationMessages.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching validationMessages. No match found.");
        }
        return this.setNewValidationMessageLike(index, this.buildValidationMessage(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceEntryStatusFluent that = (ServiceEntryStatusFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.validationMessages, that.validationMessages)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.observedGeneration, this.validationMessages, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(String.valueOf(this.addresses) + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.validationMessages != null && !this.validationMessages.isEmpty()) {
            sb.append("validationMessages:");
            sb.append(String.valueOf(this.validationMessages) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ValidationMessagesNested<N>
    extends AnalysisMessageBaseFluent<ValidationMessagesNested<N>>
    implements Nested<N> {
        AnalysisMessageBaseBuilder builder;
        int index;

        ValidationMessagesNested(int index, AnalysisMessageBase item) {
            this.index = index;
            this.builder = new AnalysisMessageBaseBuilder(this, item);
        }

        public N and() {
            return (N)ServiceEntryStatusFluent.this.setToValidationMessages(this.index, this.builder.build());
        }

        public N endValidationMessage() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends IstioConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        IstioConditionBuilder builder;
        int index;

        ConditionsNested(int index, IstioCondition item) {
            this.index = index;
            this.builder = new IstioConditionBuilder(this, item);
        }

        public N and() {
            return (N)ServiceEntryStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends ServiceEntryAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        ServiceEntryAddressBuilder builder;
        int index;

        AddressesNested(int index, ServiceEntryAddress item) {
            this.index = index;
            this.builder = new ServiceEntryAddressBuilder(this, item);
        }

        public N and() {
            return (N)ServiceEntryStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

