/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.api.networking.v1alpha3;

import io.fabric8.istio.api.api.networking.v1alpha3.ServiceEntry;
import io.fabric8.istio.api.api.networking.v1alpha3.ServiceEntryLocation;
import io.fabric8.istio.api.api.networking.v1alpha3.ServiceEntryResolution;
import io.fabric8.istio.api.api.networking.v1alpha3.ServicePort;
import io.fabric8.istio.api.api.networking.v1alpha3.ServicePortBuilder;
import io.fabric8.istio.api.api.networking.v1alpha3.ServicePortFluent;
import io.fabric8.istio.api.api.networking.v1alpha3.WorkloadEntry;
import io.fabric8.istio.api.api.networking.v1alpha3.WorkloadEntryBuilder;
import io.fabric8.istio.api.api.networking.v1alpha3.WorkloadEntryFluent;
import io.fabric8.istio.api.api.networking.v1alpha3.WorkloadSelector;
import io.fabric8.istio.api.api.networking.v1alpha3.WorkloadSelectorBuilder;
import io.fabric8.istio.api.api.networking.v1alpha3.WorkloadSelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServiceEntryFluent<A extends ServiceEntryFluent<A>>
extends BaseFluent<A> {
    private List<String> addresses = new ArrayList<String>();
    private ArrayList<WorkloadEntryBuilder> endpoints = new ArrayList();
    private List<String> exportTo = new ArrayList<String>();
    private List<String> hosts = new ArrayList<String>();
    private ServiceEntryLocation location;
    private ArrayList<ServicePortBuilder> ports = new ArrayList();
    private ServiceEntryResolution resolution;
    private List<String> subjectAltNames = new ArrayList<String>();
    private WorkloadSelectorBuilder workloadSelector;
    private Map<String, Object> additionalProperties;

    public ServiceEntryFluent() {
    }

    public ServiceEntryFluent(ServiceEntry instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceEntry instance) {
        ServiceEntry serviceEntry = instance = instance != null ? instance : new ServiceEntry();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withEndpoints(instance.getEndpoints());
            this.withExportTo(instance.getExportTo());
            this.withHosts(instance.getHosts());
            this.withLocation(instance.getLocation());
            this.withPorts(instance.getPorts());
            this.withResolution(instance.getResolution());
            this.withSubjectAltNames(instance.getSubjectAltNames());
            this.withWorkloadSelector(instance.getWorkloadSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToAddresses(String ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAddresses(Collection<String> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(String ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddresses(Collection<String> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public String getAddress(int index) {
        return this.addresses.get(index);
    }

    public String getFirstAddress() {
        return this.addresses.get(0);
    }

    public String getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    public String getMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<String> addresses) {
        if (addresses != null) {
            this.addresses = new ArrayList<String>();
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(String ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addToEndpoints(int index, WorkloadEntry item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        WorkloadEntryBuilder builder = new WorkloadEntryBuilder(item);
        if (index < 0 || index >= this.endpoints.size()) {
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        } else {
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEndpoints(int index, WorkloadEntry item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        WorkloadEntryBuilder builder = new WorkloadEntryBuilder(item);
        if (index < 0 || index >= this.endpoints.size()) {
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        } else {
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEndpoints(WorkloadEntry ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (WorkloadEntry item : items) {
            WorkloadEntryBuilder builder = new WorkloadEntryBuilder(item);
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEndpoints(Collection<WorkloadEntry> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (WorkloadEntry item : items) {
            WorkloadEntryBuilder builder = new WorkloadEntryBuilder(item);
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEndpoints(WorkloadEntry ... items) {
        if (this.endpoints == null) {
            return (A)((Object)this);
        }
        for (WorkloadEntry item : items) {
            WorkloadEntryBuilder builder = new WorkloadEntryBuilder(item);
            this._visitables.get((Object)"endpoints").remove((Object)builder);
            this.endpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEndpoints(Collection<WorkloadEntry> items) {
        if (this.endpoints == null) {
            return (A)((Object)this);
        }
        for (WorkloadEntry item : items) {
            WorkloadEntryBuilder builder = new WorkloadEntryBuilder(item);
            this._visitables.get((Object)"endpoints").remove((Object)builder);
            this.endpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEndpoints(Predicate<WorkloadEntryBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)((Object)this);
        }
        Iterator<WorkloadEntryBuilder> each = this.endpoints.iterator();
        List visitables = this._visitables.get((Object)"endpoints");
        while (each.hasNext()) {
            WorkloadEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<WorkloadEntry> buildEndpoints() {
        return this.endpoints != null ? ServiceEntryFluent.build(this.endpoints) : null;
    }

    public WorkloadEntry buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    public WorkloadEntry buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    public WorkloadEntry buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    public WorkloadEntry buildMatchingEndpoint(Predicate<WorkloadEntryBuilder> predicate) {
        for (WorkloadEntryBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEndpoint(Predicate<WorkloadEntryBuilder> predicate) {
        for (WorkloadEntryBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEndpoints(List<WorkloadEntry> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get((Object)"endpoints").clear();
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList();
            for (WorkloadEntry item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)((Object)this);
    }

    public A withEndpoints(WorkloadEntry ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
            this._visitables.remove((Object)"endpoints");
        }
        if (endpoints != null) {
            for (WorkloadEntry item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    public EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNested(-1, null);
    }

    public EndpointsNested<A> addNewEndpointLike(WorkloadEntry item) {
        return new EndpointsNested(-1, item);
    }

    public EndpointsNested<A> setNewEndpointLike(int index, WorkloadEntry item) {
        return new EndpointsNested(index, item);
    }

    public EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    public EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public EndpointsNested<A> editMatchingEndpoint(Predicate<WorkloadEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.test(this.endpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public A addToExportTo(int index, String item) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        this.exportTo.add(index, item);
        return (A)((Object)this);
    }

    public A setToExportTo(int index, String item) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        this.exportTo.set(index, item);
        return (A)((Object)this);
    }

    public A addToExportTo(String ... items) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        for (String item : items) {
            this.exportTo.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExportTo(Collection<String> items) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        for (String item : items) {
            this.exportTo.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExportTo(String ... items) {
        if (this.exportTo == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.exportTo.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExportTo(Collection<String> items) {
        if (this.exportTo == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.exportTo.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExportTo() {
        return this.exportTo;
    }

    public String getExportTo(int index) {
        return this.exportTo.get(index);
    }

    public String getFirstExportTo() {
        return this.exportTo.get(0);
    }

    public String getLastExportTo() {
        return this.exportTo.get(this.exportTo.size() - 1);
    }

    public String getMatchingExportTo(Predicate<String> predicate) {
        for (String item : this.exportTo) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExportTo(Predicate<String> predicate) {
        for (String item : this.exportTo) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExportTo(List<String> exportTo) {
        if (exportTo != null) {
            this.exportTo = new ArrayList<String>();
            for (String item : exportTo) {
                this.addToExportTo(item);
            }
        } else {
            this.exportTo = null;
        }
        return (A)((Object)this);
    }

    public A withExportTo(String ... exportTo) {
        if (this.exportTo != null) {
            this.exportTo.clear();
            this._visitables.remove((Object)"exportTo");
        }
        if (exportTo != null) {
            for (String item : exportTo) {
                this.addToExportTo(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExportTo() {
        return this.exportTo != null && !this.exportTo.isEmpty();
    }

    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)((Object)this);
    }

    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)((Object)this);
    }

    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromHosts(String ... items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHosts(Collection<String> items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getHost(int index) {
        return this.hosts.get(index);
    }

    public String getFirstHost() {
        return this.hosts.get(0);
    }

    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHosts(List<String> hosts) {
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)((Object)this);
    }

    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
            this._visitables.remove((Object)"hosts");
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    public ServiceEntryLocation getLocation() {
        return this.location;
    }

    public A withLocation(ServiceEntryLocation location) {
        this.location = location;
        return (A)((Object)this);
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public A addToPorts(int index, ServicePort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        ServicePortBuilder builder = new ServicePortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPorts(int index, ServicePort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        ServicePortBuilder builder = new ServicePortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(ServicePort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPorts(Collection<ServicePort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(ServicePort ... items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPorts(Collection<ServicePort> items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPorts(Predicate<ServicePortBuilder> predicate) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        Iterator<ServicePortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            ServicePortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ServicePort> buildPorts() {
        return this.ports != null ? ServiceEntryFluent.build(this.ports) : null;
    }

    public ServicePort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public ServicePort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public ServicePort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public ServicePort buildMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<ServicePort> ports) {
        if (this.ports != null) {
            this._visitables.get((Object)"ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)((Object)this);
    }

    public A withPorts(ServicePort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove((Object)"ports");
        }
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public A addNewPort(String name, Long number, String protocol, Long targetPort) {
        return this.addToPorts(new ServicePort(name, number, protocol, targetPort));
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(ServicePort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, ServicePort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<ServicePortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public ServiceEntryResolution getResolution() {
        return this.resolution;
    }

    public A withResolution(ServiceEntryResolution resolution) {
        this.resolution = resolution;
        return (A)((Object)this);
    }

    public boolean hasResolution() {
        return this.resolution != null;
    }

    public A addToSubjectAltNames(int index, String item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToSubjectAltNames(int index, String item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToSubjectAltNames(String ... items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.subjectAltNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSubjectAltNames(Collection<String> items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.subjectAltNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSubjectAltNames(String ... items) {
        if (this.subjectAltNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.subjectAltNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubjectAltNames(Collection<String> items) {
        if (this.subjectAltNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.subjectAltNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSubjectAltNames() {
        return this.subjectAltNames;
    }

    public String getSubjectAltName(int index) {
        return this.subjectAltNames.get(index);
    }

    public String getFirstSubjectAltName() {
        return this.subjectAltNames.get(0);
    }

    public String getLastSubjectAltName() {
        return this.subjectAltNames.get(this.subjectAltNames.size() - 1);
    }

    public String getMatchingSubjectAltName(Predicate<String> predicate) {
        for (String item : this.subjectAltNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSubjectAltName(Predicate<String> predicate) {
        for (String item : this.subjectAltNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjectAltNames(List<String> subjectAltNames) {
        if (subjectAltNames != null) {
            this.subjectAltNames = new ArrayList<String>();
            for (String item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        } else {
            this.subjectAltNames = null;
        }
        return (A)((Object)this);
    }

    public A withSubjectAltNames(String ... subjectAltNames) {
        if (this.subjectAltNames != null) {
            this.subjectAltNames.clear();
            this._visitables.remove((Object)"subjectAltNames");
        }
        if (subjectAltNames != null) {
            for (String item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSubjectAltNames() {
        return this.subjectAltNames != null && !this.subjectAltNames.isEmpty();
    }

    public WorkloadSelector buildWorkloadSelector() {
        return this.workloadSelector != null ? this.workloadSelector.build() : null;
    }

    public A withWorkloadSelector(WorkloadSelector workloadSelector) {
        this._visitables.remove((Object)"workloadSelector");
        if (workloadSelector != null) {
            this.workloadSelector = new WorkloadSelectorBuilder(workloadSelector);
            this._visitables.get((Object)"workloadSelector").add(this.workloadSelector);
        } else {
            this.workloadSelector = null;
            this._visitables.get((Object)"workloadSelector").remove((Object)this.workloadSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasWorkloadSelector() {
        return this.workloadSelector != null;
    }

    public WorkloadSelectorNested<A> withNewWorkloadSelector() {
        return new WorkloadSelectorNested(null);
    }

    public WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item) {
        return new WorkloadSelectorNested(item);
    }

    public WorkloadSelectorNested<A> editWorkloadSelector() {
        return this.withNewWorkloadSelectorLike(Optional.ofNullable(this.buildWorkloadSelector()).orElse(null));
    }

    public WorkloadSelectorNested<A> editOrNewWorkloadSelector() {
        return this.withNewWorkloadSelectorLike(Optional.ofNullable(this.buildWorkloadSelector()).orElse(new WorkloadSelectorBuilder().build()));
    }

    public WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item) {
        return this.withNewWorkloadSelectorLike(Optional.ofNullable(this.buildWorkloadSelector()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceEntryFluent that = (ServiceEntryFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.endpoints, that.endpoints)) {
            return false;
        }
        if (!Objects.equals(this.exportTo, that.exportTo)) {
            return false;
        }
        if (!Objects.equals(this.hosts, that.hosts)) {
            return false;
        }
        if (!Objects.equals((Object)this.location, (Object)that.location)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals((Object)this.resolution, (Object)that.resolution)) {
            return false;
        }
        if (!Objects.equals(this.subjectAltNames, that.subjectAltNames)) {
            return false;
        }
        if (!Objects.equals((Object)this.workloadSelector, (Object)that.workloadSelector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addresses, this.endpoints, this.exportTo, this.hosts, this.location, this.ports, this.resolution, this.subjectAltNames, this.workloadSelector, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(String.valueOf(this.addresses) + ",");
        }
        if (this.endpoints != null && !this.endpoints.isEmpty()) {
            sb.append("endpoints:");
            sb.append(String.valueOf(this.endpoints) + ",");
        }
        if (this.exportTo != null && !this.exportTo.isEmpty()) {
            sb.append("exportTo:");
            sb.append(String.valueOf(this.exportTo) + ",");
        }
        if (this.hosts != null && !this.hosts.isEmpty()) {
            sb.append("hosts:");
            sb.append(String.valueOf(this.hosts) + ",");
        }
        if (this.location != null) {
            sb.append("location:");
            sb.append(String.valueOf((Object)this.location) + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(String.valueOf(this.ports) + ",");
        }
        if (this.resolution != null) {
            sb.append("resolution:");
            sb.append(String.valueOf((Object)this.resolution) + ",");
        }
        if (this.subjectAltNames != null && !this.subjectAltNames.isEmpty()) {
            sb.append("subjectAltNames:");
            sb.append(String.valueOf(this.subjectAltNames) + ",");
        }
        if (this.workloadSelector != null) {
            sb.append("workloadSelector:");
            sb.append(String.valueOf((Object)this.workloadSelector) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WorkloadSelectorNested<N>
    extends WorkloadSelectorFluent<WorkloadSelectorNested<N>>
    implements Nested<N> {
        WorkloadSelectorBuilder builder;

        WorkloadSelectorNested(WorkloadSelector item) {
            this.builder = new WorkloadSelectorBuilder(this, item);
        }

        public N and() {
            return (N)ServiceEntryFluent.this.withWorkloadSelector(this.builder.build());
        }

        public N endWorkloadSelector() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends ServicePortFluent<PortsNested<N>>
    implements Nested<N> {
        ServicePortBuilder builder;
        int index;

        PortsNested(int index, ServicePort item) {
            this.index = index;
            this.builder = new ServicePortBuilder(this, item);
        }

        public N and() {
            return (N)ServiceEntryFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class EndpointsNested<N>
    extends WorkloadEntryFluent<EndpointsNested<N>>
    implements Nested<N> {
        WorkloadEntryBuilder builder;
        int index;

        EndpointsNested(int index, WorkloadEntry item) {
            this.index = index;
            this.builder = new WorkloadEntryBuilder(this, item);
        }

        public N and() {
            return (N)ServiceEntryFluent.this.setToEndpoints(this.index, this.builder.build());
        }

        public N endEndpoint() {
            return this.and();
        }
    }
}

