/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.api.networking.v1alpha3;

import io.fabric8.istio.api.api.networking.v1alpha3.Destination;
import io.fabric8.istio.api.api.networking.v1alpha3.PortSelector;
import io.fabric8.istio.api.api.networking.v1alpha3.PortSelectorBuilder;
import io.fabric8.istio.api.api.networking.v1alpha3.PortSelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DestinationFluent<A extends DestinationFluent<A>>
extends BaseFluent<A> {
    private String host;
    private PortSelectorBuilder port;
    private String subset;
    private Map<String, Object> additionalProperties;

    public DestinationFluent() {
    }

    public DestinationFluent(Destination instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Destination instance) {
        Destination destination = instance = instance != null ? instance : new Destination();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withPort(instance.getPort());
            this.withSubset(instance.getSubset());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public PortSelector buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(PortSelector port) {
        this._visitables.remove((Object)"port");
        if (port != null) {
            this.port = new PortSelectorBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get((Object)"port").remove((Object)this.port);
        }
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(Long number) {
        return this.withPort(new PortSelector(number));
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(PortSelector item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new PortSelectorBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(PortSelector item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public String getSubset() {
        return this.subset;
    }

    public A withSubset(String subset) {
        this.subset = subset;
        return (A)((Object)this);
    }

    public boolean hasSubset() {
        return this.subset != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DestinationFluent that = (DestinationFluent)((Object)o);
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals((Object)this.port, (Object)that.port)) {
            return false;
        }
        if (!Objects.equals(this.subset, that.subset)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.port, this.subset, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(String.valueOf((Object)this.port) + ",");
        }
        if (this.subset != null) {
            sb.append("subset:");
            sb.append(this.subset + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortNested<N>
    extends PortSelectorFluent<PortNested<N>>
    implements Nested<N> {
        PortSelectorBuilder builder;

        PortNested(PortSelector item) {
            this.builder = new PortSelectorBuilder(this, item);
        }

        public N and() {
            return (N)DestinationFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

